/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSpecification;
import org.powertac.common.repo.TariffRepo;

public class BrokerUtils {
    private static Logger log = Logger.getLogger(BrokerUtils.class);

    public static ArrayRealVector rotateWeeklyRecordAndAppendTillEndOfDay(RealVector record, int currentTimeslot) {
        int predictionStartWeeklyHour = (currentTimeslot + 1) % 168;
        ArrayRealVector copy = new ArrayRealVector(record.getDimension());
        RealVector slice1 = record.getSubVector(predictionStartWeeklyHour, record.getDimension() - predictionStartWeeklyHour);
        RealVector slice2 = record.getSubVector(0, predictionStartWeeklyHour);
        copy.setSubVector(0, slice1);
        copy.setSubVector(slice1.getDimension(), slice2);
        int predictionStartDailyHour = predictionStartWeeklyHour % 24;
        if (predictionStartDailyHour != 0) {
            int timeToEndOfTheDay = 24 - predictionStartDailyHour;
            copy.append(record.getSubVector(predictionStartWeeklyHour, timeToEndOfTheDay));
        }
        return copy;
    }

    public static int getNumIndividualCustomers(HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions) {
        int total = 0;
        for (HashMap<CustomerInfo, Integer> subscriptions : tariffSubscriptions.values()) {
            for (Integer numCustomers : subscriptions.values()) {
                total += numCustomers.intValue();
            }
        }
        return total;
    }

    public static <K1, K2, V> HashMap<K2, HashMap<K1, V>> revertKeyMapping(HashMap<K1, HashMap<K2, V>> twoLevelMap) {
        HashMap<K2, HashMap<K1, V>> result = new HashMap<K2, HashMap<K1, V>>();
        for (Map.Entry<K1, HashMap<K2, V>> entry : twoLevelMap.entrySet()) {
            K1 key1 = entry.getKey();
            HashMap<K2, V> keyvals = entry.getValue();
            for (Map.Entry<K2, V> e : keyvals.entrySet()) {
                K2 key2 = e.getKey();
                V value = e.getValue();
                HashMap<K1, V> current = (HashMap<K1, V>)result.get(key2);
                if (current == null) {
                    current = new HashMap<K1, V>();
                    result.put(key2, current);
                }
                current.put(key1, value);
            }
        }
        return result;
    }

    public static boolean addToRepo(TariffSpecification spec, TariffRepo tariffRepo) {
        if (null == spec || null == tariffRepo) {
            log.error("Cannot add spec to repo using null parameters");
        }
        tariffRepo.addSpecification(spec);
        Tariff tariff = new Tariff(spec);
        boolean success = tariff.init();
        if (!success) {
            log.warn("failed to add to tariffRepo: " + spec.getId());
            tariffRepo.removeTariff(tariff);
        }
        return success;
    }

    public static void removeFromRepo(Tariff tariff, TariffRepo tariffRepo) {
        tariffRepo.removeTariff(tariff);
    }

    public static <T> void insertToSortedArrayList(ArrayList<T> list, T value) {
        list.add(value);
        Comparable cmp = (Comparable)value;
        for (int i = list.size() - 1; i > 0 && cmp.compareTo(list.get(i - 1)) < 0; --i) {
            Collections.swap(list, i, i - 1);
        }
    }
}

