/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSpecification;
import org.powertac.common.repo.TariffRepo;
import org.powertac.samplebroker.interfaces.ChargeEstimator;

public class ChargeEstimatorDefault
implements ChargeEstimator {
    private static Logger log = Logger.getLogger(ChargeEstimatorDefault.class);
    private TariffRepo tariffRepo;

    public ChargeEstimatorDefault(TariffRepo tariffRepo) {
        this.tariffRepo = tariffRepo;
    }

    @Override
    public HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> estimateTariffCharges(List<TariffSpecification> tariffSpecs, HashMap<CustomerInfo, ArrayRealVector> customer2energy) {
        HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> estimatedCharges = new HashMap<CustomerInfo, HashMap<TariffSpecification, Double>>();
        for (CustomerInfo customerInfo : customer2energy.keySet()) {
            HashMap<TariffSpecification, Double> tariffEvaluations = new HashMap<TariffSpecification, Double>();
            for (TariffSpecification spec : tariffSpecs) {
                double evaluation = this.estimateCharge(customer2energy.get(customerInfo), spec);
                tariffEvaluations.put(spec, evaluation);
            }
            estimatedCharges.put(customerInfo, tariffEvaluations);
        }
        return estimatedCharges;
    }

    @Override
    public double estimateCharge(ArrayRealVector customerEnergy, TariffSpecification spec) {
        TariffEvaluationHelper helper = new TariffEvaluationHelper();
        helper.init();
        Tariff tariff = this.tariffRepo.findTariffById(spec.getId());
        if (null == tariff) {
            log.error("failed to find spec in repo, spec-id: " + spec.getId());
            return -1.7976931348623157E308;
        }
        double evaluation = helper.estimateCost(tariff, customerEnergy.toArray(), true);
        return evaluation;
    }
}

