/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.samplebroker.ChargeEstimatorDefault;
import org.powertac.samplebroker.ConsumptionTariffSuggestionMakerFixedRates;
import org.powertac.samplebroker.StochasticConsumptionTariffGenerator;
import org.powertac.samplebroker.UtilityEstimatorDefaultForConsumption;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.ChargeEstimator;
import org.powertac.samplebroker.interfaces.ConsumptionTariffGenerator;
import org.powertac.samplebroker.interfaces.ConsumptionTariffSuggestionMaker;
import org.powertac.samplebroker.interfaces.ContextManager;
import org.powertac.samplebroker.interfaces.CustomerPredictionManager;
import org.powertac.samplebroker.interfaces.EnergyPredictionManager;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.MarketManager;
import org.powertac.samplebroker.interfaces.MarketPredictionManager;
import org.powertac.samplebroker.interfaces.PortfolioManager;
import org.powertac.samplebroker.interfaces.UtilityEstimator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfiguratorFactoryService
implements Initializable {
    @Autowired
    private PortfolioManager portfolioManager;
    @Autowired
    private MarketManager marketManager;
    @Autowired
    private EnergyPredictionManager energyPredictionManager;
    @Autowired
    private MarketPredictionManager marketPredictionManager;
    @Autowired
    private CustomerPredictionManager customerPredictionManager;
    @Autowired
    private ContextManager contextManager;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TariffRepo tariffRepo;
    final GlobalConstants CONSTANTS = new GlobalConstants();
    private ConsumptionTariffSuggestionMaker consumptionTariffSuggestionMaker;
    private ChargeEstimator chargeEstimator;
    private UtilityEstimator utilityEstimator;
    private ConsumptionTariffGenerator consumptionTariffGenerator;
    private boolean logging = false;
    private boolean useMtx = true;
    private boolean useLWR = true;
    private boolean useDP = true;
    private boolean useInitialTariffs = true;
    private boolean shouldDisguiseSpecs = false;

    @Override
    public void initialize(BrokerContext broker) {
        File params;
        if (!this.isLogging()) {
            this.turnOffLogging();
        }
        if ((params = new File("params.txt")).exists()) {
            try {
                FileReader input = new FileReader(params);
                BufferedReader bufRead = new BufferedReader(input);
                String myLine = null;
                while ((myLine = bufRead.readLine()) != null) {
                    String[] paramVal = myLine.split(" ");
                    String param = paramVal[0];
                    String value = paramVal[1];
                    System.out.println("Parsing: " + myLine);
                    if (param.equals("usemtx")) {
                        this.useMtx = Boolean.parseBoolean(value);
                        System.out.println("usemtx: " + this.useMtx);
                    }
                    if (param.equals("uselwr")) {
                        this.useLWR = Boolean.parseBoolean(value);
                        System.out.println("uselwr: " + this.useLWR);
                    }
                    if (param.equals("usedp")) {
                        this.useDP = Boolean.parseBoolean(value);
                        System.out.println("usedp: " + this.useDP);
                    }
                    if (!param.equals("useinitialtariffs")) continue;
                    this.useInitialTariffs = Boolean.parseBoolean(value);
                    System.out.println("useinitialtariffs: " + this.useInitialTariffs);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.consumptionTariffSuggestionMaker = new ConsumptionTariffSuggestionMakerFixedRates();
        this.chargeEstimator = new ChargeEstimatorDefault(this.tariffRepo);
        this.utilityEstimator = new UtilityEstimatorDefaultForConsumption(this.tariffRepo, this.customerRepo, this.contextManager, this.customerPredictionManager, this.chargeEstimator);
        this.consumptionTariffGenerator = new StochasticConsumptionTariffGenerator(this.energyPredictionManager, this.marketPredictionManager, this.consumptionTariffSuggestionMaker, this.utilityEstimator, this.tariffRepo);
    }

    private void turnOffLogging() {
        ArrayList<Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
        loggers.add(LogManager.getRootLogger());
        for (Logger logger : loggers) {
            logger.setLevel(Level.OFF);
        }
    }

    public PortfolioManager getPortfolioManager() {
        return this.portfolioManager;
    }

    public MarketManager getMarketManager() {
        return this.marketManager;
    }

    public EnergyPredictionManager getEnergyPredictionManager() {
        return this.energyPredictionManager;
    }

    public MarketPredictionManager getMarketPredictionManager() {
        return this.marketPredictionManager;
    }

    public CustomerPredictionManager getCustomerPredictionManager() {
        return this.customerPredictionManager;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public CustomerRepo getCustomerRepo() {
        return this.customerRepo;
    }

    public TariffRepo getTariffRepo() {
        return this.tariffRepo;
    }

    public ConsumptionTariffSuggestionMaker getConsumptionTariffSuggestionMaker() {
        return this.consumptionTariffSuggestionMaker;
    }

    public ChargeEstimator getChargeEstimator() {
        return this.chargeEstimator;
    }

    public UtilityEstimator getUtilityEstimaor() {
        return this.utilityEstimator;
    }

    public ConsumptionTariffGenerator getConsumptionTariffGenerator() {
        return this.consumptionTariffGenerator;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public boolean isUseMtx() {
        return this.useMtx;
    }

    public boolean isUseLWR() {
        return this.useLWR;
    }

    public boolean isUseDP() {
        return this.useDP;
    }

    public boolean isUseInitialTariffs() {
        return this.useInitialTariffs;
    }

    public boolean disguiseSpecs() {
        return this.shouldDisguiseSpecs;
    }

    public class GlobalConstants {
        private double MARKET_TRADES_ALPHA = 0.3;
        private int USAGE_RECORD_LENGTH = 168;
        private int LARGE_ENOUGH_SAMPLE_FOR_MARKET_TRADES = 6;

        double MARKET_TRADES_ALPHA() {
            return this.MARKET_TRADES_ALPHA;
        }

        int USAGE_RECORD_LENGTH() {
            return this.USAGE_RECORD_LENGTH;
        }

        public int LARGE_ENOUGH_SAMPLE_FOR_MARKET_TRADES() {
            return this.LARGE_ENOUGH_SAMPLE_FOR_MARKET_TRADES;
        }
    }
}

