/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.enumerations.PowerType;
import org.powertac.samplebroker.interfaces.ConsumptionTariffSuggestionMaker;
import org.powertac.samplebroker.interfaces.ContextManager;
import org.powertac.samplebroker.interfaces.MarketManager;

public class ConsumptionTariffSuggestionMakerFixedRates
implements ConsumptionTariffSuggestionMaker {
    private static Logger log = Logger.getLogger(ConsumptionTariffSuggestionMakerFixedRates.class);

    @Override
    public List<TariffSpecification> suggestTariffs(HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions, List<TariffSpecification> competingTariffs, MarketManager marketManager, ContextManager contextManager, Broker me) {
        double meanMarketPrice = -marketManager.getMeanMarketPricePerKWH();
        double stdMarketPrice = marketManager.getMarketPricePerKWHRecordStd();
        double distributionFee = contextManager.getDistributionFee();
        double marketBasedBound = meanMarketPrice + distributionFee - 1.96 * stdMarketPrice;
        double competingBestRateValue = this.getCompetingBestRateValue(competingTariffs, marketBasedBound, me);
        double myBestRateValue = this.getMyBestRateValue(tariffSubscriptions, me);
        ArrayList<TariffSpecification> suggestedTariffs = new ArrayList<TariffSpecification>();
        if (myBestRateValue <= competingBestRateValue && competingBestRateValue < marketBasedBound) {
            double highRate = Math.max(competingBestRateValue, myBestRateValue);
            double lowRate = Math.min(competingBestRateValue, myBestRateValue);
            double bestSuggestRate = marketBasedBound + 0.8 * (lowRate - marketBasedBound);
            double worstSuggestedRate = marketBasedBound + 1.2 * (highRate - marketBasedBound);
            int numTariffs = 100;
            double delta = (worstSuggestedRate - bestSuggestRate) / (double)(numTariffs - 1);
            for (int i = 0; i < numTariffs; ++i) {
                double rateValue = bestSuggestRate + (double)i * delta;
                Rate rate = new Rate().withValue(rateValue);
                TariffSpecification spec = new TariffSpecification(me, PowerType.CONSUMPTION);
                spec.addRate(rate);
                suggestedTariffs.add(spec);
            }
        }
        return suggestedTariffs;
    }

    private double getMyBestRateValue(HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions, Broker me) {
        double myMinRateValue = -1.7976931348623157E308;
        for (TariffSpecification spec : tariffSubscriptions.keySet()) {
            if (spec.getBroker() != me) continue;
            for (Rate r : spec.getRates()) {
                double value = r.isFixed() ? r.getMinValue() : r.getExpectedMean();
                if (!(value > myMinRateValue)) continue;
                myMinRateValue = value;
            }
        }
        if (myMinRateValue == -1.7976931348623157E308) {
            log.error("There must be at least one consumption tariff I suggested");
        }
        return myMinRateValue;
    }

    private double getCompetingBestRateValue(List<TariffSpecification> competingTariffs, double marketBasedBound, Broker me) {
        double competingBestRateValue = -1.7976931348623157E308;
        for (TariffSpecification competingTariff : competingTariffs) {
            Broker theBroker = competingTariff.getBroker();
            if (!me.getUsername().equals(theBroker.getUsername())) {
                for (Rate r : competingTariff.getRates()) {
                    double value = r.isFixed() ? r.getMinValue() : r.getExpectedMean();
                    if (!(competingBestRateValue < value) || !(value < marketBasedBound)) continue;
                    competingBestRateValue = value;
                }
                continue;
            }
            log.error("How come our tariff appears at competingTariffs?");
        }
        if (competingBestRateValue == -1.7976931348623157E308) {
            log.error("There must be at least one consumption tariff someone suggested");
        }
        return competingBestRateValue;
    }
}

