/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.powertac.common.BankTransaction;
import org.powertac.common.CashPosition;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.msg.DistributionReport;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.ContextManager;
import org.powertac.samplebroker.interfaces.Initializable;
import org.springframework.stereotype.Service;

@Service
public class ContextManagerService
implements ContextManager,
Initializable {
    private static Logger log = Logger.getLogger(ContextManagerService.class);
    BrokerContext master;
    private double cash = 0.0;
    private double revocationFee;
    private double sellerSurplusRatio;
    private double pPlusPrime;
    private double defaultClearingPrice;
    private double defaultSpotPrice;
    private String settlementProcess;
    private double defaultMargin;
    private double bankInterest;
    private double balancingCost;
    private double publicationFee;
    private double distributionFee;
    private double pMinusPrime;
    private int totalNumberOfCustomers;
    private int totalNumberOfConsumers;
    private int totalNumberOfProducers;

    @Override
    public void initialize(BrokerContext broker) {
        this.master = broker;
        for (Class clazz : Arrays.asList(BankTransaction.class, CashPosition.class, DistributionReport.class, Competition.class, Properties.class)) {
            broker.registerMessageHandler(this, clazz);
        }
    }

    public void handleMessage(BankTransaction btx) {
    }

    public void handleMessage(CashPosition cp) {
        this.cash = cp.getBalance();
    }

    public void handleMessage(DistributionReport dr) {
    }

    public void handleMessage(Competition comp) {
        this.totalNumberOfCustomers = 0;
        for (CustomerInfo customer : comp.getCustomers()) {
            this.totalNumberOfCustomers += customer.getPopulation();
            if (customer.getPowerType().isConsumption()) {
                this.totalNumberOfConsumers += customer.getPopulation();
            }
            if (!customer.getPowerType().isProduction()) continue;
            this.totalNumberOfProducers += customer.getPopulation();
        }
    }

    public void handleMessage(Properties serverProps) {
        if (serverProps.size() != 12) {
            log.warn("Are there additional properties that I am not processing?");
        }
        this.revocationFee = Double.parseDouble(serverProps.getProperty("tariffmarket.tariffMarketService.revocationFee"));
        this.sellerSurplusRatio = Double.parseDouble(serverProps.getProperty("auctioneer.auctionService.sellerSurplusRatio"));
        this.pPlusPrime = Double.parseDouble(serverProps.getProperty("distributionutility.distributionUtilityService.pPlusPrime"));
        this.defaultClearingPrice = Double.parseDouble(serverProps.getProperty("auctioneer.auctionService.defaultClearingPrice"));
        this.defaultSpotPrice = Double.parseDouble(serverProps.getProperty("distributionutility.distributionUtilityService.defaultSpotPrice"));
        this.settlementProcess = serverProps.getProperty("distributionutility.distributionUtilityService.settlementProcess");
        this.defaultMargin = Double.parseDouble(serverProps.getProperty("auctioneer.auctionService.defaultMargin"));
        this.bankInterest = Double.parseDouble(serverProps.getProperty("accounting.accountingService.bankInterest"));
        this.balancingCost = Double.parseDouble(serverProps.getProperty("distributionutility.distributionUtilityService.balancingCost"));
        this.publicationFee = Double.parseDouble(serverProps.getProperty("tariffmarket.tariffMarketService.publicationFee"));
        this.distributionFee = Double.parseDouble(serverProps.getProperty("distributionutility.distributionUtilityService.distributionFee"));
        this.pMinusPrime = Double.parseDouble(serverProps.getProperty("distributionutility.distributionUtilityService.pMinusPrime"));
    }

    @Override
    public double getRevocationFee() {
        return this.revocationFee;
    }

    @Override
    public double getSellerSurplusRatio() {
        return this.sellerSurplusRatio;
    }

    @Override
    public double getPPlusPrime() {
        return this.pPlusPrime;
    }

    @Override
    public double getDefaultClearingPrice() {
        return this.defaultClearingPrice;
    }

    @Override
    public double getDefaultSpotPrice() {
        return this.defaultSpotPrice;
    }

    @Override
    public String getSettlementProcess() {
        return this.settlementProcess;
    }

    @Override
    public double getDefaultMargin() {
        return this.defaultMargin;
    }

    @Override
    public double getBankInterest() {
        return this.bankInterest;
    }

    @Override
    public double getBalancingCost() {
        return this.balancingCost;
    }

    @Override
    public double getPublicationFee() {
        return this.publicationFee;
    }

    @Override
    public double getDistributionFee() {
        return this.distributionFee;
    }

    @Override
    public double getPMinusPrime() {
        return this.pMinusPrime;
    }

    @Override
    public int getTotalNumberOfCustomers() {
        return this.totalNumberOfCustomers;
    }

    public int getTotalNumberOfConsumers() {
        return this.totalNumberOfConsumers;
    }

    public int getTotalNumberOfProducers() {
        return this.totalNumberOfProducers;
    }
}

