/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.msg.DistributionReport;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.samplebroker.BrokerUtils;
import org.powertac.samplebroker.interfaces.Activatable;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.EnergyPredictionManager;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.PortfolioManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnergyPredictionManagerService
implements Initializable,
Activatable,
EnergyPredictionManager {
    private static Logger log = Logger.getLogger(EnergyPredictionManagerService.class);
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private PortfolioManager portfolioManager;
    private BrokerContext broker;
    private HashMap<PowerType, HashMap<CustomerInfo, ArrayList<EnergyRecord>>> powerCustomer2Energy;
    private HashMap<PowerType, HashMap<CustomerInfo, ArrayList<ExtendedEnergyRecord>>> powerCustomer2ExtendedEnergy;
    private ArrayList<WeatherReport> weatherReports;
    private ArrayList<WeatherForecast> weatherForecasts;
    private ArrayList<TimeslotDistributionReport> distributionReports;
    private int weatherSlot = -1;

    @Override
    public void initialize(BrokerContext broker) {
        this.broker = broker;
        this.powerCustomer2Energy = new HashMap();
        this.powerCustomer2ExtendedEnergy = new HashMap();
        this.weatherReports = new ArrayList();
        this.weatherForecasts = new ArrayList();
        this.distributionReports = new ArrayList();
        for (Class messageType : Arrays.asList(CustomerBootstrapData.class, WeatherReport.class, WeatherForecast.class, DistributionReport.class, TariffTransaction.class)) {
            broker.registerMessageHandler(this, messageType);
        }
    }

    public void handleMessage(CustomerBootstrapData cbd) {
        CustomerInfo customer = this.customerRepo.findByNameAndPowerType(cbd.getCustomerName(), cbd.getPowerType());
        ArrayList<EnergyRecord> energy = this.getEnergyFromPowerTypeCustomer(cbd.getPowerType(), customer);
        int offset = Competition.currentCompetition().getBootstrapDiscardedTimeslots();
        for (int i = 0; i < cbd.getNetUsage().length; ++i) {
            int timeslot = offset + i;
            double timeslotUsage = cbd.getNetUsage()[i];
            energy.add(new EnergyRecord(timeslot, customer.getPopulation(), timeslotUsage));
        }
    }

    public void handleMessage(TariffTransaction ttx) {
        TariffTransaction.Type transactionType = ttx.getTxType();
        if (transactionType == TariffTransaction.Type.CONSUME || transactionType == TariffTransaction.Type.PRODUCE) {
            CustomerInfo customer = ttx.getCustomerInfo();
            PowerType powerType = customer.getPowerType();
            if (transactionType == TariffTransaction.Type.CONSUME && powerType.isConsumption() || transactionType == TariffTransaction.Type.PRODUCE && powerType.isProduction()) {
                ArrayList<ExtendedEnergyRecord> energy = this.getExtendedEnergyFromPowerTypeCustomer(powerType, customer);
                energy.add(new ExtendedEnergyRecord(this.timeslotRepo.findByInstant(ttx.getPostedTime()).getSerialNumber(), ttx.getCustomerCount(), ttx.getKWh(), ttx.getCharge(), ttx.getTariffSpec()));
                if (powerType != ttx.getTariffSpec().getPowerType()) {
                    // empty if block
                }
            }
        }
    }

    public void handleMessage(WeatherReport report) {
        this.weatherReports.add(report);
    }

    public void handleMessage(WeatherForecast forecast) {
        this.weatherForecasts.add(forecast);
    }

    public void handleMessage(DistributionReport report) {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        TimeslotDistributionReport tr = new TimeslotDistributionReport(current, report);
        this.distributionReports.add(tr);
    }

    @Override
    public void activate(int timeslot) {
        try {
            log.info("activate");
        }
        catch (Exception e) {
            log.error("caught exception from activate(): ", e);
        }
    }

    public ArrayList<EnergyRecord> getEnergyFromPowerTypeCustomer(PowerType powerType, CustomerInfo customer) {
        ArrayList<EnergyRecord> energy;
        HashMap<CustomerInfo, ArrayList<EnergyRecord>> customer2energy = this.powerCustomer2Energy.get(powerType);
        if (customer2energy == null) {
            customer2energy = new HashMap();
            this.powerCustomer2Energy.put(powerType, customer2energy);
        }
        if ((energy = customer2energy.get(customer)) == null) {
            energy = new ArrayList();
            customer2energy.put(customer, energy);
        }
        return energy;
    }

    public ArrayList<ExtendedEnergyRecord> getExtendedEnergyFromPowerTypeCustomer(PowerType powerType, CustomerInfo customer) {
        ArrayList<ExtendedEnergyRecord> energy;
        HashMap<CustomerInfo, ArrayList<ExtendedEnergyRecord>> customer2energy = this.powerCustomer2ExtendedEnergy.get(powerType);
        if (customer2energy == null) {
            customer2energy = new HashMap();
            this.powerCustomer2ExtendedEnergy.put(powerType, customer2energy);
        }
        if ((energy = customer2energy.get(customer)) == null) {
            log.info("Daniel: adding ExtendedEnergyRecord for " + powerType + ", " + customer);
            energy = new ArrayList();
            customer2energy.put(customer, energy);
        }
        return energy;
    }

    public WeatherReport getLastWeatherReport() {
        return this.weatherReports.get(this.weatherReports.size() - 1);
    }

    public WeatherForecast getLastWeatherForecast() {
        return this.weatherForecasts.get(this.weatherForecasts.size() - 1);
    }

    public TimeslotDistributionReport getLastDistributionReport() {
        return this.distributionReports.get(this.distributionReports.size() - 1);
    }

    @Override
    public ArrayRealVector getPredictionForAbout7Days(CustomerInfo customerInfo, boolean customerPerspective, int currentTimeslot) {
        int sign = customerPerspective ? -1 : 1;
        RealVector energy = this.portfolioManager.getGeneralRawUsageForCustomer(customerInfo).mapMultiply(sign);
        if (energy.getDimension() != 168) {
            log.error("Expecting energy dimension to be 7 * 24 - unexpected behavior might happen");
        }
        return BrokerUtils.rotateWeeklyRecordAndAppendTillEndOfDay(energy, currentTimeslot);
    }

    @Override
    public HashMap<CustomerInfo, ArrayRealVector> getAbout7dayPredictionForAllCustomers(boolean customerPerspective, int currentTimeslot) {
        HashMap<CustomerInfo, ArrayRealVector> result = new HashMap<CustomerInfo, ArrayRealVector>();
        for (CustomerInfo customer : this.customerRepo.list()) {
            result.put(customer, this.getPredictionForAbout7Days(customer, customerPerspective, currentTimeslot));
        }
        return result;
    }

    @Override
    public HashMap<CustomerInfo, ArrayRealVector> getAbout7dayPredictionForCustomersOfType(PowerType powerType, boolean useCanUse, boolean customerPerspective, int currentTimeslot) {
        HashMap<CustomerInfo, ArrayRealVector> result = new HashMap<CustomerInfo, ArrayRealVector>();
        for (CustomerInfo customer : this.customerRepo.list()) {
            if (customer.getPowerType() != powerType && (!useCanUse || !customer.getPowerType().canUse(powerType))) continue;
            result.put(customer, this.getPredictionForAbout7Days(customer, customerPerspective, currentTimeslot));
        }
        return result;
    }

    class TimeslotDistributionReport {
        public Timeslot timeslot;
        public DistributionReport distReport;

        public TimeslotDistributionReport(Timeslot current, DistributionReport report) {
            this.timeslot = current;
            this.distReport = report;
        }
    }

    class ExtendedEnergyRecord {
        int timeslot;
        int population;
        double energy;
        double charge;
        TariffSpecification tariffSpec;

        public ExtendedEnergyRecord(int timeslot, int population, double energy, double charge, TariffSpecification tariffSpec) {
            this.timeslot = timeslot;
            this.population = population;
            this.energy = energy;
            this.charge = charge;
            this.tariffSpec = tariffSpec;
        }
    }

    class EnergyRecord {
        int timeslot;
        int population;
        double energy;

        public EnergyRecord(int timeslot, int population, double energy) {
            this.timeslot = timeslot;
            this.population = population;
            this.energy = energy;
        }
    }
}

