/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.log4j.Logger;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Competition;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.TariffTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.common.msg.MarketBootstrapData;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.samplebroker.BrokerUtils;
import org.powertac.samplebroker.ConfiguratorFactoryService;
import org.powertac.samplebroker.interfaces.Activatable;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.MarketManager;
import org.powertac.samplebroker.interfaces.PortfolioManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketManagerService
implements MarketManager,
Initializable,
Activatable {
    private static Logger log = Logger.getLogger(MarketManagerService.class);
    private BrokerContext brokerContext;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private PortfolioManager portfolioManager;
    @Autowired
    private ConfiguratorFactoryService configuratorFactoryService;
    private Random randomGen = new Random();
    private double BUY_LIMIT_PRICE_MAX = -1.0;
    private double BUY_LIMIT_PRICE_MIN = -70.0;
    private double SELL_LIMIT_PRICE_MAX = 70.0;
    private double SELL_LIMIT_PRICE_MIN = 0.5;
    private static final double MIN_MWH = 0.001;
    private double marketTotalMwh;
    private double marketTotalPayments;
    private HashMap<Integer, Order> lastOrder;
    private double[] marketMWh;
    private double[] marketPayments;
    private double[][] predictedUsage;
    private double[] actualUsage;
    private HashMap<Integer, Orderbook> orderbooks;
    private double maxTradePrice;
    private double minTradePrice;
    private TreeMap<Integer, ArrayList<PriceMwhPair>> supportingBidGroups;
    private DPCache dpCache;
    private ArrayList<ChargeMwhPair> shortBalanceTransactionsData;

    @Override
    public void initialize(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.marketTotalMwh = 0.0;
        this.marketTotalPayments = 0.0;
        this.lastOrder = new HashMap();
        this.marketMWh = new double[this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH()];
        this.marketPayments = new double[this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH()];
        this.predictedUsage = new double[24][2500];
        this.actualUsage = new double[2500];
        this.orderbooks = new HashMap();
        this.maxTradePrice = -1.7976931348623157E308;
        this.minTradePrice = Double.MAX_VALUE;
        this.supportingBidGroups = new TreeMap();
        this.dpCache = new DPCache();
        this.shortBalanceTransactionsData = new ArrayList();
        for (Class messageType : Arrays.asList(BalancingTransaction.class, ClearedTrade.class, DistributionTransaction.class, MarketBootstrapData.class, MarketPosition.class, MarketTransaction.class, Orderbook.class, WeatherForecast.class, WeatherReport.class, TariffTransaction.class)) {
            brokerContext.registerMessageHandler(this, messageType);
        }
    }

    @Override
    public double getMeanMarketPricePerMWH() {
        if (this.marketTotalMwh == 0.0) {
            log.error("marketTotalMwh should not be 0");
            return 0.0;
        }
        log.info("getMeanMarketPricePerMWH() " + this.marketTotalPayments / this.marketTotalMwh);
        return this.marketTotalPayments / this.marketTotalMwh;
    }

    @Override
    public double getMeanMarketPricePerKWH() {
        return this.getMeanMarketPricePerMWH() / 1000.0;
    }

    @Override
    public double getMarketAvgPricePerSlotKWH(int timeslot) {
        int index = timeslot % this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH();
        double totalKWH = this.marketMWh[index] * 1000.0;
        double totalPayments = this.marketPayments[index];
        return totalPayments / totalKWH;
    }

    @Override
    public double getMarketPricePerKWHRecordStd() {
        ArrayRealVector marketAvgPricePerSlot = this.getMarketAvgPricesArrayKwh();
        return Math.sqrt(StatUtils.variance(marketAvgPricePerSlot.toArray()));
    }

    @Override
    public ArrayRealVector getMarketAvgPricesArrayKwh() {
        RealVector marketKWh_ = new ArrayRealVector(this.marketMWh).mapMultiplyToSelf(1000.0);
        ArrayRealVector marketPayments_ = new ArrayRealVector(this.marketPayments);
        ArrayRealVector marketAvgPricePerSlot = marketPayments_.ebeDivide(marketKWh_);
        return marketAvgPricePerSlot;
    }

    public void handleMessage(BalancingTransaction tx) {
        log.info("Balancing tx: " + tx.getCharge());
        if (tx.getCharge() < 0.0) {
            double mwhSuppliedToMe = -tx.getKWh() / 1000.0;
            this.shortBalanceTransactionsData.add(new ChargeMwhPair(tx.getCharge(), mwhSuppliedToMe));
        } else {
            log.debug(" should support positive transactions");
        }
    }

    public void handleMessage(ClearedTrade ct) {
        int timeslot = ct.getTimeslotIndex();
        double mwh = ct.getExecutionMWh();
        double price = ct.getExecutionPrice();
        int tradeCreationTimeslot = this.timeslotRepo.getTimeslotIndex(ct.getDateExecuted());
        if (Competition.currentCompetition().getBrokers().size() >= 7 || !this.configuratorFactoryService.isUseMtx()) {
            this.updateMarketTracking(timeslot, mwh, price);
        }
        this.updateLowHighTradePrices(price);
        this.recordTradeResult(tradeCreationTimeslot, timeslot, price, mwh);
    }

    void recordTradeResult(int tradeCreationTimeslot, int timeslot, double price, double mwh) {
        int index = this.computeBidGroupIndex(tradeCreationTimeslot, timeslot);
        double bidPrice = price;
        BrokerUtils.insertToSortedArrayList(this.getBidGroup(index), new PriceMwhPair(bidPrice, mwh));
        log.info(" tg [" + index + "]" + tradeCreationTimeslot + "=>" + timeslot + " p " + price + " mwh " + mwh);
    }

    private ArrayList<PriceMwhPair> getBidGroup(int bidGroupIndex) {
        ArrayList<PriceMwhPair> group = this.supportingBidGroups.get(bidGroupIndex);
        if (null == group) {
            group = new ArrayList();
            this.supportingBidGroups.put(bidGroupIndex, group);
        }
        return group;
    }

    private int computeBidGroupIndex(int tradeCreationTimeslot, int timeslot) {
        int bidsSubmisionTimeslot = tradeCreationTimeslot - 1;
        return timeslot - bidsSubmisionTimeslot;
    }

    void updateLowHighTradePrices(double price) {
        if (price > this.maxTradePrice) {
            this.maxTradePrice = price;
        }
        if (price < this.minTradePrice) {
            this.minTradePrice = price;
        }
    }

    public void handleMessage(DistributionTransaction dt) {
        log.info("Distribution tx: " + dt.getCharge());
    }

    public void handleMessage(MarketBootstrapData data) {
        for (int i = 0; i < data.getMwh().length; ++i) {
            double mwh = data.getMwh()[i];
            double price = Math.abs(data.getMarketPrice()[i]);
            this.updateMarketTracking(i, mwh, price);
        }
        double avgMktPrice = Math.abs(this.getMeanMarketPricePerMWH());
        this.BUY_LIMIT_PRICE_MIN = -3.0 * avgMktPrice;
        this.SELL_LIMIT_PRICE_MAX = 3.0 * avgMktPrice;
        log.info(" mk BUY_LIMIT_PRICE_MIN " + this.BUY_LIMIT_PRICE_MIN + " SELL_LIMIT_PRICE_MAX " + this.SELL_LIMIT_PRICE_MAX);
    }

    public void handleMessage(MarketPosition posn) {
        this.brokerContext.getBroker().addMarketPosition(posn, posn.getTimeslotIndex());
    }

    public void handleMessage(MarketTransaction tx) {
        Order lastTry = this.lastOrder.get(tx.getTimeslotIndex());
        if (lastTry == null) {
            log.error("order corresponding to market tx " + tx + " is null");
        } else if (tx.getMWh() == lastTry.getMWh().doubleValue()) {
            this.lastOrder.put(tx.getTimeslotIndex(), null);
        }
        if (Competition.currentCompetition().getBrokers().size() < 7 && this.configuratorFactoryService.isUseMtx()) {
            this.updateMarketTracking(tx.getTimeslotIndex(), Math.abs(tx.getMWh()), Math.abs(tx.getPrice()));
        }
    }

    public void handleMessage(Orderbook orderbook) {
        this.orderbooks.put(orderbook.getTimeslotIndex(), orderbook);
    }

    public void handleMessage(WeatherForecast forecast) {
    }

    public void handleMessage(WeatherReport report) {
    }

    public void handleMessage(TariffTransaction ttx) {
        TariffTransaction.Type txType = ttx.getTxType();
        if ((TariffTransaction.Type.CONSUME == txType || TariffTransaction.Type.PRODUCE == txType) && ttx.getBroker().getUsername().equals(this.brokerContext.getBrokerUsername())) {
            double kwh = ttx.getKWh();
            int postedTimeslotIndex = ttx.getPostedTimeslotIndex();
            double oldKwh = this.actualUsage[postedTimeslotIndex];
            this.actualUsage[postedTimeslotIndex] = oldKwh + kwh;
        }
    }

    @Override
    public void activate(int currentTimeslotIndex) {
        try {
            log.info("activate, ts " + currentTimeslotIndex);
            List<Timeslot> enabledTimeslots = this.timeslotRepo.enabledTimeslots();
            try {
                this.cleanOrderBooks(enabledTimeslots);
            }
            catch (Exception e) {
                log.error("caught exception from cleanOrderBooks(): ", e);
                e.printStackTrace();
            }
            try {
                int prevTimeslot = currentTimeslotIndex - 1;
                String errors = " ee " + prevTimeslot + " a: " + String.format("%.2f", this.actualUsage[prevTimeslot]) + " p: ";
                for (double[] p : this.predictedUsage) {
                    errors = errors + String.format("%.2f", p[prevTimeslot]) + " ";
                }
                log.info(errors);
            }
            catch (Exception e) {
                log.error("caught exception while printing errors: ", e);
                e.printStackTrace();
            }
            double neededKWh = 0.0;
            for (Timeslot timeslot : enabledTimeslots) {
                try {
                    int futureTimeslot = timeslot.getSerialNumber();
                    int index = futureTimeslot % this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH();
                    neededKWh = this.portfolioManager.collectUsage(index);
                    this.submitOrder(neededKWh, futureTimeslot, currentTimeslotIndex, enabledTimeslots);
                    this.recordTotalUsagePrediction(-neededKWh, futureTimeslot, currentTimeslotIndex);
                }
                catch (Exception e) {
                    log.error("caught exception while submitting market orders: ", e);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error("caught exception from activate: ", e);
            e.printStackTrace();
        }
    }

    void updateMarketTracking(int timeslot, double mwh, double price) {
        int index;
        int pass = timeslot / this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH();
        int n = index = timeslot % this.configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH();
        this.marketMWh[n] = this.marketMWh[n] + mwh;
        int n2 = index;
        this.marketPayments[n2] = this.marketPayments[n2] + price * mwh;
        this.marketTotalMwh += mwh;
        this.marketTotalPayments += price * mwh;
    }

    private void recordTotalUsagePrediction(double neededKWh, int futureTimeslot, int currentTimeslotIndex) {
        int predictionsIndex = this.indexToPredictionsArray(futureTimeslot, currentTimeslotIndex);
        log.info("trying [" + predictionsIndex + "][" + futureTimeslot + "]");
        this.predictedUsage[predictionsIndex][futureTimeslot] = neededKWh;
    }

    private int indexToPredictionsArray(int futureTimeslot, int currentTimeslotIndex) {
        return futureTimeslot - currentTimeslotIndex - 1;
    }

    protected void submitOrder(double neededKWh, int timeslot, int currentTimeslotIndex, List<Timeslot> enabledTimeslots) {
        Double limitPrice;
        double neededMWh = neededKWh / 1000.0;
        MarketPosition posn = this.brokerContext.getBroker().findMarketPositionByTimeslot(timeslot);
        if (posn != null) {
            neededMWh -= posn.getOverallBalance();
        }
        log.debug("needed mwh=" + neededMWh + ", timeslot " + timeslot);
        if (Math.abs(neededMWh) <= 0.001) {
            log.info("no power required in timeslot " + timeslot);
            return;
        }
        if (neededMWh > 0.0 && this.canRunDP(currentTimeslotIndex, enabledTimeslots) && this.configuratorFactoryService.isUseDP()) {
            limitPrice = this.dpBasedLimit(timeslot, neededMWh, currentTimeslotIndex);
            log.info(" dp dpBasedLimit() " + limitPrice);
        } else {
            limitPrice = this.computeLimitPrice(timeslot, neededMWh, currentTimeslotIndex);
            log.info(" dp computeLimitPrice() " + limitPrice);
        }
        log.info("new order for " + neededMWh + " at " + limitPrice + " in timeslot " + timeslot);
        Order order = new Order(this.brokerContext.getBroker(), timeslot, neededMWh, limitPrice);
        this.lastOrder.put(timeslot, order);
        this.brokerContext.sendMessage(order);
    }

    private Double computeLimitPrice(int timeslot, double neededMwh, int currentTimeslotIndex) {
        log.info(" mk computeLimitPrice(" + neededMwh + ") ");
        int current = currentTimeslotIndex;
        int remainingTries = timeslot - current - Competition.currentCompetition().getDeactivateTimeslotsAhead();
        boolean isBuying = neededMwh > 0.0;
        SortedSet<OrderbookOrder> outstandingOrders = this.getOutstandingOrdersIfExist(timeslot, isBuying);
        double upperlimit = outstandingOrders != null ? this.bestPossiblePrice(neededMwh, outstandingOrders) : this.orderIndependentUpperLimit(isBuying);
        log.info(" mk bestPossiblePrice Limit:" + upperlimit);
        return this.origLimitComputation(timeslot, neededMwh, upperlimit, currentTimeslotIndex);
    }

    private SortedSet<OrderbookOrder> getOutstandingOrdersIfExist(int timeslot, boolean isBuying) {
        Orderbook o = this.orderbooks.get(timeslot);
        if (o == null) {
            return null;
        }
        return isBuying ? o.getAsks() : o.getBids();
    }

    boolean canRunDP(int currentTimeslotIndex, List<Timeslot> enabledTimeslots) {
        int largeEnoughSample = this.configuratorFactoryService.CONSTANTS.LARGE_ENOUGH_SAMPLE_FOR_MARKET_TRADES();
        if (this.supportingBidGroups.size() < enabledTimeslots.size()) {
            return false;
        }
        if (this.shortBalanceTransactionsData.size() < largeEnoughSample) {
            return false;
        }
        log.debug("assuming a trade is created the following timeslot of a bid");
        int nextTradeCreationTimeslot = currentTimeslotIndex + 1;
        for (Timeslot timeslot : enabledTimeslots) {
            int index = this.computeBidGroupIndex(nextTradeCreationTimeslot, timeslot.getSerialNumber());
            if (this.supportingBidGroups.get(index).size() >= largeEnoughSample) continue;
            return false;
        }
        return true;
    }

    private Double dpBasedLimit(int timeslot, double neededMwh, int currentTimeslotIndex) {
        double dpPrice;
        if (!this.dpCache.isValid(currentTimeslotIndex)) {
            this.runDP(neededMwh, currentTimeslotIndex);
        }
        log.debug("assuming a trade is created the following timeslot of a bid");
        int tradeCreationTimeslot = currentTimeslotIndex + 1;
        int bidGroupIndex = this.computeBidGroupIndex(tradeCreationTimeslot, timeslot);
        double adjustedPrice = dpPrice = this.dpCache.getBestAction(bidGroupIndex).doubleValue();
        return adjustedPrice;
    }

    void runDP(double neededMwh, int currentTimeslot) {
        this.dpCache.clear();
        boolean isBuying = neededMwh > 0.0;
        log.debug("Assuming bids only - add support for asks");
        if (!isBuying) {
            log.error("i don't support asks yet! behavior undefined...");
        }
        log.debug("Assuming the whole amount is going to be cleared in one trade - not using neededMwh");
        log.debug("assuming that bidding the 'trade' price helped you win => move to ask/bid");
        ArrayList<Double> stateValues = this.dpCache.getStateValues();
        ArrayList<Double> bestActions = this.dpCache.getBestActions();
        double valueOfStep0 = this.meanOfBalancingPrices(this.shortBalanceTransactionsData);
        stateValues.add(valueOfStep0);
        bestActions.add(null);
        for (int index = 1; index <= this.supportingBidGroups.size(); ++index) {
            ArrayList<PriceMwhPair> currentGroup = this.getBidGroup(index);
            double totalEnergyInCurrentGroup = this.sumTotalEnergy(currentGroup);
            int targetTimeslot = currentTimeslot + index;
            SortedSet<OrderbookOrder> outstandingOrders = this.getOutstandingOrdersIfExist(targetTimeslot, isBuying);
            double lowestAskPrice = outstandingOrders != null ? this.lowestAsk(outstandingOrders) : 0.0;
            double bestActionValue = -1.7976931348623157E308;
            double bestPrice = -1.0;
            double acumulatedEnergy = 0.0;
            for (PriceMwhPair c : currentGroup) {
                double nextStateValue;
                if (c.getPrice() < lowestAskPrice) continue;
                double Psuccess = (acumulatedEnergy += c.getMwh()) / totalEnergyInCurrentGroup;
                double Pfail = 1.0 - Psuccess;
                double bidPrice = -c.getPrice();
                double actionValue = Psuccess * bidPrice + Pfail * (nextStateValue = stateValues.get(stateValues.size() - 1).doubleValue());
                if (!(actionValue > bestActionValue)) continue;
                bestActionValue = actionValue;
                bestPrice = bidPrice;
            }
            stateValues.add(bestActionValue);
            bestActions.add(bestPrice);
        }
        this.dpCache.setValid(currentTimeslot);
    }

    private double lowestAsk(SortedSet<OrderbookOrder> outstandingOrders) {
        if (null == outstandingOrders) {
            return 0.0;
        }
        double lowestAsk = Double.MAX_VALUE;
        for (OrderbookOrder ask : outstandingOrders) {
            if (ask == null) continue;
            lowestAsk = Math.min(lowestAsk, ask.getLimitPrice());
        }
        return lowestAsk < Double.MAX_VALUE ? lowestAsk : 0.0;
    }

    private double sumTotalEnergy(ArrayList<PriceMwhPair> currentGroup) {
        double totalEnergyInCurrentGroup = 0.0;
        for (PriceMwhPair c : currentGroup) {
            totalEnergyInCurrentGroup += c.getMwh();
        }
        return totalEnergyInCurrentGroup;
    }

    double meanOfBalancingPrices(ArrayList<ChargeMwhPair> balancingTxData) {
        int N = balancingTxData.size();
        if (N == 0) {
            log.error("shouldn't happen: meanOfBalancingPrices() should not be called with an empty ArrayList");
            return 0.0;
        }
        double totalMwh = 0.0;
        double totalCharge = 0.0;
        for (ChargeMwhPair c : balancingTxData) {
            totalCharge += c.getCharge();
            totalMwh += c.getMwh();
        }
        if (0.0 == totalMwh) {
            log.error("how come totalMwh in balancing is 0");
            return 0.0;
        }
        return totalCharge / totalMwh;
    }

    double meanClearingBidPrice(ArrayList<PriceMwhPair> supportingBidsGroup) {
        int N = supportingBidsGroup.size();
        if (N == 0) {
            log.error("shouldn't happen: meanClearingBidPrice() should not be called with an empty group");
            return this.BUY_LIMIT_PRICE_MIN;
        }
        double total = 0.0;
        for (PriceMwhPair c : supportingBidsGroup) {
            total += c.getPrice();
        }
        return total / (double)N;
    }

    private Double origLimitComputation(int timeslot, double neededMwh, double upperlimit, int currentTimeslotIndex) {
        Double tmp;
        double minPrice;
        double maxPrice;
        log.debug("Compute limit for " + neededMwh + ", timeslot " + timeslot);
        if (neededMwh > 0.0) {
            maxPrice = this.BUY_LIMIT_PRICE_MAX;
            minPrice = this.BUY_LIMIT_PRICE_MIN;
        } else {
            maxPrice = this.SELL_LIMIT_PRICE_MAX;
            minPrice = this.SELL_LIMIT_PRICE_MIN;
        }
        Order lastTry = this.lastOrder.get(timeslot);
        if (lastTry != null) {
            log.debug("lastTry: " + lastTry.getMWh() + " at " + lastTry.getLimitPrice());
        }
        if (lastTry != null && Math.signum(neededMwh) == Math.signum(lastTry.getMWh()) && (tmp = lastTry.getLimitPrice()) != null) {
            maxPrice = tmp;
            log.debug("old limit price: " + maxPrice);
        }
        int remainingTries = timeslot - currentTimeslotIndex - Competition.currentCompetition().getDeactivateTimeslotsAhead();
        log.debug("remainingTries: " + remainingTries);
        if (remainingTries > 0) {
            double range = (minPrice - maxPrice) * 2.0 / (double)remainingTries;
            log.debug("maxPrice=" + maxPrice + ", range=" + range);
            double computedPrice = maxPrice + this.randomGen.nextDouble() * range;
            return Math.min(Math.max(minPrice, computedPrice), upperlimit);
        }
        return null;
    }

    private double orderIndependentUpperLimit(boolean isBuying) {
        double tradeBasedLimit;
        double globalLimit = isBuying ? this.BUY_LIMIT_PRICE_MAX : this.SELL_LIMIT_PRICE_MAX;
        double d = tradeBasedLimit = isBuying ? -Math.abs(this.minTradePrice) : Math.abs(this.maxTradePrice);
        if (this.validTradeBasedLimit(tradeBasedLimit, isBuying)) {
            log.info(" mk tradeBasedLimit:" + tradeBasedLimit);
            return tradeBasedLimit;
        }
        log.info(" mk globalLimit:" + globalLimit);
        return globalLimit;
    }

    private boolean validTradeBasedLimit(double tradeBasedLimit, boolean isBuying) {
        if (isBuying) {
            return this.BUY_LIMIT_PRICE_MIN < tradeBasedLimit && tradeBasedLimit < this.BUY_LIMIT_PRICE_MAX;
        }
        return this.SELL_LIMIT_PRICE_MIN < tradeBasedLimit && tradeBasedLimit < this.SELL_LIMIT_PRICE_MAX;
    }

    private double bestPossiblePrice(double neededMwh, SortedSet<OrderbookOrder> outstandingOrders) {
        double totalMwh = 0.0;
        double bestPossiblePrice = -1.7976931348623157E308;
        for (OrderbookOrder order : outstandingOrders) {
            if (null == order) continue;
            totalMwh += -order.getMWh();
            bestPossiblePrice = Math.max(bestPossiblePrice, order.getLimitPrice());
            log.info(" mk adding order mwh " + order.getMWh() + " limit " + order.getLimitPrice());
            if (!(Math.abs(totalMwh) > Math.abs(neededMwh))) continue;
            break;
        }
        double limitPrice = -bestPossiblePrice - 1.0E-5 * Math.abs(bestPossiblePrice);
        return limitPrice;
    }

    private void cleanOrderBooks(List<Timeslot> enabledTimeslots) {
        Iterator<Map.Entry<Integer, Orderbook>> it = this.orderbooks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Orderbook> entry = it.next();
            Integer timeslot = entry.getKey();
            if (this.timeslotIsEnabled(enabledTimeslots, timeslot)) continue;
            it.remove();
        }
    }

    boolean timeslotIsEnabled(List<Timeslot> enabledTimeslots, int timeslotIndex) {
        for (Timeslot t : enabledTimeslots) {
            if (t.getSerialNumber() != timeslotIndex) continue;
            return true;
        }
        return false;
    }

    class DPCache {
        private HashMap<Integer, Boolean> validTimeslots = new HashMap();
        private ArrayList<Double> stateValues = new ArrayList();
        private ArrayList<Double> bestActions = new ArrayList();

        public void clear() {
            this.validTimeslots.clear();
            this.stateValues.clear();
            this.bestActions.clear();
        }

        public boolean isValid(int timeslot) {
            return this.getValidEntryFromMap(timeslot);
        }

        public void setValid(int timeslot) {
            this.validTimeslots.put(timeslot, true);
        }

        public Double getBestAction(int bidGroupIndex) {
            return this.getBestActions().get(bidGroupIndex);
        }

        public ArrayList<Double> getBestActions() {
            return this.bestActions;
        }

        public ArrayList<Double> getStateValues() {
            return this.stateValues;
        }

        private boolean getValidEntryFromMap(int timeslot) {
            Boolean valid = this.validTimeslots.get(timeslot);
            if (null == valid) {
                valid = false;
                this.validTimeslots.put(timeslot, valid);
            }
            return valid;
        }
    }

    public class ChargeMwhPair {
        double charge;
        double mwh;

        public ChargeMwhPair(double charge, double mwh) {
            this.charge = charge;
            this.mwh = mwh;
        }

        public double getCharge() {
            return this.charge;
        }

        public double getMwh() {
            return this.mwh;
        }
    }

    class PriceMwhPair
    implements Comparable<PriceMwhPair> {
        double price;
        double mwh;

        public PriceMwhPair(double price, double mwh) {
            this.price = price;
            this.mwh = mwh;
        }

        public double getPrice() {
            return this.price;
        }

        public double getMwh() {
            return this.mwh;
        }

        @Override
        public int compareTo(PriceMwhPair o) {
            if (this.price < o.price) {
                return -1;
            }
            if (this.price > o.price) {
                return 1;
            }
            return 0;
        }
    }
}

