/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import org.apache.commons.math3.linear.ArrayRealVector;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.samplebroker.BrokerUtils;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.MarketManager;
import org.powertac.samplebroker.interfaces.MarketPredictionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketPredictionManagerService
implements Initializable,
MarketPredictionManager {
    @Autowired
    private MarketManager marketManager;
    @Autowired
    private TimeslotRepo timeslotRepo;

    @Override
    public void initialize(BrokerContext broker) {
    }

    @Override
    public ArrayRealVector getPricePerKwhPredictionForAbout7Days() {
        ArrayRealVector record = this.marketManager.getMarketAvgPricesArrayKwh();
        int currentTimeslot = this.timeslotRepo.currentSerialNumber();
        return BrokerUtils.rotateWeeklyRecordAndAppendTillEndOfDay(record, currentTimeslot);
    }
}

