/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.samplebroker.PortfolioManagerService;

public class MsgVerification {
    private static Logger log = Logger.getLogger(PortfolioManagerService.class);
    public static final EnumSet<TariffTransaction.Type> allTransactionTypes = EnumSet.of(TariffTransaction.Type.PUBLISH, new TariffTransaction.Type[]{TariffTransaction.Type.PRODUCE, TariffTransaction.Type.CONSUME, TariffTransaction.Type.PERIODIC, TariffTransaction.Type.SIGNUP, TariffTransaction.Type.WITHDRAW, TariffTransaction.Type.REVOKE});
    public static final EnumSet<TariffTransaction.Type> customerTransactionTypes = EnumSet.of(TariffTransaction.Type.PRODUCE, TariffTransaction.Type.CONSUME, TariffTransaction.Type.PERIODIC, TariffTransaction.Type.SIGNUP, TariffTransaction.Type.WITHDRAW);

    public static boolean isLegalTransaction(TariffTransaction ttx, TariffRepo tariffRepo, CustomerRepo customerRepo) {
        TariffTransaction.Type txType = ttx.getTxType();
        TariffSpecification tariffSpec = ttx.getTariffSpec();
        CustomerInfo customerInfo = ttx.getCustomerInfo();
        int customerCount = ttx.getCustomerCount();
        if (!allTransactionTypes.contains((Object)txType)) {
            return false;
        }
        if (tariffSpec == null) {
            log.error("TariffTransaction type=" + (Object)((Object)txType) + " for unknown spec");
            return false;
        }
        TariffSpecification oldSpec = tariffRepo.findSpecificationById(tariffSpec.getId());
        if (oldSpec != tariffSpec) {
            log.error("Incoming spec " + tariffSpec.getId() + " not matched in repo");
            return false;
        }
        if (customerTransactionTypes.contains((Object)txType)) {
            if (customerInfo == null || customerRepo.findByNameAndPowerType(customerInfo.getName(), tariffSpec.getPowerType()) == null) {
                log.error("TariffTransaction " + ttx.getId() + " with null customer");
                return false;
            }
            if (customerCount <= 0) {
                log.error("Customer count must be positive");
                return false;
            }
        }
        return true;
    }
}

