/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.VariableRateUpdate;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.samplebroker.BrokerUtils;
import org.powertac.samplebroker.ConfiguratorFactoryService;
import org.powertac.samplebroker.ContextManagerService;
import org.powertac.samplebroker.MsgVerification;
import org.powertac.samplebroker.StochasticConsumptionTariffGenerator;
import org.powertac.samplebroker.interfaces.Activatable;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.EnergyPredictionManager;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.MarketManager;
import org.powertac.samplebroker.interfaces.PortfolioManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortfolioManagerService
implements PortfolioManager,
Initializable,
Activatable {
    private static Logger log = Logger.getLogger(PortfolioManagerService.class);
    private BrokerContext brokerContext;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeService timeService;
    @Autowired
    private MarketManager marketManager;
    @Autowired
    private ContextManagerService contextManager;
    @Autowired
    private EnergyPredictionManager energyPredictionManager;
    @Autowired
    private ConfiguratorFactoryService configuratorFactoryService;
    private Random randomGen = new Random();
    private static final double DEFAULT_MARGIN = 0.5;
    private static final double FIXED_PER_KWH = -0.06;
    private static final double DEFAULT_PERIODIC_PAYMENT = -1.0;
    private HashMap<CustomerInfo, CustomerRecord> customerProfiles;
    private HashMap<PowerType, HashMap<CustomerInfo, CustomerRecord>> customerProfilesByPowerType;
    private HashMap<TariffSpecification, HashMap<CustomerInfo, CustomerRecord>> customerSubscriptions;
    private HashMap<PowerType, List<TariffSpecification>> competingTariffs;
    int bootstrapTimeSlotNum;

    @Override
    public void initialize(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.customerProfiles = new HashMap();
        this.customerProfilesByPowerType = new HashMap();
        this.customerSubscriptions = new HashMap();
        this.competingTariffs = new HashMap();
        this.bootstrapTimeSlotNum = -1;
        for (Class messageType : Arrays.asList(CustomerBootstrapData.class, TariffSpecification.class, TariffStatus.class, TariffTransaction.class)) {
            brokerContext.registerMessageHandler(this, messageType);
        }
    }

    public void handleMessage(CustomerBootstrapData cbd) {
        this.produceConsume(cbd);
    }

    public void handleMessage(TariffSpecification spec) {
        if (this.specPublishedByMe(spec)) {
            TariffSpecification original = this.tariffRepo.findSpecificationById(spec.getId());
            if (null == original) {
                log.error("Spec " + spec.getId() + " not in local repo");
            }
            log.info("published " + spec);
        } else {
            this.addCompetingTariff(spec);
        }
    }

    public void handleMessage(TariffStatus ts) {
        log.info("TariffStatus: " + (Object)((Object)ts.getStatus()));
        if (ts.getStatus() != TariffStatus.Status.success) {
            log.error("TariffStatus is not success: " + (Object)((Object)ts.getStatus()));
        }
    }

    public void handleMessage(TariffTransaction ttx) {
        if (!MsgVerification.isLegalTransaction(ttx, this.tariffRepo, this.customerRepo)) {
            return;
        }
        TariffTransaction.Type txType = ttx.getTxType();
        if (MsgVerification.customerTransactionTypes.contains((Object)txType)) {
            log.info("Currently ignoring charge and kwh when handling customerTransactionTypes");
            CustomerRecord tariffCustomerRecord = this.getCustomerRecordByTariff(ttx.getTariffSpec(), ttx.getCustomerInfo());
            if (TariffTransaction.Type.SIGNUP == txType) {
                tariffCustomerRecord.signup(ttx.getCustomerCount());
            } else if (TariffTransaction.Type.WITHDRAW == txType) {
                tariffCustomerRecord.withdraw(ttx.getCustomerCount());
            } else if (TariffTransaction.Type.PRODUCE == txType) {
                if (ttx.getCustomerCount() != tariffCustomerRecord.getSubscribedPopulation()) {
                    log.warn("production by subset " + ttx.getCustomerCount() + " of subscribed population " + tariffCustomerRecord.getSubscribedPopulation());
                }
                this.produceConsume(ttx);
            } else if (TariffTransaction.Type.CONSUME == txType) {
                if (ttx.getCustomerCount() != tariffCustomerRecord.getSubscribedPopulation()) {
                    log.warn("consumption by subset " + ttx.getCustomerCount() + " of subscribed population " + tariffCustomerRecord.getSubscribedPopulation());
                }
                this.produceConsume(ttx);
            } else if (TariffTransaction.Type.PERIODIC == txType) {
                log.debug("need to take care of PERIODIC transaction");
            }
        } else if (TariffTransaction.Type.PUBLISH == txType) {
            log.debug("need to take care of PUBLISH transaction");
        } else if (TariffTransaction.Type.REVOKE == txType) {
            log.debug("need to take care of REVOKE transaction");
        }
    }

    @Override
    public void activate(int currentTimeslotIndex) {
        try {
            log.info("activate, ts " + currentTimeslotIndex);
            if (this.customerSubscriptions.size() == 0) {
                this.createInitialTariffs();
            } else {
                this.improveTariffs(currentTimeslotIndex);
                this.publishHourlyCharges(currentTimeslotIndex);
            }
            log.info("done-activate");
        }
        catch (Exception e) {
            log.error("caught exception from activate(): ", e);
            e.printStackTrace();
        }
    }

    @Override
    public double collectUsage(int index) {
        double result = 0.0;
        for (HashMap<CustomerInfo, CustomerRecord> customerMap : this.customerSubscriptions.values()) {
            for (CustomerRecord record : customerMap.values()) {
                result += record.getUsage(index);
            }
        }
        return -result;
    }

    @Override
    public HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> getCustomerSubscriptions(PowerType powerType) {
        HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> result = new HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>>();
        for (Map.Entry<TariffSpecification, HashMap<CustomerInfo, CustomerRecord>> entry : this.customerSubscriptions.entrySet()) {
            TariffSpecification spec = entry.getKey();
            HashMap<CustomerInfo, CustomerRecord> oldValue = entry.getValue();
            if (spec.getPowerType() != powerType) continue;
            HashMap<CustomerInfo, Integer> newValue = new HashMap<CustomerInfo, Integer>();
            for (Map.Entry<CustomerInfo, CustomerRecord> e : oldValue.entrySet()) {
                newValue.put(e.getKey(), e.getValue().getSubscribedPopulation());
            }
            result.put(spec, newValue);
        }
        return result;
    }

    List<TariffSpecification> getCompetingTariffs(PowerType powerType) {
        List<TariffSpecification> result = this.competingTariffs.get(powerType);
        if (result == null) {
            result = new ArrayList<TariffSpecification>();
            this.competingTariffs.put(powerType, result);
        }
        return result;
    }

    private List<TariffSpecification> getCompetingTariffsThatCanUse(PowerType powerType) {
        ArrayList<TariffSpecification> result = new ArrayList<TariffSpecification>();
        for (PowerType pt : this.competingTariffs.keySet()) {
            if (!pt.canUse(powerType)) continue;
            result.addAll(this.getCompetingTariffs(pt));
        }
        return result;
    }

    private CustomerRecord getCustomerGeneralRecord(CustomerInfo customer) {
        CustomerRecord record;
        if (customer == null) {
            log.error("getCustomerGeneralRecord() called with null key");
        }
        if ((record = this.customerProfiles.get(customer)) == null) {
            record = new CustomerRecord(customer);
            this.customerProfiles.put(customer, record);
        }
        return record;
    }

    private CustomerRecord getCustomerRecordByPowerType(PowerType type, CustomerInfo customer) {
        CustomerRecord record;
        HashMap<CustomerInfo, CustomerRecord> customerMap;
        if (type == null || customer == null) {
            log.error("getCustomerRecordByPowerType() called with null key");
        }
        if ((customerMap = this.customerProfilesByPowerType.get(type)) == null) {
            customerMap = new HashMap();
            this.customerProfilesByPowerType.put(type, customerMap);
        }
        if ((record = customerMap.get(customer)) == null) {
            record = new CustomerRecord(this.getCustomerGeneralRecord(customer));
            customerMap.put(customer, record);
        }
        return record;
    }

    private CustomerRecord getCustomerRecordByTariff(TariffSpecification spec, CustomerInfo customer) {
        CustomerRecord record;
        HashMap<CustomerInfo, CustomerRecord> customerMap;
        if (spec == null || customer == null) {
            log.error("getCustomerRecordByTariff() called with null key");
        }
        if ((customerMap = this.customerSubscriptions.get(spec)) == null) {
            customerMap = new HashMap();
            this.customerSubscriptions.put(spec, customerMap);
        }
        if ((record = customerMap.get(customer)) == null) {
            record = new CustomerRecord(this.getCustomerRecordByPowerType(spec.getPowerType(), customer));
            customerMap.put(customer, record);
        }
        return record;
    }

    private void addCompetingTariff(TariffSpecification spec) {
        boolean success = BrokerUtils.addToRepo(spec, this.tariffRepo);
        if (!success) {
            log.error("How come a competing tariff is failed to be added to repo?");
            log.error("competing tariff ignored: " + spec.getId());
            return;
        }
        this.getCompetingTariffs(spec.getPowerType()).add(spec);
    }

    private void createInitialTariffs() {
        double marketPrice = -this.marketManager.getMeanMarketPricePerKWH();
        double baseRate = (marketPrice + -0.06) * 1.5 - 1.29833E-4;
        log.info("THEBASERATE is " + baseRate);
        ArrayList<TariffSpecification> specsToPublish = new ArrayList<TariffSpecification>();
        PowerType pt = PowerType.CONSUMPTION;
        TariffSpecification spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
        Rate rate = new Rate().withValue(baseRate * 1.105);
        spec.addRate(rate);
        spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
        specsToPublish.add(spec);
        spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
        rate = new Rate().withValue(baseRate * 1.07);
        spec.addRate(rate);
        spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
        specsToPublish.add(spec);
        spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
        rate = new Rate().withValue(baseRate * 1.035);
        spec.addRate(rate);
        spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
        specsToPublish.add(spec);
        spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
        rate = new Rate().withValue(baseRate);
        spec.addRate(rate);
        spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
        specsToPublish.add(spec);
        if (!this.configuratorFactoryService.disguiseSpecs()) {
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate * 0.965);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            specsToPublish.add(spec);
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate * 0.93);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            specsToPublish.add(spec);
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate * 0.895);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            specsToPublish.add(spec);
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate * 0.86);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            specsToPublish.add(spec);
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate * 0.825);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            specsToPublish.add(spec);
        }
        if (this.configuratorFactoryService.isUseInitialTariffs()) {
            for (TariffSpecification tariffSpec : specsToPublish) {
                this.publishSpec(tariffSpec);
            }
        } else {
            spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            rate = new Rate().withValue(baseRate);
            spec.addRate(rate);
            spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
            this.publishSpec(spec);
        }
        log.debug("I am not publishing production tariffs - when I do - verify they don't leak into the consumption code");
    }

    private void improveTariffs(int currentTimeslotIndex) {
        if (this.bootstrapTimeSlotNum == -1) {
            this.bootstrapTimeSlotNum = Competition.currentCompetition().getBootstrapDiscardedTimeslots() + Competition.currentCompetition().getBootstrapTimeslotCount();
        }
        if (this.isPublishingSlot(currentTimeslotIndex)) {
            log.info("checking whether to publish, timeslot " + currentTimeslotIndex);
            log.debug("currently doing check-and-publish-tariffs for all CONSUMPTION together");
            boolean useCanUse = true;
            this.checkAndPossiblyPublishConsumptionTariff(currentTimeslotIndex, useCanUse);
        }
    }

    private boolean isPublishingSlot(int timeslotIndex) {
        boolean checkWhetherToPublish = (timeslotIndex - (this.bootstrapTimeSlotNum + 2)) % 6 == 5;
        return checkWhetherToPublish;
    }

    private void checkAndPossiblyPublishConsumptionTariff(int currentTimeslotIndex, boolean useCanUse) {
        boolean disguise = this.configuratorFactoryService.disguiseSpecs();
        if (!disguise) {
            HashMap<TariffSpecification, HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>>> predictions = ((StochasticConsumptionTariffGenerator)this.configuratorFactoryService.getConsumptionTariffGenerator()).predictions;
            if (predictions != null) {
                if (predictions.size() != 1) {
                    log.error("HOW COME predictions IS " + predictions.size());
                } else {
                    for (TariffSpecification spec : predictions.keySet()) {
                        log.info("ps PREDICTED, ts: " + currentTimeslotIndex);
                        this.printSubscriptions(predictions.get(spec));
                    }
                    log.info("ps ACTUAL, ts: " + currentTimeslotIndex);
                    this.printSubscriptions(this.getCustomerSubscriptions(PowerType.CONSUMPTION));
                }
            }
            List<TariffSpecification> competitorTariffs = useCanUse ? this.getCompetingTariffsThatCanUse(PowerType.CONSUMPTION) : this.getCompetingTariffs(PowerType.CONSUMPTION);
            HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions = this.getCustomerSubscriptions(PowerType.CONSUMPTION);
            List<TariffSpecification> tariffsToPublish = this.configuratorFactoryService.getConsumptionTariffGenerator().generateTariffsToPublish(useCanUse, tariffSubscriptions, competitorTariffs, this.marketManager, this.contextManager, this.brokerContext.getBroker(), currentTimeslotIndex);
            log.info("number of suggested specs: " + tariffsToPublish.size());
            for (TariffSpecification spec : tariffsToPublish) {
                this.publishSpec(spec);
            }
        } else {
            PowerType pt = PowerType.CONSUMPTION;
            double avgMktPrice = -this.marketManager.getMeanMarketPricePerKWH();
            log.info("avgMktPrice " + avgMktPrice + " timeslot " + currentTimeslotIndex);
            double priceLowerBound = avgMktPrice;
            log.info("priceLowerBound " + priceLowerBound);
            double competingMinRateValue = this.getCompetingMinRateValue(pt, priceLowerBound);
            log.info("competing min rate " + competingMinRateValue);
            double myMinRateValue = this.getMyMinRateValue(pt);
            log.info("myMinRateValue " + myMinRateValue);
            if (-priceLowerBound < -competingMinRateValue && -competingMinRateValue <= -myMinRateValue * 1.1) {
                log.info("publishing");
                TariffSpecification spec = new TariffSpecification(this.brokerContext.getBroker(), pt);
                double randomElem = 0.4 + this.randomGen.nextDouble() * 0.29999999999999993;
                double rateValue = avgMktPrice + randomElem * (competingMinRateValue - avgMktPrice);
                Rate rate = new Rate().withValue(rateValue);
                spec.addRate(rate);
                spec = this.configuratorFactoryService.disguiseSpecs() ? this.disguiseSpec(spec) : spec;
                this.publishSpec(spec);
            }
        }
    }

    private TariffSpecification disguiseSpec(TariffSpecification spec) {
        double rateValue = spec.getRates().get(0).getValue();
        PowerType pt = spec.getPowerType();
        int rnd = this.randomGen.nextInt(4);
        if (rnd == 0) {
            return spec;
        }
        if (rnd == 1) {
            Rate rate1 = new Rate().withValue(rateValue).withDailyBegin(0).withDailyEnd(7);
            Rate rate2 = new Rate().withValue(1.001 * rateValue).withDailyBegin(8).withDailyEnd(17);
            Rate rate3 = new Rate().withValue(rateValue).withDailyBegin(18).withDailyEnd(23);
            TariffSpecification newspec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            newspec.addRate(rate1).addRate(rate2).addRate(rate3);
            return newspec;
        }
        if (rnd == 2) {
            Rate rate1 = new Rate().withValue(1.001 * rateValue).withDailyBegin(0).withDailyEnd(7);
            Rate rate2 = new Rate().withValue(rateValue).withDailyBegin(8).withDailyEnd(17);
            Rate rate3 = new Rate().withValue(1.001 * rateValue).withDailyBegin(18).withDailyEnd(23);
            TariffSpecification newspec = new TariffSpecification(this.brokerContext.getBroker(), pt);
            newspec.addRate(rate1).addRate(rate2).addRate(rate3);
            return newspec;
        }
        TariffSpecification vrspec = new TariffSpecification(this.brokerContext.getBroker(), pt);
        double minValue = rateValue * 0.999;
        double expectedMean = rateValue;
        double maxValue = rateValue * 1.001;
        Rate vrate = new Rate().withNoticeInterval(3L).withFixed(false).withMinValue(minValue).withExpectedMean(expectedMean).withMaxValue(maxValue);
        vrspec.addRate(vrate);
        return vrspec;
    }

    private void printSubscriptions(HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> customerSubscriptions2) {
        for (TariffSpecification spec : customerSubscriptions2.keySet()) {
            log.info("ps TariffSpec: " + spec);
            for (CustomerInfo c : customerSubscriptions2.get(spec).keySet()) {
                log.info("ps customer " + c + " subscriptions " + customerSubscriptions2.get(spec).get(c));
            }
        }
    }

    private void produceConsume(CustomerBootstrapData cbd) {
        PowerType powerType = cbd.getPowerType();
        String customerName = cbd.getCustomerName();
        CustomerInfo customer = this.customerRepo.findByNameAndPowerType(customerName, powerType);
        CustomerRecord powerTypeRecord = this.getCustomerRecordByPowerType(powerType, customer);
        CustomerRecord generalRecord = this.getCustomerGeneralRecord(customer);
        int offset = this.timeslotRepo.currentTimeslot().getSerialNumber() - cbd.getNetUsage().length;
        for (int i = 0; i < cbd.getNetUsage().length; ++i) {
            powerTypeRecord.produceConsume(cbd.getNetUsage()[i], customer.getPopulation(), i + offset);
            generalRecord.produceConsume(cbd.getNetUsage()[i], customer.getPopulation(), i + offset);
        }
    }

    private void produceConsume(TariffTransaction ttx) {
        TariffTransaction.Type txType = ttx.getTxType();
        if (TariffTransaction.Type.CONSUME != txType && TariffTransaction.Type.PRODUCE != txType) {
            log.warn("produceConsume is called with the wrong type of transaction - ignoring...");
            return;
        }
        CustomerInfo customer = ttx.getCustomerInfo();
        TariffSpecification tariffSpec = ttx.getTariffSpec();
        int customerCount = ttx.getCustomerCount();
        int postedTime = ttx.getPostedTimeslotIndex();
        PowerType powerType = tariffSpec.getPowerType();
        double kWh = ttx.getKWh();
        CustomerRecord tariffRecord = this.getCustomerRecordByTariff(tariffSpec, customer);
        tariffRecord.produceConsume(kWh, customerCount, postedTime);
        CustomerRecord profileRecord = this.getCustomerRecordByPowerType(powerType, customer);
        profileRecord.produceConsume(kWh, customerCount, postedTime);
        CustomerRecord generalRecord = this.getCustomerGeneralRecord(customer);
        generalRecord.produceConsume(kWh, customerCount, postedTime);
    }

    private void publishHourlyCharges(int currentTimeslotIndex) {
        for (TariffSpecification spec : this.tariffRepo.findTariffSpecificationsByPowerType(PowerType.CONSUMPTION)) {
            if (!this.specPublishedByMe(spec)) continue;
            for (Rate r : spec.getRates()) {
                if (r.isFixed()) continue;
                long noticeInterval = r.getNoticeInterval();
                int destinationTimeslot = (int)((long)currentTimeslotIndex + noticeInterval + 1L);
                log.info("DU noticeInterval " + noticeInterval + " currentTimeslot " + currentTimeslotIndex + " destinationTimeslot " + destinationTimeslot);
                double marketPrice = -this.marketManager.getMarketAvgPricePerSlotKWH(destinationTimeslot);
                log.info("DU marketPrice " + marketPrice);
                double minValue = Math.abs(r.getMinValue());
                double maxValue = Math.abs(r.getMaxValue());
                double rateValue = Math.abs(marketPrice + r.getExpectedMean() - minValue);
                log.info("DU minValue " + minValue + " maxValue " + maxValue + " rateValue " + rateValue);
                rateValue = Math.min(Math.max(rateValue, minValue), maxValue);
                log.info("DU rateValue after trimming  " + rateValue);
                rateValue = -rateValue;
                log.info("DU final rateValue " + rateValue);
                HourlyCharge h = new HourlyCharge(this.timeService.getCurrentTime().plus((noticeInterval + 1L) * 3600000L), rateValue);
                r.addHourlyCharge(h);
                h.setRateId(r.getId());
                VariableRateUpdate v = new VariableRateUpdate(this.brokerContext.getBroker(), r, h);
                this.brokerContext.sendMessage(v);
            }
        }
    }

    private boolean specPublishedByMe(TariffSpecification spec) {
        return spec.getBroker().getUsername().equals(this.brokerContext.getBrokerUsername());
    }

    private void publishSpec(TariffSpecification spec) {
        TariffSpecification specToPublish = spec;
        boolean success = BrokerUtils.addToRepo(specToPublish, this.tariffRepo);
        if (success) {
            for (CustomerInfo customer : this.customerRepo.list()) {
                if (!customer.getPowerType().canUse(specToPublish.getPowerType())) continue;
                this.getCustomerRecordByTariff(specToPublish, customer);
            }
            this.brokerContext.sendMessage(specToPublish);
        } else {
            log.warn("will not publish tariff " + specToPublish.getId());
        }
    }

    private double getCompetingMinRateValue(PowerType pt, double priceLowerBound) {
        double competingMinRateValue = -1.7976931348623157E308;
        for (TariffSpecification competingTariff : this.getCompetingTariffsThatCanUse(pt)) {
            Broker theBroker = competingTariff.getBroker();
            if (this.specPublishedByMe(competingTariff)) continue;
            for (Rate r : competingTariff.getRates()) {
                double value = r.isFixed() ? r.getMinValue() : r.getExpectedMean();
                if (!(priceLowerBound > value) || !(value > competingMinRateValue)) continue;
                competingMinRateValue = value;
            }
        }
        return competingMinRateValue;
    }

    private double getCompetingMaxProdRateValue(PowerType pt, double rateUpperBound) {
        double competingMaxProdRateValue = 0.0;
        for (TariffSpecification competingTariff : this.getCompetingTariffs(pt)) {
            if (this.specPublishedByMe(competingTariff)) continue;
            for (Rate r : competingTariff.getRates()) {
                double value = r.getMinValue();
                if (!(rateUpperBound > value) || !(value > competingMaxProdRateValue)) continue;
                competingMaxProdRateValue = value;
            }
        }
        return competingMaxProdRateValue;
    }

    private double getMyMinRateValue(PowerType pt) {
        double myMinRateValue = -1.7976931348623157E308;
        for (TariffSpecification spec : this.tariffRepo.findTariffSpecificationsByPowerType(pt)) {
            if (!this.specPublishedByMe(spec)) continue;
            for (Rate r : spec.getRates()) {
                double value = r.isFixed() ? r.getMinValue() : r.getExpectedMean();
                if (!(value > myMinRateValue)) continue;
                myMinRateValue = value;
            }
        }
        return myMinRateValue;
    }

    private double getMyMaxProdRateValue(PowerType pt) {
        double myMaxRateValue = -1.7976931348623157E308;
        for (TariffSpecification spec : this.tariffRepo.findTariffSpecificationsByPowerType(pt)) {
            if (!this.specPublishedByMe(spec)) continue;
            for (Rate r : spec.getRates()) {
                double value = r.getMinValue();
                if (!(value > myMaxRateValue)) continue;
                myMaxRateValue = value;
            }
        }
        return myMaxRateValue;
    }

    private double getMinCurtailRatio(PowerType pt) {
        double minCurtailRatio = Double.MAX_VALUE;
        for (TariffSpecification competingTariff : this.getCompetingTariffs(pt)) {
            for (Rate r : competingTariff.getRates()) {
                double value = r.getMaxCurtailment();
                if (!(value < minCurtailRatio) || !(0.0 <= value) || !(value <= 1.0)) continue;
                minCurtailRatio = value;
            }
        }
        return minCurtailRatio;
    }

    double getUsageForCustomer(CustomerInfo customer, TariffSpecification tariffSpec, int index) {
        CustomerRecord record = this.getCustomerRecordByTariff(tariffSpec, customer);
        return record.getUsage(index);
    }

    ArrayRealVector getRawUsageForCustomerByTariff(CustomerInfo customer, TariffSpecification spec) {
        return this.getCustomerRecordByTariff(spec, customer).getUsageArray();
    }

    HashMap<PowerType, double[]> getRawUsageForCustomerByPowerType(CustomerInfo customer) {
        HashMap<PowerType, double[]> result = new HashMap<PowerType, double[]>();
        for (PowerType type : this.customerProfilesByPowerType.keySet()) {
            CustomerRecord record = this.customerProfilesByPowerType.get(type).get(customer);
            if (record == null) continue;
            result.put(type, record.usage);
        }
        return result;
    }

    @Override
    public ArrayRealVector getGeneralRawUsageForCustomer(CustomerInfo customer) {
        return this.getCustomerGeneralRecord(customer).getUsageArray();
    }

    HashMap<String, Integer> getCustomerCounts() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (TariffSpecification spec : this.customerSubscriptions.keySet()) {
            HashMap<CustomerInfo, CustomerRecord> customerMap = this.customerSubscriptions.get(spec);
            for (CustomerRecord record : customerMap.values()) {
                result.put(record.customer.getName() + spec.getPowerType(), record.getSubscribedPopulation());
            }
        }
        return result;
    }

    public class CustomerRecord {
        private CustomerInfo customer;
        private int subscribedPopulation = 0;
        private double[] usage;
        private double alpha = 0.3;

        CustomerRecord(CustomerInfo customer) {
            this.customer = customer;
            this.usage = new double[((PortfolioManagerService)PortfolioManagerService.this).configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH()];
        }

        CustomerRecord(CustomerRecord oldRecord) {
            this.customer = oldRecord.customer;
            this.usage = Arrays.copyOf(oldRecord.usage, ((PortfolioManagerService)PortfolioManagerService.this).configuratorFactoryService.CONSTANTS.USAGE_RECORD_LENGTH());
        }

        CustomerInfo getCustomerInfo() {
            return this.customer;
        }

        ArrayRealVector getUsageArray() {
            return new ArrayRealVector(this.usage);
        }

        void signup(int population) {
            this.subscribedPopulation = Math.min(this.customer.getPopulation(), this.subscribedPopulation + population);
        }

        void withdraw(int population) {
            this.subscribedPopulation -= population;
            if (this.subscribedPopulation < 0) {
                log.error("subscribed population < 0: " + this.subscribedPopulation + ", resetting to 0");
                this.subscribedPopulation = 0;
            }
        }

        void produceConsume(double kwh, int population, int rawIndex) {
            log.debug("produce consume is averaging regardless of the number of customers");
            int index = this.getIndex(rawIndex);
            double kwhPerCustomer = kwh / (double)population;
            double oldUsage = this.usage[index];
            this.usage[index] = oldUsage == 0.0 ? kwhPerCustomer : this.alpha * kwhPerCustomer + (1.0 - this.alpha) * oldUsage;
            log.debug("consume " + kwh + " at " + index + ", customer " + this.customer.getName());
        }

        double getUsage(int index) {
            if (index < 0) {
                log.warn("usage requested for negative index " + index);
                index = 0;
            }
            return this.usage[this.getIndex(index)] * (double)this.subscribedPopulation;
        }

        int getIndex(Instant when) {
            int result = (int)((when.getMillis() - PortfolioManagerService.this.timeService.getBase()) / Competition.currentCompetition().getTimeslotDuration());
            return result;
        }

        private int getIndex(int rawIndex) {
            return rawIndex % this.usage.length;
        }

        public int getSubscribedPopulation() {
            return this.subscribedPopulation;
        }
    }
}

