/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSpecification;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TariffRepo;
import org.powertac.samplebroker.BrokerUtils;
import org.powertac.samplebroker.UtilityEstimatorDefaultForConsumption;
import org.powertac.samplebroker.interfaces.ConsumptionTariffGenerator;
import org.powertac.samplebroker.interfaces.ConsumptionTariffSuggestionMaker;
import org.powertac.samplebroker.interfaces.ContextManager;
import org.powertac.samplebroker.interfaces.EnergyPredictionManager;
import org.powertac.samplebroker.interfaces.MarketManager;
import org.powertac.samplebroker.interfaces.MarketPredictionManager;
import org.powertac.samplebroker.interfaces.UtilityEstimator;

public class StochasticConsumptionTariffGenerator
implements ConsumptionTariffGenerator {
    private static Logger log = Logger.getLogger(StochasticConsumptionTariffGenerator.class);
    private EnergyPredictionManager energyPredictionManager;
    private MarketPredictionManager marketPredictionManager;
    private ConsumptionTariffSuggestionMaker consumptionTariffSuggestionMaker;
    private UtilityEstimator utilityEstimator;
    private TariffRepo tariffRepo;
    public HashMap<TariffSpecification, HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>>> predictions;

    public StochasticConsumptionTariffGenerator(EnergyPredictionManager energyPredictionManager, MarketPredictionManager marketPredictionManager, ConsumptionTariffSuggestionMaker consumptionTariffSuggestionMaker, UtilityEstimator utilityEstimator, TariffRepo tariffRepo) {
        this.energyPredictionManager = energyPredictionManager;
        this.marketPredictionManager = marketPredictionManager;
        this.consumptionTariffSuggestionMaker = consumptionTariffSuggestionMaker;
        this.utilityEstimator = utilityEstimator;
        this.tariffRepo = tariffRepo;
    }

    @Override
    public List<TariffSpecification> generateTariffsToPublish(boolean useCanUse, HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions, List<TariffSpecification> competingTariffs, MarketManager marketManager, ContextManager contextManager, Broker me, int currentTimeslot) {
        List<TariffSpecification> suggestedSpecs = this.consumptionTariffSuggestionMaker.suggestTariffs(tariffSubscriptions, competingTariffs, marketManager, contextManager, me);
        log.info("generateTariffsToPublish(): suggestedSpecs:");
        for (TariffSpecification spec : suggestedSpecs) {
            log.info(spec);
            for (Rate r : spec.getRates()) {
                log.info(r);
            }
        }
        this.addSuggestedSpecsToRepo(suggestedSpecs);
        boolean customerPerspective = true;
        HashMap<CustomerInfo, ArrayRealVector> customer2estimatedEnergy = this.energyPredictionManager.getAbout7dayPredictionForCustomersOfType(PowerType.CONSUMPTION, useCanUse, customerPerspective, currentTimeslot);
        ArrayRealVector estimatedMarketPrices = this.marketPredictionManager.getPricePerKwhPredictionForAbout7Days();
        TreeMap<Double, TariffSpecification> sortedTariffs = this.utilityEstimator.estimateUtilities(suggestedSpecs, tariffSubscriptions, competingTariffs, customer2estimatedEnergy, estimatedMarketPrices, me);
        log.info("Estimated Utilities: ");
        for (Map.Entry<Double, TariffSpecification> e : sortedTariffs.entrySet()) {
            log.info("u: " + e.getKey() + " spec: " + e.getValue());
        }
        TariffSpecification specToAdd = sortedTariffs.lastEntry().getValue();
        ArrayList<TariffSpecification> specsToAdd = new ArrayList<TariffSpecification>();
        if (specToAdd != null) {
            specsToAdd.add(specToAdd);
        }
        this.predictions = ((UtilityEstimatorDefaultForConsumption)this.utilityEstimator).predictions;
        if (specsToAdd.size() != 0) {
            this.predictions.remove(null);
        }
        for (TariffSpecification spec : suggestedSpecs) {
            if (specsToAdd.contains(spec)) continue;
            this.predictions.remove(spec);
        }
        this.removeNonChosenSpecsFromRepo(suggestedSpecs, specsToAdd);
        return specsToAdd;
    }

    private void addSuggestedSpecsToRepo(List<TariffSpecification> suggestedSpecs) {
        log.info("temporarily adding suggested specs to repo");
        for (TariffSpecification spec : suggestedSpecs) {
            boolean success = BrokerUtils.addToRepo(spec, this.tariffRepo);
            if (success) continue;
            log.error("failed to temporarily add spec to repo, spec-id: " + spec.getId());
        }
    }

    private void removeNonChosenSpecsFromRepo(List<TariffSpecification> suggestedSpecs, List<TariffSpecification> specsToAdd) {
        log.info("removing non-chosen specs from repo");
        for (TariffSpecification spec : suggestedSpecs) {
            if (specsToAdd.contains(spec)) continue;
            Tariff tariff = this.tariffRepo.findTariffById(spec.getId());
            BrokerUtils.removeFromRepo(tariff, this.tariffRepo);
        }
    }
}

