/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.samplebroker.interfaces.ChargeEstimator;
import org.powertac.samplebroker.interfaces.ContextManager;
import org.powertac.samplebroker.interfaces.CustomerPredictionManager;
import org.powertac.samplebroker.interfaces.UtilityEstimator;

public class UtilityEstimatorDefaultForConsumption
implements UtilityEstimator {
    private static Logger log = Logger.getLogger(UtilityEstimatorDefaultForConsumption.class);
    private TariffRepo tariffRepo;
    private CustomerRepo customerRepo;
    private ContextManager contextManager;
    private CustomerPredictionManager customerPredictionManager;
    private ChargeEstimator chargeEstimator;
    public HashMap<TariffSpecification, HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>>> predictions = new HashMap();

    public UtilityEstimatorDefaultForConsumption(TariffRepo tariffRepo, CustomerRepo customerRepo, ContextManager contextManager, CustomerPredictionManager customerPredictionManager, ChargeEstimator chargeEstimator) {
        this.tariffRepo = tariffRepo;
        this.customerRepo = customerRepo;
        this.contextManager = contextManager;
        this.customerPredictionManager = customerPredictionManager;
        this.chargeEstimator = chargeEstimator;
    }

    @Override
    public TreeMap<Double, TariffSpecification> estimateUtilities(List<TariffSpecification> suggestedSpecs, HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions, List<TariffSpecification> competingTariffs, HashMap<CustomerInfo, ArrayRealVector> customer2estimatedEnergy, ArrayRealVector estimatedMarketPrices, Broker me) {
        this.predictions.clear();
        TreeMap<Double, TariffSpecification> utility2spec = new TreeMap<Double, TariffSpecification>();
        ArrayList<TariffSpecification> relevantTariffs = new ArrayList<TariffSpecification>(tariffSubscriptions.keySet());
        relevantTariffs.addAll(competingTariffs);
        HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> customer2estimatedTariffCharges = this.chargeEstimator.estimateTariffCharges(relevantTariffs, customer2estimatedEnergy);
        log.info("estimating utility of null tariff");
        double utility = this.estimateUtility(tariffSubscriptions, customer2estimatedTariffCharges, customer2estimatedEnergy, estimatedMarketPrices);
        utility2spec.put(utility, null);
        this.predictions.put(null, tariffSubscriptions);
        for (TariffSpecification spec : suggestedSpecs) {
            this.addSpecEvaluationForAllCustomers(spec, customer2estimatedTariffCharges, customer2estimatedEnergy);
            HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> predictedCustomerSubscriptions = this.customerPredictionManager.predictCustomerMigration(spec, customer2estimatedTariffCharges, tariffSubscriptions, competingTariffs);
            this.predictions.put(spec, predictedCustomerSubscriptions);
            log.info("estimating utility of adding spec: " + spec);
            utility = this.estimateUtility(predictedCustomerSubscriptions, customer2estimatedTariffCharges, customer2estimatedEnergy, estimatedMarketPrices);
            utility2spec.put(utility + this.publicationFee(spec), spec);
            this.removeSpecEvaluationForAllCustomers(spec, customer2estimatedTariffCharges);
        }
        return utility2spec;
    }

    double estimateUtility(HashMap<TariffSpecification, HashMap<CustomerInfo, Integer>> tariffSubscriptions, HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> customer2estimatedTariffCharges, HashMap<CustomerInfo, ArrayRealVector> customer2estimatedEnergy, ArrayRealVector estimatedMarketPrices) {
        log.debug("estimateUtility(): currently assuming competing tariffs are not new and that my subscriptions are not going to change as a result of them");
        double estTariffIncome = 0.0;
        double wholesaleCosts = 0.0;
        double balancingCosts = 0.0;
        double distributionCosts = 0.0;
        double totalConsumption = 0.0;
        double totalProduction = 0.0;
        for (Map.Entry<TariffSpecification, HashMap<CustomerInfo, Integer>> entry : tariffSubscriptions.entrySet()) {
            TariffSpecification spec = entry.getKey();
            HashMap<CustomerInfo, Integer> subscriptions = entry.getValue();
            for (Map.Entry<CustomerInfo, Integer> ce : subscriptions.entrySet()) {
                CustomerInfo customerInfo = ce.getKey();
                Integer subscribedPopulation = ce.getValue();
                estTariffIncome += -customer2estimatedTariffCharges.get(customerInfo).get(spec).doubleValue() * (double)subscribedPopulation.intValue();
                RealVector energyPrediction = customer2estimatedEnergy.get(customerInfo).mapMultiply(subscribedPopulation.intValue());
                if (energyPrediction.getDimension() != estimatedMarketPrices.getDimension()) {
                    log.error("Cannot compute utility - prediction periods of market and energy differ);");
                    return 0.0;
                }
                wholesaleCosts += -energyPrediction.dotProduct(estimatedMarketPrices);
                balancingCosts += 0.0;
                log.debug("Ignoring balancing costs - assuming they are 0");
                if (spec.getPowerType().isConsumption()) {
                    totalConsumption += energyPrediction.getL1Norm();
                    continue;
                }
                if (spec.getPowerType().isProduction()) {
                    totalProduction += energyPrediction.getL1Norm();
                    continue;
                }
                log.warn("Ignoring unknown powertype when computing distribution costs");
            }
        }
        log.debug("Ignoring balancing orders and curtailment when computing distribution costs");
        distributionCosts = Math.max(totalProduction, totalConsumption) * this.contextManager.getDistributionFee();
        log.info("estTariffIncome " + estTariffIncome);
        log.info("wholesaleCosts " + wholesaleCosts);
        log.info("balancingCosts " + balancingCosts);
        log.info("distributionCosts " + distributionCosts);
        return estTariffIncome + wholesaleCosts + balancingCosts + distributionCosts;
    }

    void addSpecEvaluationForAllCustomers(TariffSpecification spec, HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> evaluatedTariffs, HashMap<CustomerInfo, ArrayRealVector> customer2energy) {
        for (CustomerInfo customerInfo : evaluatedTariffs.keySet()) {
            double tariffEvaluation = this.chargeEstimator.estimateCharge(customer2energy.get(customerInfo), spec);
            evaluatedTariffs.get(customerInfo).put(spec, tariffEvaluation);
        }
    }

    void removeSpecEvaluationForAllCustomers(TariffSpecification spec, HashMap<CustomerInfo, HashMap<TariffSpecification, Double>> evaluatedTariffs) {
        for (CustomerInfo customerInfo : evaluatedTariffs.keySet()) {
            evaluatedTariffs.get(customerInfo).remove(spec);
        }
    }

    private double publicationFee(TariffSpecification spec) {
        return this.contextManager.getPublicationFee();
    }
}

