/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.powertac.common.XMLMessageConverter;
import org.powertac.samplebroker.core.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerMessageReceiver
implements MessageListener {
    private static Logger log = Logger.getLogger(BrokerMessageReceiver.class);
    @Autowired
    XMLMessageConverter converter;
    @Autowired
    MessageDispatcher messageDispatcher;

    @Override
    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                log.debug("onMessage(Message) - receiving a message");
                this.onMessage(((TextMessage)message).getText());
            }
            catch (JMSException e) {
                log.error("failed to extract text from TextMessage", e);
            }
        }
    }

    private void onMessage(String xml) {
        log.info("onMessage(String) - received message:\n" + xml);
        Object message = this.converter.fromXML(xml);
        log.debug("onMessage(String) - received message of type " + message.getClass().getSimpleName());
        this.messageDispatcher.routeMessage(message);
    }
}

