/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PropertiesUtil
extends PropertyPlaceholderConfigurer {
    private Map<String, String> propertiesMap;

    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        super.processProperties(beanFactory, props);
        this.propertiesMap = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            this.propertiesMap.put(keyStr, this.resolvePlaceholder(props.getProperty(keyStr), props));
        }
    }

    public String getProperty(String name) {
        return this.propertiesMap.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.propertiesMap.get(name);
        return value != null ? value : defaultValue;
    }
}

