/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class BigIntegerMorpher
extends AbstractObjectMorpher {
    private BigInteger defaultValue;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BigIntegerMorpher() {
    }

    public BigIntegerMorpher(BigInteger defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigIntegerMorpher)) {
            return false;
        }
        BigIntegerMorpher other = (BigIntegerMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public BigInteger getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value) {
        if (value instanceof BigInteger) {
            return value;
        }
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(((Number)value).longValue());
        }
        try {
            String str = this.getIntegerValue(value);
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    public Class morphsTo() {
        return class$java$math$BigInteger == null ? (class$java$math$BigInteger = BigIntegerMorpher.class$("java.math.BigInteger")) : class$java$math$BigInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIntegerValue(Object obj) {
        Locale defaultLocale = Locale.getDefault();
        String str = null;
        try {
            Locale.setDefault(Locale.US);
            str = String.valueOf(obj).trim();
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
        int index = str.indexOf(".");
        if (index != -1) {
            str = str.substring(0, index);
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

