/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JSONObject
implements JSON {
    private static final String[] defaultExcludes = new String[]{"class"};
    private static final Log log = LogFactory.getLog(JSONObject.class);
    private boolean nullObject;
    private Map properties;

    public static JSONObject fromBean(Object bean) {
        return JSONObject.fromBean(bean, null, false);
    }

    public static JSONObject fromBean(Object bean, String[] excludes) {
        return JSONObject.fromBean(bean, excludes, false);
    }

    public static JSONObject fromBean(Object bean, String[] excludes, boolean ignoreDefaultExcludes) {
        if (bean == null || JSONUtils.isNull(bean)) {
            return new JSONObject(true);
        }
        if (bean instanceof Enum) {
            throw new JSONException("'bean' is an Enum. Use JSONArray instead");
        }
        if (bean instanceof Annotation || bean != null && bean.getClass().isAnnotation()) {
            throw new JSONException("'bean' is an Annotation.");
        }
        if (bean instanceof JSONObject) {
            return JSONObject.fromJSONObject((JSONObject)bean, excludes, ignoreDefaultExcludes);
        }
        if (bean instanceof DynaBean) {
            return JSONObject.fromDynaBean((DynaBean)bean, excludes, ignoreDefaultExcludes);
        }
        if (bean instanceof JSONTokener) {
            return JSONObject.fromJSONTokener((JSONTokener)bean, excludes, ignoreDefaultExcludes);
        }
        if (bean instanceof JSONString) {
            return JSONObject.fromJSONString((JSONString)bean, excludes, ignoreDefaultExcludes);
        }
        if (bean instanceof Map) {
            return JSONObject.fromMap((Map)bean, excludes, ignoreDefaultExcludes);
        }
        if (bean instanceof String) {
            return JSONObject.fromString((String)bean, excludes, ignoreDefaultExcludes);
        }
        if (JSONUtils.isNumber(bean) || JSONUtils.isBoolean(bean) || JSONUtils.isString(bean)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(bean)) {
            throw new JSONException("'bean' is an array. Use JSONArray instead");
        }
        JSONObject jsonObject = new JSONObject();
        Collection exclusions = JSONObject.mergeExclusions(excludes, ignoreDefaultExcludes);
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors(bean);
            for (int i = 0; i < pds.length; ++i) {
                String key = pds[i].getName();
                if (exclusions.contains(key)) continue;
                Class<?> type = pds[i].getPropertyType();
                if (pds[i].getReadMethod() != null) {
                    Object value = PropertyUtils.getProperty(bean, key);
                    JSONObject.setValue(jsonObject, key, value, type, excludes, ignoreDefaultExcludes);
                    continue;
                }
                log.warn("Property '" + key + "' has no read method. SKIPPED");
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonObject;
    }

    public static JSONObject fromDynaBean(DynaBean bean) {
        return JSONObject.fromDynaBean(bean, null, false);
    }

    public static JSONObject fromDynaBean(DynaBean bean, String[] excludes) {
        return JSONObject.fromDynaBean(bean, excludes, false);
    }

    public static JSONObject fromDynaBean(DynaBean bean, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONObject(bean, excludes, ignoreDefaultExcludes);
    }

    public static JSONObject fromJSONObject(JSONObject object) {
        return JSONObject.fromJSONObject(object, null, false);
    }

    public static JSONObject fromJSONObject(JSONObject object, String[] excludes) {
        return JSONObject.fromJSONObject(object, excludes, false);
    }

    public static JSONObject fromJSONObject(JSONObject object, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONObject(object, excludes, ignoreDefaultExcludes);
    }

    public static JSONObject fromJSONString(JSONString string) {
        return JSONObject.fromJSONTokener(new JSONTokener(string.toJSONString()), null, false);
    }

    public static JSONObject fromJSONString(JSONString string, String[] excludes) {
        return JSONObject.fromJSONTokener(new JSONTokener(string.toJSONString()), excludes, false);
    }

    public static JSONObject fromJSONString(JSONString string, String[] excludes, boolean ignoreDefaultExcludes) {
        return JSONObject.fromJSONTokener(new JSONTokener(string.toJSONString()), excludes, ignoreDefaultExcludes);
    }

    public static JSONObject fromMap(Map map) {
        return JSONObject.fromMap(map, null, false);
    }

    public static JSONObject fromMap(Map map, String[] excludes) {
        return JSONObject.fromMap(map, excludes, false);
    }

    public static JSONObject fromMap(Map map, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONObject(map, excludes, ignoreDefaultExcludes);
    }

    public static JSONObject fromObject(Object object) {
        return JSONObject.fromObject(object, null, false);
    }

    public static JSONObject fromObject(Object object, String[] excludes) {
        return JSONObject.fromObject(object, excludes, false);
    }

    public static JSONObject fromObject(Object object, String[] excludes, boolean ignoreDefaultExcludes) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (object instanceof JSONObject) {
            return JSONObject.fromJSONObject((JSONObject)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof DynaBean) {
            return JSONObject.fromDynaBean((DynaBean)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof JSONTokener) {
            return JSONObject.fromJSONTokener((JSONTokener)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof JSONString) {
            return JSONObject.fromJSONString((JSONString)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof Map) {
            return JSONObject.fromMap((Map)object, excludes, ignoreDefaultExcludes);
        }
        if (object instanceof String) {
            return JSONObject.fromString((String)object, excludes, ignoreDefaultExcludes);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObject.fromBean(object, excludes, ignoreDefaultExcludes);
    }

    public static JSONObject fromString(String str) {
        return JSONObject.fromString(str, null, false);
    }

    public static JSONObject fromString(String str, String[] excludes) {
        return JSONObject.fromString(str, excludes, false);
    }

    public static JSONObject fromString(String str, String[] excludes, boolean ignoreDefaultExcludes) {
        if (str == null || "null".compareToIgnoreCase(str) == 0) {
            return new JSONObject(true);
        }
        return JSONObject.fromJSONTokener(new JSONTokener(str), excludes, ignoreDefaultExcludes);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        DynaBean dynaBean = null;
        try {
            Map props = JSONUtils.getProperties(jsonObject);
            dynaBean = JSONUtils.newDynaBean(jsonObject);
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                Object value = jsonObject.get(key);
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        JSONObject.setProperty(dynaBean, key, JSONArray.toList((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                        JSONObject.setProperty(dynaBean, key, value);
                        continue;
                    }
                    JSONObject.setProperty(dynaBean, key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn("Tried to assign null value to " + key + ":" + type.getName());
                    JSONObject.setProperty(dynaBean, key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                JSONObject.setProperty(dynaBean, key, null);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return dynaBean;
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        return JSONObject.toBean(jsonObject, beanClass, null);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        HashMap bean = null;
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = (HashMap)beanClass.newInstance();
            }
            Map props = JSONUtils.getProperties(jsonObject);
            for (Map.Entry entry : props.entrySet()) {
                String key = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                Object value = jsonObject.get(key);
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(bean, key);
                if (pd != null && pd.getWriteMethod() == null) {
                    log.warn("Property '" + key + "' has no write method. SKIPPED.");
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    Class targetClass;
                    if (value instanceof JSONArray) {
                        if (List.class.isAssignableFrom(pd.getPropertyType())) {
                            targetClass = JSONObject.findTargetClass(key, classMap);
                            List list = JSONArray.toList((JSONArray)value, targetClass, classMap);
                            JSONObject.setProperty(bean, key, list);
                            continue;
                        }
                        Object array = JSONArray.toArray((JSONArray)value, beanClass, classMap);
                        Class innerType = JSONUtils.getInnerComponentType(pd.getPropertyType());
                        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType) || !array.getClass().equals(pd.getPropertyType())) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        JSONObject.setProperty(bean, key, array);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (pd != null) {
                            if (!pd.getPropertyType().isInstance(value)) {
                                JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(pd.getPropertyType(), value));
                                continue;
                            }
                            JSONObject.setProperty(bean, key, value);
                            continue;
                        }
                        JSONObject.setProperty(bean, key, value);
                        continue;
                    }
                    if (pd != null) {
                        targetClass = pd.getPropertyType();
                        if (targetClass == Object.class) {
                            targetClass = JSONObject.findTargetClass(key, classMap);
                        }
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, targetClass, classMap));
                        continue;
                    }
                    targetClass = JSONObject.findTargetClass(key, classMap);
                    if (targetClass != null) {
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, targetClass, classMap));
                        continue;
                    }
                    JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn("Tried to assign null value to " + key + ":" + type.getName());
                    JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                JSONObject.setProperty(bean, key, null);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return bean;
    }

    private static Class findTargetClass(String key, Map classMap) {
        Class targetClass = (Class)classMap.get(key);
        if (targetClass == null) {
            for (Map.Entry entry : classMap.entrySet()) {
                if (!RegexpUtils.getMatcher((String)entry.getKey()).matches(key)) continue;
                targetClass = (Class)entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static JSONObject fromJSONTokener(JSONTokener tokener, String[] excludes, boolean ignoreDefaultExcludes) {
        return new JSONObject(tokener, excludes, ignoreDefaultExcludes);
    }

    private static Collection mergeExclusions(String[] excludes, boolean ignoreDefaultExcludes) {
        int i;
        HashSet<String> exclusions = new HashSet<String>();
        if (excludes != null) {
            for (i = 0; i < excludes.length; ++i) {
                String exclusion = excludes[i];
                if (excludes[i] == null || exclusion.trim().length() <= 0) continue;
                exclusions.add(exclusion.trim());
            }
        }
        if (!ignoreDefaultExcludes) {
            for (i = 0; i < defaultExcludes.length; ++i) {
                if (exclusions.contains(defaultExcludes[i])) continue;
                exclusions.add(defaultExcludes[i]);
            }
        }
        return exclusions;
    }

    private static void setProperty(Object bean, String key, Object value) throws Exception {
        if (bean instanceof Map) {
            ((Map)bean).put(key, value);
        } else if (bean instanceof JSONObject) {
            if (!((JSONObject)bean).isNullObject()) {
                ((JSONObject)bean).set(key, value);
            }
        } else {
            PropertyUtils.setProperty(bean, key, value);
        }
    }

    private static void setValue(Object object, String key, Object value, Class type, String[] excludes, boolean ignoreDefaultExcludes) {
        if (key == null) {
            throw new JSONException("Null key");
        }
        try {
            if (Class.class.isAssignableFrom(type) && value != null || value instanceof Class) {
                JSONObject.setProperty(object, key, ((Class)value).getName());
            } else {
                if (value instanceof Annotation || value != null && value.getClass().isAnnotation()) {
                    throw new JSONException("'value' is an Annotation.");
                }
                if (JSONUtils.isFunction(value)) {
                    JSONObject.setProperty(object, key, value);
                } else if (value instanceof JSONString) {
                    JSONObject.setProperty(object, key, JSONSerializer.toJSON((Object)((JSONString)value), excludes, ignoreDefaultExcludes));
                } else if (JSONUtils.isArray(value)) {
                    JSONObject.setProperty(object, key, JSONArray.fromObject(value, excludes, ignoreDefaultExcludes));
                } else if (value instanceof JSON) {
                    JSONObject.setProperty(object, key, value);
                } else if (String.class.isAssignableFrom(type) || JSONUtils.isString(value)) {
                    String str = String.valueOf(value);
                    if (value == null) {
                        JSONObject.setProperty(object, key, "");
                    } else if (JSONUtils.mayBeJSON(str)) {
                        try {
                            JSONObject.setProperty(object, key, JSONSerializer.toJSON((Object)str, excludes, ignoreDefaultExcludes));
                        }
                        catch (JSONException jsone) {
                            JSONObject.setProperty(object, key, JSONUtils.stripQuotes(str));
                        }
                    } else {
                        JSONObject.setProperty(object, key, JSONUtils.stripQuotes(str));
                    }
                } else if (JSONUtils.isNumber(value)) {
                    JSONUtils.testValidity(value);
                    JSONObject.setProperty(object, key, value);
                } else if (JSONUtils.isBoolean(value)) {
                    JSONObject.setProperty(object, key, value);
                } else if (value == null) {
                    if (JSONUtils.isArray(type)) {
                        JSONObject.setProperty(object, key, JSONSerializer.toJSON("[]"));
                    } else if (JSONUtils.isNumber(type)) {
                        if (JSONUtils.isDouble(type)) {
                            JSONObject.setProperty(object, key, new Double(0.0));
                        } else {
                            JSONObject.setProperty(object, key, new Integer(0));
                        }
                    } else if (JSONUtils.isBoolean(type)) {
                        JSONObject.setProperty(object, key, "false");
                    } else if (JSONUtils.isString(type)) {
                        JSONObject.setProperty(object, key, "");
                    } else {
                        JSONObject.setProperty(object, key, JSONNull.getInstance());
                    }
                } else if (Enum.class.isAssignableFrom(type)) {
                    JSONObject.setProperty(object, key, ((Enum)value).toString());
                } else {
                    JSONObject.setProperty(object, key, JSONObject.fromObject(value, excludes, ignoreDefaultExcludes));
                }
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    public JSONObject() {
        this.properties = new HashMap();
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    private JSONObject(DynaBean bean, String[] excludes, boolean ignoreDefaultExcludes) {
        this();
        if (bean == null) {
            this.nullObject = true;
            return;
        }
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        Collection exclusions = JSONObject.mergeExclusions(excludes, ignoreDefaultExcludes);
        for (int i = 0; i < props.length; ++i) {
            DynaProperty dynaProperty = props[i];
            String key = dynaProperty.getName();
            if (exclusions.contains(key)) continue;
            Class type = dynaProperty.getType();
            Object value = bean.get(dynaProperty.getName());
            JSONObject.setValue(this, key, value, type, excludes, ignoreDefaultExcludes);
        }
    }

    private JSONObject(JSONObject jo, String[] excludes, boolean ignoreDefaultExcludes) {
        this();
        if (jo == null || jo.isNullObject()) {
            this.nullObject = true;
            return;
        }
        JSONArray sa = jo.names();
        Collection exclusions = JSONObject.mergeExclusions(excludes, ignoreDefaultExcludes);
        Iterator i = sa.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (exclusions.contains(key)) continue;
            this.putOpt(key, jo.opt(key));
        }
    }

    private JSONObject(JSONTokener x, String[] excludes, boolean ignoreDefaultExcludes) {
        this();
        if (x.matches("null.*")) {
            this.nullObject = true;
            return;
        }
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        Collection exclusions = JSONObject.mergeExclusions(excludes, ignoreDefaultExcludes);
        block12: while (true) {
            Object v;
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue(excludes, ignoreDefaultExcludes).toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (!JSONUtils.isFunctionHeader(v = x.nextValue())) {
                if (exclusions.contains(key)) {
                    switch (x.nextClean()) {
                        case ',': 
                        case ';': {
                            if (x.nextClean() == '}') {
                                return;
                            }
                            x.back();
                            continue block12;
                        }
                        case '}': {
                            return;
                        }
                    }
                    throw x.syntaxError("Expected a ',' or '}'");
                }
                if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                    this.set(key, "\"" + v + "\"");
                } else {
                    this.set(key, v, excludes, ignoreDefaultExcludes);
                }
            } else {
                char ch;
                String params = JSONUtils.getFunctionParams((String)v);
                int i = 0;
                StringBuffer sb = new StringBuffer();
                while ((ch = x.next()) != '\u0000') {
                    if (ch == '{') {
                        ++i;
                    }
                    if (ch == '}') {
                        --i;
                    }
                    sb.append(ch);
                    if (i != 0) continue;
                    break;
                }
                if (i != 0) {
                    throw x.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                }
                String text = sb.toString();
                text = text.substring(1, text.length() - 1).trim();
                this.set(key, new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text));
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block12;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    private JSONObject(Map map, String[] excludes, boolean ignoreDefaultExcludes) {
        if (map == null) {
            this.nullObject = true;
            return;
        }
        this.properties = new HashMap();
        Collection exclusions = JSONObject.mergeExclusions(excludes, ignoreDefaultExcludes);
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            String key = k instanceof String ? (String)k : String.valueOf(k);
            if (exclusions.contains(key)) continue;
            Object value = entry.getValue();
            if (value == null) {
                this.set(key, value);
                continue;
            }
            JSONObject.setValue(this, key, value, value.getClass(), excludes, ignoreDefaultExcludes);
        }
    }

    private JSONObject(String string, String[] excludes, boolean ignoreDefaultExcludes) {
        this(new JSONTokener(string), excludes, ignoreDefaultExcludes);
    }

    public JSONObject accumulate(String key, Object value) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        JSONUtils.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public Object get(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) {
        this.verifyIsNull();
        return this.get(key).toString();
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator keys() {
        this.verifyIsNull();
        return this.properties.keySet().iterator();
    }

    public int length() {
        this.verifyIsNull();
        return this.properties.size();
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) {
        this.verifyIsNull();
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, Collection value) {
        return this.put(key, value, null, false);
    }

    public JSONObject put(String key, Collection value, String[] excludes) {
        return this.put(key, value, excludes, false);
    }

    public JSONObject put(String key, Collection value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.verifyIsNull();
        this.put(key, JSONArray.fromObject(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONObject put(String key, double value) {
        this.verifyIsNull();
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        this.put(key, d);
        return this;
    }

    public JSONObject put(String key, int value) {
        this.verifyIsNull();
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) {
        this.verifyIsNull();
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map value) {
        return this.put(key, value, null, false);
    }

    public JSONObject put(String key, Map value, String[] excludes) {
        return this.put(key, value, excludes, false);
    }

    public JSONObject put(String key, Map value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.verifyIsNull();
        this.put(key, JSONObject.fromObject(value, excludes, ignoreDefaultExcludes));
        return this;
    }

    public JSONObject put(String key, Object value) {
        return this.put(key, value, null, false);
    }

    public JSONObject put(String key, Object value, String[] excludes) {
        return this.put(key, value, excludes, false);
    }

    public JSONObject put(String key, Object value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            this.set(key, value, excludes, ignoreDefaultExcludes);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) {
        return this.put(key, value, null, false);
    }

    public JSONObject putOpt(String key, Object value, String[] excludes) {
        return this.put(key, value, excludes, false);
    }

    public JSONObject putOpt(String key, Object value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            if (this.isNullObject()) {
                writer.write(JSONNull.getInstance().toString());
                return writer;
            }
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONUtils.quote(k.toString()));
                writer.write(58);
                Object v = this.properties.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private JSONObject set(String key, Object value) {
        return this.set(key, value, null, false);
    }

    private JSONObject set(String key, Object value, String[] excludes, boolean ignoreDefaultExcludes) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null && Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            this.properties.put(key, ((Class)value).getName());
        } else {
            if (value instanceof Annotation || value != null && value.getClass().isAnnotation()) {
                throw new JSONException("'value' is an Annotation.");
            }
            if (JSONUtils.isFunction(value)) {
                this.properties.put(key, value);
            } else if (value instanceof JSONString) {
                this.properties.put(key, JSONSerializer.toJSON((Object)((JSONString)value), excludes, ignoreDefaultExcludes));
            } else if (JSONUtils.isArray(value)) {
                this.properties.put(key, JSONArray.fromObject(value, excludes, ignoreDefaultExcludes));
            } else if (value instanceof JSON) {
                this.properties.put(key, value);
            } else if (JSONUtils.isString(value)) {
                String str = String.valueOf(value);
                if (JSONUtils.mayBeJSON(str)) {
                    try {
                        this.properties.put(key, JSONSerializer.toJSON((Object)str, excludes, ignoreDefaultExcludes));
                    }
                    catch (JSONException jsone) {
                        this.properties.put(key, JSONUtils.stripQuotes(str));
                    }
                } else if (value == null) {
                    this.properties.put(key, "");
                } else {
                    this.properties.put(key, JSONUtils.stripQuotes(str));
                }
            } else if (JSONUtils.isNumber(value)) {
                JSONUtils.testValidity(value);
                this.properties.put(key, JSONUtils.transformNumber((Number)value));
            } else if (JSONUtils.isBoolean(value)) {
                this.properties.put(key, value);
            } else if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
                this.properties.put(key, ((Enum)value).toString());
            } else {
                this.properties.put(key, JSONObject.fromObject(value, excludes, ignoreDefaultExcludes));
            }
        }
        return this;
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }
}

