/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.data.D1Submatrix64F;

public class BlockMultiplication {
    public static void mult(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.row0; i < A.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A.row1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.row0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * heightA;
                for (int k = A.col0; k < A.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A.col1 - k);
                    int indexA = i * A.original.numCols + k * heightA;
                    int indexB = (k - A.col0 + B2.row0) * B2.original.numCols + j * widthA;
                    if (k == A.col0) {
                        BlockInnerMultiplication.blockMultSet(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlus(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multPlus(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.row0; i < A.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A.row1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.row0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * heightA;
                for (int k = A.col0; k < A.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A.col1 - k);
                    int indexA = i * A.original.numCols + k * heightA;
                    int indexB = (k - A.col0 + B2.row0) * B2.original.numCols + j * widthA;
                    BlockInnerMultiplication.blockMultPlus(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multMinus(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        BlockMultiplication.checkInput(blockLength, A, B2, C2);
        for (int i = A.row0; i < A.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A.row1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.row0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * heightA;
                for (int k = A.col0; k < A.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A.col1 - k);
                    int indexA = i * A.original.numCols + k * heightA;
                    int indexB = (k - A.col0 + B2.row0) * B2.original.numCols + j * widthA;
                    BlockInnerMultiplication.blockMultMinus(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    private static void checkInput(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        int Arow = A.getRows();
        int Acol = A.getCols();
        int Brow = B2.getRows();
        int Bcol = B2.getCols();
        int Crow = C2.getRows();
        int Ccol = C2.getCols();
        if (Arow != Crow) {
            throw new RuntimeException("Mismatch A and C rows");
        }
        if (Bcol != Ccol) {
            throw new RuntimeException("Mismatch B and C columns");
        }
        if (Acol != Brow) {
            throw new RuntimeException("Mismatch A columns and B rows");
        }
        if (!BlockMatrixOps.blockAligned(blockLength, A)) {
            throw new RuntimeException("Sub-Matrix A is not block aligned");
        }
        if (!BlockMatrixOps.blockAligned(blockLength, B2)) {
            throw new RuntimeException("Sub-Matrix B is not block aligned");
        }
        if (!BlockMatrixOps.blockAligned(blockLength, C2)) {
            throw new RuntimeException("Sub-Matrix C is not block aligned");
        }
    }

    public static void multTransA(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.col0; i < A.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A.col1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.col0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * widthA;
                for (int k = A.row0; k < A.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A.row1 - k);
                    int indexA = k * A.original.numCols + i * heightA;
                    int indexB = (k - A.row0 + B2.row0) * B2.original.numCols + j * heightA;
                    if (k == A.row0) {
                        BlockInnerMultiplication.blockMultSetTransA(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlusTransA(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multPlusTransA(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.col0; i < A.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A.col1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.col0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * widthA;
                for (int k = A.row0; k < A.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A.row1 - k);
                    int indexA = k * A.original.numCols + i * heightA;
                    int indexB = (k - A.row0 + B2.row0) * B2.original.numCols + j * heightA;
                    BlockInnerMultiplication.blockMultPlusTransA(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multMinusTransA(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.col0; i < A.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A.col1 - i);
            for (int j = B2.col0; j < B2.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B2.col1 - j);
                int indexC = (i - A.col0 + C2.row0) * C2.original.numCols + (j - B2.col0 + C2.col0) * widthA;
                for (int k = A.row0; k < A.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A.row1 - k);
                    int indexA = k * A.original.numCols + i * heightA;
                    int indexB = (k - A.row0 + B2.row0) * B2.original.numCols + j * heightA;
                    BlockInnerMultiplication.blockMultMinusTransA(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multTransB(int blockLength, D1Submatrix64F A, D1Submatrix64F B2, D1Submatrix64F C2) {
        for (int i = A.row0; i < A.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A.row1 - i);
            for (int j = B2.row0; j < B2.row1; j += blockLength) {
                int widthC = Math.min(blockLength, B2.row1 - j);
                int indexC = (i - A.row0 + C2.row0) * C2.original.numCols + (j - B2.row0 + C2.col0) * heightA;
                for (int k = A.col0; k < A.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A.col1 - k);
                    int indexA = i * A.original.numCols + k * heightA;
                    int indexB = j * B2.original.numCols + (k - A.col0 + B2.col0) * widthC;
                    if (k == A.col0) {
                        BlockInnerMultiplication.blockMultSetTransB(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthC);
                        continue;
                    }
                    BlockInnerMultiplication.blockMultPlusTransB(A.original.data, B2.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthC);
                }
            }
        }
    }
}

