/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.alg.dense.linsol.qr.BaseLinearSolverQrp;
import org.ejml.data.DenseMatrix64F;

public class LinearSolverQrpHouseCol
extends BaseLinearSolverQrp {
    private QRColPivDecompositionHouseholderColumn decomposition;
    private DenseMatrix64F x_basic = new DenseMatrix64F(1, 1);

    public LinearSolverQrpHouseCol(QRColPivDecompositionHouseholderColumn decomposition, boolean norm2Solution) {
        super(decomposition, norm2Solution);
        this.decomposition = decomposition;
    }

    @Override
    public void solve(DenseMatrix64F B2, DenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (B2.numRows != this.numRows || B2.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B2.numCols;
        int[] pivots = this.decomposition.getPivots();
        double[][] qr = this.decomposition.getQR();
        double[] gammas = this.decomposition.getGammas();
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            this.x_basic.reshape(this.numRows, 1);
            this.Y.reshape(this.numRows, 1);
            for (i = 0; i < this.numRows; ++i) {
                this.x_basic.data[i] = B2.get(i, colB);
            }
            for (i = 0; i < this.rank; ++i) {
                double[] u = qr[i];
                double vv = u[i];
                u[i] = 1.0;
                QrHelperFunctions.rank1UpdateMultR(this.x_basic, u, gammas[i], 0, i, this.numRows, this.Y.data);
                u[i] = vv;
            }
            TriangularSolver.solveU(this.R11.data, this.x_basic.data, this.rank);
            this.x_basic.reshape(this.numCols, 1, true);
            for (i = this.rank; i < this.numCols; ++i) {
                this.x_basic.data[i] = 0.0;
            }
            if (this.norm2Solution && this.rank < this.numCols) {
                this.upgradeSolution(this.x_basic);
            }
            for (i = 0; i < this.numCols; ++i) {
                X.set(pivots[i], colB, this.x_basic.data[i]);
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

