/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.alg.dense.mult.MatrixDimensionException;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.RowD1Matrix64F;

public class MatrixVectorMult {
    public static void mult(RowD1Matrix64F a, D1Matrix64F b, D1Matrix64F c) {
        if (c.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (c.numRows != a.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (b.numRows == 1) {
            if (a.numCols != b.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (b.numCols == 1) {
            if (a.numCols != b.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int indexA = 0;
        int cIndex = 0;
        double b0 = b.get(0);
        for (int i = 0; i < a.numRows; ++i) {
            double total = a.get(indexA++) * b0;
            for (int j = 1; j < a.numCols; ++j) {
                total += a.get(indexA++) * b.get(j);
            }
            c.set(cIndex++, total);
        }
    }

    public static void multAdd(RowD1Matrix64F A, D1Matrix64F B2, D1Matrix64F C2) {
        if (C2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C2.numRows != A.numRows) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B2.numRows == 1) {
            if (A.numCols != B2.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B2.numCols == 1) {
            if (A.numCols != B2.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int indexA = 0;
        int cIndex = 0;
        for (int i = 0; i < A.numRows; ++i) {
            double total = A.get(indexA++) * B2.get(0);
            for (int j = 1; j < A.numCols; ++j) {
                total += A.get(indexA++) * B2.get(j);
            }
            C2.plus(cIndex++, total);
        }
    }

    public static void multTransA_small(RowD1Matrix64F A, D1Matrix64F B2, D1Matrix64F C2) {
        if (C2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C2.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B2.numRows == 1) {
            if (A.numRows != B2.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B2.numCols == 1) {
            if (A.numRows != B2.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int cIndex = 0;
        for (int i = 0; i < A.numCols; ++i) {
            double total = 0.0;
            int indexA = i;
            for (int j = 0; j < A.numRows; ++j) {
                total += A.get(indexA) * B2.get(j);
                indexA += A.numCols;
            }
            C2.set(cIndex++, total);
        }
    }

    public static void multTransA_reorder(RowD1Matrix64F A, D1Matrix64F B2, D1Matrix64F C2) {
        if (C2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C2.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B2.numRows == 1) {
            if (A.numRows != B2.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B2.numCols == 1) {
            if (A.numRows != B2.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        double B_val = B2.get(0);
        for (int i = 0; i < A.numCols; ++i) {
            C2.set(i, A.get(i) * B_val);
        }
        int indexA = A.numCols;
        for (int i = 1; i < A.numRows; ++i) {
            B_val = B2.get(i);
            for (int j = 0; j < A.numCols; ++j) {
                C2.plus(j, A.get(indexA++) * B_val);
            }
        }
    }

    public static void multAddTransA_small(RowD1Matrix64F A, D1Matrix64F B2, D1Matrix64F C2) {
        if (C2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C2.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B2.numRows == 1) {
            if (A.numRows != B2.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B2.numCols == 1) {
            if (A.numRows != B2.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int cIndex = 0;
        for (int i = 0; i < A.numCols; ++i) {
            double total = 0.0;
            int indexA = i;
            for (int j = 0; j < A.numRows; ++j) {
                total += A.get(indexA) * B2.get(j);
                indexA += A.numCols;
            }
            C2.plus(cIndex++, total);
        }
    }

    public static void multAddTransA_reorder(RowD1Matrix64F A, D1Matrix64F B2, D1Matrix64F C2) {
        if (C2.numCols != 1) {
            throw new MatrixDimensionException("C is not a column vector");
        }
        if (C2.numRows != A.numCols) {
            throw new MatrixDimensionException("C is not the expected length");
        }
        if (B2.numRows == 1) {
            if (A.numRows != B2.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B2.numCols == 1) {
            if (A.numRows != B2.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        int indexA = 0;
        for (int j = 0; j < A.numRows; ++j) {
            double B_val = B2.get(j);
            for (int i = 0; i < A.numCols; ++i) {
                C2.plus(i, A.get(indexA++) * B_val);
            }
        }
    }
}

