/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.Dispatcher;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.internal.DispatcherConfig;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtCustomDispatchSource;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;
import org.fusesource.hawtdispatch.internal.SerialDispatchQueue;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.TimerThread;
import org.fusesource.hawtdispatch.internal.WorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HawtDispatcher
implements Dispatcher {
    public static final ThreadLocal<HawtDispatchQueue> CURRENT_QUEUE = new ThreadLocal();
    final GlobalDispatchQueue DEFAULT_QUEUE;
    private final Object HIGH_MUTEX = new Object();
    private GlobalDispatchQueue HIGH_QUEUE;
    private final Object LOW_MUTEX = new Object();
    private GlobalDispatchQueue LOW_QUEUE;
    private final String label;
    volatile TimerThread timerThread;
    private final int threads;
    private volatile boolean profile;
    final int drains;
    final AtomicInteger shutdownState = new AtomicInteger(0);
    volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    public static final WeakHashMap<HawtDispatchQueue, Object> queues = new WeakHashMap();

    public HawtDispatcher(DispatcherConfig config) {
        this.threads = config.getThreads();
        this.label = config.getLabel();
        this.profile = config.isProfile();
        this.drains = config.getDrains();
        this.DEFAULT_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.DEFAULT, config.getThreads());
        this.DEFAULT_QUEUE.start();
        this.DEFAULT_QUEUE.profile(this.profile);
        this.timerThread = new TimerThread(this);
        this.timerThread.start();
    }

    public void shutdown() {
        if (this.shutdownState.compareAndSet(0, 1)) {
            this.sleep(100L);
            this.timerThread.shutdown(new Runnable(){

                public void run() {
                    HawtDispatcher.this.shutdownState.set(2);
                    HawtDispatcher.this.sleep(100L);
                    HawtDispatcher.this.DEFAULT_QUEUE.shutdown();
                    if (HawtDispatcher.this.LOW_QUEUE != null) {
                        HawtDispatcher.this.LOW_QUEUE.shutdown();
                    }
                    if (HawtDispatcher.this.HIGH_QUEUE != null) {
                        HawtDispatcher.this.HIGH_QUEUE.shutdown();
                    }
                    HawtDispatcher.this.shutdownState.set(3);
                }
            }, this.DEFAULT_QUEUE);
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void restart() {
        if (this.shutdownState.compareAndSet(3, 0)) {
            this.timerThread = new TimerThread(this);
            this.DEFAULT_QUEUE.start();
            if (this.LOW_QUEUE != null) {
                this.LOW_QUEUE.start();
            }
            if (this.HIGH_QUEUE != null) {
                this.HIGH_QUEUE.start();
            }
        } else {
            throw new IllegalStateException("Not shutdown yet.");
        }
    }

    @Override
    public DispatchQueue getGlobalQueue() {
        return this.getGlobalQueue(DispatchPriority.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalDispatchQueue getGlobalQueue(DispatchPriority priority) {
        switch (priority) {
            case DEFAULT: {
                return this.DEFAULT_QUEUE;
            }
            case HIGH: {
                Object object = this.HIGH_MUTEX;
                synchronized (object) {
                    if (this.HIGH_QUEUE == null) {
                        this.HIGH_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.HIGH, this.threads);
                        this.HIGH_QUEUE.start();
                        this.HIGH_QUEUE.profile(this.profile);
                    }
                    return this.HIGH_QUEUE;
                }
            }
            case LOW: {
                Object object = this.LOW_MUTEX;
                synchronized (object) {
                    if (this.LOW_QUEUE == null) {
                        this.LOW_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.LOW, this.threads);
                        this.LOW_QUEUE.start();
                        this.LOW_QUEUE.profile(this.profile);
                    }
                    return this.LOW_QUEUE;
                }
            }
        }
        throw new AssertionError((Object)"switch missing case");
    }

    @Override
    public SerialDispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = new SerialDispatchQueue(label);
        rc.setTargetQueue(this.getGlobalQueue());
        rc.profile(this.profile);
        return rc;
    }

    @Override
    public DispatchSource createSource(SelectableChannel channel, int interestOps, DispatchQueue queue) {
        return new NioDispatchSource(this, channel, interestOps, queue);
    }

    @Override
    public <Event, MergedEvent> CustomDispatchSource<Event, MergedEvent> createSource(EventAggregator<Event, MergedEvent> aggregator, DispatchQueue queue) {
        return new HawtCustomDispatchSource<Event, MergedEvent>(this, aggregator, queue);
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public DispatchQueue getCurrentQueue() {
        return CURRENT_QUEUE.get();
    }

    @Override
    public ThreadDispatchQueue getCurrentThreadQueue() {
        WorkerThread thread = WorkerThread.currentWorkerThread();
        if (thread == null) {
            return null;
        }
        return thread.getDispatchQueue();
    }

    @Override
    public DispatchQueue[] getThreadQueues(DispatchPriority priority) {
        return this.getGlobalQueue(priority).getThreadQueues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(HawtDispatchQueue queue) {
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            queues.put(queue, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack(HawtDispatchQueue queue) {
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            queues.remove(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profile(boolean on) {
        this.profile = on;
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            for (HawtDispatchQueue queue : new ArrayList<HawtDispatchQueue>(queues.keySet())) {
                if (queue == null) continue;
                queue.profile(on);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Metrics> metrics() {
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            ArrayList<Metrics> rc = new ArrayList<Metrics>();
            for (HawtDispatchQueue queue : queues.keySet()) {
                Metrics metrics;
                if (queue == null || (metrics = queue.metrics()) == null) continue;
                rc.add(metrics);
            }
            return rc;
        }
    }

    String assertMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dispatch queue '");
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        } else {
            sb.append("<no-label>");
        }
        sb.append("' was not executing, (currently executing: '");
        DispatchQueue q = this.getCurrentQueue();
        if (q != null) {
            if (q.getLabel() != null) {
                sb.append(q.getLabel());
            } else {
                sb.append("<no-label>");
            }
        } else {
            sb.append("<not-dispatched>");
        }
        sb.append("')");
        return sb.toString();
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }
}

