/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.DispatchQueue;

public class RunnableSupport {
    private static Runnable NO_OP = new Runnable(){

        public void run() {
        }

        public String toString() {
            return "{}";
        }
    };

    public static Runnable runNoop() {
        return NO_OP;
    }

    public static Runnable runOnceAfter(final Runnable runnable, int count) {
        if (runnable == null) {
            return NO_OP;
        }
        if (count == 0) {
            runnable.run();
            return NO_OP;
        }
        if (count == 1) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Runnable(){

            public void run() {
                if (counter.decrementAndGet() == 0) {
                    runnable.run();
                }
            }

            public String toString() {
                return "{" + runnable + "}";
            }
        };
    }

    public static Runnable runAfter(final Runnable runnable, int count) {
        if (count <= 0 || runnable == null) {
            return NO_OP;
        }
        if (count == 1) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Runnable(){

            public void run() {
                if (counter.decrementAndGet() <= 0) {
                    runnable.run();
                }
            }

            public String toString() {
                return "{" + runnable + "}";
            }
        };
    }

    public static Runnable runOnceAfter(final DispatchQueue queue, final Runnable runnable, int count) {
        if (count <= 0 || runnable == null) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Runnable(){

            public void run() {
                if (counter.decrementAndGet() == 0) {
                    queue.execute(runnable);
                }
            }

            public String toString() {
                return "{" + runnable + "}";
            }
        };
    }

    public static Runnable runAfter(final DispatchQueue queue, final Runnable runnable, int count) {
        if (count <= 0 || runnable == null) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Runnable(){

            public void run() {
                if (counter.decrementAndGet() <= 0) {
                    queue.execute(runnable);
                }
            }

            public String toString() {
                return "{" + runnable.toString() + "}";
            }
        };
    }
}

