/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.HexSupport;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.transport.DefaultTransportListener;
import org.fusesource.hawtdispatch.transport.HeartBeatMonitor;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.ProxyCallback;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MQTTProtocolCodec;
import org.fusesource.mqtt.codec.MessageSupport;
import org.fusesource.mqtt.codec.PINGREQ;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackConnection {
    private static final Listener DEFAULT_LISTENER = new Listener(){

        public void onConnected() {
        }

        public void onDisconnected() {
        }

        public void onPublish(UTF8Buffer utf8Buffer, Buffer buffer, Runnable runnable) {
            this.onFailure(CallbackConnection.createListenerNotSetError());
        }

        public void onFailure(Throwable value) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), value);
        }
    };
    private final DispatchQueue queue;
    private final MQTT mqtt;
    private Transport transport;
    private Listener listener = DEFAULT_LISTENER;
    private Runnable refiller;
    private HashMap<Short, Request> requests = new HashMap();
    private LinkedList<Request> overflow = new LinkedList();
    private HashSet<Short> processed = new HashSet();
    private Throwable failure;
    private boolean disconnected = false;
    private HeartBeatMonitor heartBeatMonitor;
    private long pingedAt;
    private long reconnects = 0L;
    private AtomicInteger suspendCount = new AtomicInteger(0);
    private AtomicInteger suspendChanges = new AtomicInteger(0);
    private HashMap<UTF8Buffer, QoS> activeSubs = new HashMap();
    boolean onRefillCalled = false;
    short nextMessageId = 1;
    public static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };

    public CallbackConnection(MQTT mqtt) {
        this.mqtt = mqtt;
        this.queue = this.mqtt.dispatchQueue == null ? Dispatch.createQueue("mqtt client") : this.mqtt.dispatchQueue;
    }

    public void connect(Callback<Void> cb) {
        assert (cb != null) : "Callback should not be null.";
        if (this.transport != null) {
            cb.onFailure(new IllegalStateException("Already connected"));
            return;
        }
        try {
            this.createTransport(new LoginHandler(cb, true));
        }
        catch (Throwable e) {
            cb.onFailure(e);
        }
    }

    void handleSessionFailure(Throwable error) {
        if (!(this.disconnected || this.mqtt.reconnectAttemptsMax >= 0L && this.reconnects >= this.mqtt.reconnectAttemptsMax)) {
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.stop();
                this.heartBeatMonitor = null;
            }
            Transport t = this.transport;
            this.transport = null;
            if (t != null) {
                t.stop(new Runnable(){

                    public void run() {
                        CallbackConnection.this.listener.onDisconnected();
                        try {
                            CallbackConnection.this.createTransport(new LoginHandler(new Callback<Void>(){

                                @Override
                                public void onSuccess(Void value) {
                                    LinkedList originalOverflow = CallbackConnection.this.overflow;
                                    HashMap originalRequests = CallbackConnection.this.requests;
                                    CallbackConnection.this.overflow = new LinkedList();
                                    CallbackConnection.this.requests = new HashMap();
                                    if (!CallbackConnection.this.activeSubs.isEmpty()) {
                                        ArrayList<Topic> topics = new ArrayList<Topic>(CallbackConnection.this.activeSubs.size());
                                        for (Map.Entry entry : CallbackConnection.this.activeSubs.entrySet()) {
                                            topics.add(new Topic((UTF8Buffer)entry.getKey(), (QoS)((Object)entry.getValue())));
                                        }
                                        CallbackConnection.this.send(new SUBSCRIBE().topics(topics.toArray(new Topic[topics.size()])), null);
                                    }
                                    for (Map.Entry entry : originalRequests.entrySet()) {
                                        MQTTFrame frame = ((Request)entry.getValue()).frame;
                                        frame.dup(true);
                                        CallbackConnection.this.send((Request)entry.getValue());
                                    }
                                    for (Request request : originalOverflow) {
                                        CallbackConnection.this.send(request);
                                    }
                                }

                                @Override
                                public void onFailure(Throwable value) {
                                    CallbackConnection.this.handleFatalFailure(value);
                                }
                            }, false));
                        }
                        catch (Throwable e) {
                            CallbackConnection.this.handleFatalFailure(e);
                        }
                    }
                });
            }
        } else {
            this.handleFatalFailure(error);
        }
    }

    void reconnect(final Callback<Transport> onConnect) {
        long reconnectDelay = this.mqtt.reconnectDelay;
        if (reconnectDelay > 0L && this.mqtt.reconnectBackOffMultiplier > 1.0) {
            reconnectDelay = (long)Math.pow(this.mqtt.reconnectDelay * this.reconnects, this.mqtt.reconnectBackOffMultiplier);
        }
        reconnectDelay = Math.min(reconnectDelay, this.mqtt.reconnectDelayMax);
        ++this.reconnects;
        this.queue.executeAfter(reconnectDelay, TimeUnit.MILLISECONDS, new Runnable(){

            public void run() {
                if (CallbackConnection.this.disconnected) {
                    onConnect.onFailure(CallbackConnection.createDisconnectedError());
                } else {
                    try {
                        CallbackConnection.this.createTransport(onConnect);
                    }
                    catch (Exception e) {
                        onConnect.onFailure(e);
                    }
                }
            }
        });
    }

    void createTransport(final Callback<Transport> onConnect) throws Exception {
        TcpTransport transport;
        String scheme = this.mqtt.host.getScheme();
        if ("tcp".equals(scheme)) {
            transport = new TcpTransport();
        } else if (SslTransport.protocol(scheme) != null) {
            SslTransport ssl = new SslTransport();
            if (this.mqtt.sslContext == null) {
                this.mqtt.sslContext = SSLContext.getInstance(SslTransport.protocol(scheme));
            }
            ssl.setSSLContext(this.mqtt.sslContext);
            if (this.mqtt.blockingExecutor == null) {
                CallbackConnection callbackConnection = this;
                this.mqtt.blockingExecutor = callbackConnection.mqtt.getBlockingThreadPool();
            }
            ssl.setBlockingExecutor(this.mqtt.blockingExecutor);
            transport = ssl;
        } else {
            throw new Exception("Unsupported URI scheme '" + scheme + "'");
        }
        transport.setDispatchQueue(this.queue);
        transport.setProtocolCodec(new MQTTProtocolCodec());
        if (transport instanceof TcpTransport) {
            TcpTransport tcp = transport;
            tcp.setMaxReadRate(this.mqtt.maxReadRate);
            tcp.setMaxWriteRate(this.mqtt.maxWriteRate);
            tcp.setReceiveBufferSize(this.mqtt.receiveBufferSize);
            tcp.setSendBufferSize(this.mqtt.sendBufferSize);
            tcp.setTrafficClass(this.mqtt.trafficClass);
            tcp.setUseLocalHost(this.mqtt.useLocalHost);
            tcp.connecting(this.mqtt.host, this.mqtt.localAddress);
        }
        transport.setTransportListener(new DefaultTransportListener(){

            public void onTransportConnected() {
                if (CallbackConnection.this.disconnected) {
                    this.onFailure(CallbackConnection.createDisconnectedError());
                } else {
                    onConnect.onSuccess(transport);
                }
            }

            public void onTransportFailure(IOException error) {
                this.onFailure(error);
            }

            private void onFailure(final Throwable error) {
                if (!transport.isClosed()) {
                    transport.stop(new Runnable(){

                        public void run() {
                            onConnect.onFailure(error);
                        }
                    });
                }
            }
        });
        transport.start(NOOP);
    }

    public void onSessionEstablished(Transport transport) {
        this.transport = transport;
        if (this.suspendCount.get() > 0) {
            this.transport.suspendRead();
        }
        this.transport.setTransportListener(new DefaultTransportListener(){

            public void onTransportCommand(Object command) {
                CallbackConnection.this.processFrame((MQTTFrame)command);
            }

            public void onRefill() {
                CallbackConnection.this.onRefillCalled = true;
                CallbackConnection.this.drainOverflow();
            }

            public void onTransportFailure(IOException error) {
                CallbackConnection.this.handleSessionFailure(error);
            }
        });
        this.pingedAt = 0L;
        if (this.mqtt.getKeepAlive() > 0) {
            this.heartBeatMonitor = new HeartBeatMonitor();
            this.heartBeatMonitor.setWriteInterval(this.mqtt.getKeepAlive() * 1000 / 2);
            this.heartBeatMonitor.setTransport(this.transport);
            this.heartBeatMonitor.suspendRead();
            this.heartBeatMonitor.setOnKeepAlive(new Runnable(){

                public void run() {
                    if (!CallbackConnection.this.disconnected && CallbackConnection.this.pingedAt == 0L && CallbackConnection.this.transport.offer(new PINGREQ().encode())) {
                        final long now = System.currentTimeMillis();
                        final long suspends = CallbackConnection.this.suspendChanges.get();
                        CallbackConnection.this.pingedAt = now;
                        CallbackConnection.this.queue.executeAfter(CallbackConnection.this.mqtt.getKeepAlive(), TimeUnit.SECONDS, new Runnable(){

                            public void run() {
                                if (now == CallbackConnection.this.pingedAt) {
                                    if (suspends == (long)CallbackConnection.this.suspendChanges.get() && CallbackConnection.this.suspendCount.get() > 0) {
                                        CallbackConnection.this.handleFatalFailure(new IllegalStateException("The connection has remained suspended for an extended period of time so it cannot do proper keep alive processing.  Did you forget to resume the connection?"));
                                    } else {
                                        CallbackConnection.this.handleSessionFailure(new ProtocolException("Ping timeout").fillInStackTrace());
                                    }
                                }
                            }
                        });
                    }
                }
            });
            this.heartBeatMonitor.start();
        }
    }

    public Transport transport() {
        return this.transport;
    }

    public DispatchQueue getDispatchQueue() {
        return this.queue;
    }

    public void resume() {
        this.suspendChanges.incrementAndGet();
        if (this.suspendCount.decrementAndGet() == 0 && this.transport != null) {
            this.transport.resumeRead();
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.resumeRead();
            }
        }
    }

    public void suspend() {
        this.suspendChanges.incrementAndGet();
        if (this.suspendCount.incrementAndGet() == 1 && this.transport != null) {
            this.transport.suspendRead();
            if (this.heartBeatMonitor != null) {
                this.heartBeatMonitor.suspendRead();
            }
        }
    }

    public CallbackConnection refiller(Runnable refiller) {
        this.queue.assertExecuting();
        this.refiller = refiller;
        return this;
    }

    public CallbackConnection listener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public boolean full() {
        this.queue.assertExecuting();
        return this.transport.full();
    }

    public Throwable failure() {
        this.queue.assertExecuting();
        return this.failure;
    }

    public void disconnect(final Callback<Void> onComplete) {
        if (this.disconnected) {
            if (onComplete != null) {
                onComplete.onSuccess(null);
            }
            return;
        }
        this.disconnected = true;
        final short requestId = this.getNextMessageId();
        final Runnable stop = new Runnable(){
            boolean executed = false;

            public void run() {
                if (!this.executed) {
                    this.executed = true;
                    CallbackConnection.this.requests.remove(requestId);
                    if (CallbackConnection.this.heartBeatMonitor != null) {
                        CallbackConnection.this.heartBeatMonitor.stop();
                        CallbackConnection.this.heartBeatMonitor = null;
                    }
                    CallbackConnection.this.transport.stop(new Runnable(){

                        public void run() {
                            CallbackConnection.this.listener.onDisconnected();
                            if (onComplete != null) {
                                onComplete.onSuccess(null);
                            }
                        }
                    });
                }
            }
        };
        Callback<Void> cb = new Callback<Void>(){

            @Override
            public void onSuccess(Void v) {
                CallbackConnection.this.onRefillCalled = false;
                CallbackConnection.this.refiller = new Runnable(){

                    public void run() {
                        if (CallbackConnection.this.onRefillCalled) {
                            stop.run();
                        }
                    }
                };
                CallbackConnection.this.transport.flush();
            }

            @Override
            public void onFailure(Throwable value) {
                stop.run();
            }
        };
        if (this.transport != null) {
            MQTTFrame frame = new DISCONNECT().encode();
            this.send(new Request(this.getNextMessageId(), frame, cb));
        } else {
            cb.onSuccess(null);
        }
    }

    public void kill(final Callback<Void> onComplete) {
        if (this.disconnected) {
            if (onComplete != null) {
                onComplete.onSuccess(null);
            }
            return;
        }
        this.disconnected = true;
        if (this.heartBeatMonitor != null) {
            this.heartBeatMonitor.stop();
            this.heartBeatMonitor = null;
        }
        this.transport.stop(new Runnable(){

            public void run() {
                CallbackConnection.this.listener.onDisconnected();
                if (onComplete != null) {
                    onComplete.onSuccess(null);
                }
            }
        });
    }

    public void publish(String topic, byte[] payload, QoS qos, boolean retain, Callback<Void> cb) {
        this.publish(Buffer.utf8(topic), new Buffer(payload), qos, retain, cb);
    }

    public void publish(UTF8Buffer topic, Buffer payload, QoS qos, boolean retain, Callback<Void> cb) {
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        PUBLISH command = new PUBLISH().qos(qos).retain(retain);
        command.topicName(topic).payload(payload);
        this.send(command, cb);
    }

    public void subscribe(final Topic[] topics, Callback<byte[]> cb) {
        if (topics == null) {
            throw new IllegalArgumentException("topics must not be null");
        }
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        if (this.listener == DEFAULT_LISTENER) {
            cb.onFailure(CallbackConnection.createListenerNotSetError());
        } else {
            this.send(new SUBSCRIBE().topics(topics), new ProxyCallback<byte[]>(cb){

                @Override
                public void onSuccess(byte[] value) {
                    for (Topic topic : topics) {
                        CallbackConnection.this.activeSubs.put(topic.name(), topic.qos());
                    }
                    if (this.next != null) {
                        this.next.onSuccess(value);
                    }
                }
            });
        }
    }

    public void unsubscribe(final UTF8Buffer[] topics, Callback<Void> cb) {
        this.queue.assertExecuting();
        if (this.disconnected) {
            cb.onFailure(CallbackConnection.createDisconnectedError());
            return;
        }
        this.send(new UNSUBSCRIBE().topics(topics), new ProxyCallback(cb){

            public void onSuccess(Object value) {
                for (UTF8Buffer topic : topics) {
                    CallbackConnection.this.activeSubs.remove(topic);
                }
                if (this.next != null) {
                    this.next.onSuccess(value);
                }
            }
        });
    }

    private void send(MessageSupport.Acked command, Callback cb) {
        short id = 0;
        if (command.qos() != QoS.AT_MOST_ONCE) {
            id = this.getNextMessageId();
            command.messageId(id);
        }
        this.send(new Request(id, command.encode(), cb));
    }

    private void send(Request request) {
        if (this.failure != null) {
            if (request.cb != null) {
                request.cb.onFailure(this.failure);
            }
        } else if (this.overflow.isEmpty() && this.transport != null && this.transport.offer(request.frame)) {
            if (request.id == 0) {
                if (request.cb != null) {
                    request.cb.onSuccess(null);
                }
            } else {
                this.requests.put(request.id, request);
            }
        } else {
            this.overflow.addLast(request);
        }
    }

    private short getNextMessageId() {
        short rc = this.nextMessageId;
        this.nextMessageId = (short)(this.nextMessageId + 1);
        if (this.nextMessageId == 0) {
            this.nextMessageId = 1;
        }
        return rc;
    }

    private void drainOverflow() {
        Request request;
        this.queue.assertExecuting();
        if (this.overflow.isEmpty() || this.transport == null) {
            return;
        }
        while ((request = this.overflow.peek()) != null && this.transport.offer(request.frame)) {
            this.overflow.removeFirst();
            if (request.id == 0) {
                if (request.cb == null) continue;
                request.cb.onSuccess(null);
                continue;
            }
            this.requests.put(request.id, request);
        }
        if (this.overflow.isEmpty() && this.refiller != null) {
            try {
                this.refiller.run();
            }
            catch (Throwable e) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
        }
    }

    private void completeRequest(short id, byte originalType, Object arg) {
        Request request = this.requests.remove(id);
        if (request != null) {
            assert (originalType == request.frame.messageType());
            if (request.cb != null) {
                if (arg == null) {
                    request.cb.onSuccess(null);
                } else {
                    request.cb.onSuccess(arg);
                }
            }
        } else {
            this.handleFatalFailure(new ProtocolException("Command from server contained an invalid message id: " + id));
        }
    }

    private void processFrame(MQTTFrame frame) {
        try {
            switch (frame.messageType()) {
                case 3: {
                    PUBLISH publish = new PUBLISH().decode(frame);
                    this.toReceiver(publish);
                    break;
                }
                case 6: {
                    PUBREL ack = new PUBREL().decode(frame);
                    this.processed.remove(ack.messageId());
                    PUBCOMP response = new PUBCOMP();
                    response.messageId(ack.messageId());
                    this.send(new Request(0, response.encode(), null));
                    break;
                }
                case 4: {
                    PUBACK ack = new PUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)3, null);
                    break;
                }
                case 5: {
                    PUBREC ack = new PUBREC().decode(frame);
                    PUBREL response = new PUBREL();
                    response.messageId(ack.messageId());
                    this.send(new Request(0, response.encode(), null));
                    break;
                }
                case 7: {
                    PUBCOMP ack = new PUBCOMP().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)3, null);
                    break;
                }
                case 9: {
                    SUBACK ack = new SUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)8, ack.grantedQos());
                    break;
                }
                case 11: {
                    UNSUBACK ack = new UNSUBACK().decode(frame);
                    this.completeRequest(ack.messageId(), (byte)10, null);
                    break;
                }
                case 13: {
                    this.pingedAt = 0L;
                    break;
                }
                default: {
                    throw new ProtocolException("Unexpected MQTT command type: " + frame.messageType());
                }
            }
        }
        catch (Throwable e) {
            this.handleFatalFailure(e);
        }
    }

    private void toReceiver(final PUBLISH publish) {
        if (this.listener != null) {
            try {
                Runnable cb = NOOP;
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: {
                        cb = new Runnable(){

                            public void run() {
                                PUBACK response = new PUBACK();
                                response.messageId(publish.messageId());
                                CallbackConnection.this.send(new Request(0, response.encode(), null));
                            }
                        };
                        break;
                    }
                    case EXACTLY_ONCE: {
                        cb = new Runnable(){

                            public void run() {
                                PUBREC response = new PUBREC();
                                response.messageId(publish.messageId());
                                CallbackConnection.this.processed.add(publish.messageId());
                                CallbackConnection.this.send(new Request(0, response.encode(), null));
                            }
                        };
                        if (!this.processed.contains(publish.messageId())) break;
                        cb.run();
                        return;
                    }
                }
                this.listener.onPublish(publish.topicName(), publish.payload(), cb);
            }
            catch (Throwable e) {
                this.handleFatalFailure(e);
            }
        }
    }

    private void handleFatalFailure(Throwable error) {
        if (this.failure == null) {
            this.failure = error;
            ArrayList<Request> values = new ArrayList<Request>(this.requests.values());
            this.requests.clear();
            for (Request value : values) {
                if (value.cb == null) continue;
                value.cb.onFailure(this.failure);
            }
            ArrayList<Request> overflowEntries = new ArrayList<Request>(this.overflow);
            this.overflow.clear();
            for (Request entry : overflowEntries) {
                if (entry.cb == null) continue;
                entry.cb.onFailure(this.failure);
            }
            if (this.listener != null && !this.disconnected) {
                try {
                    this.listener.onFailure(this.failure);
                }
                catch (Exception e) {
                    Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                }
            }
        }
    }

    private static IllegalStateException createListenerNotSetError() {
        return (IllegalStateException)new IllegalStateException("No connection listener set to handle message received from the server.").fillInStackTrace();
    }

    private static IllegalStateException createDisconnectedError() {
        return (IllegalStateException)new IllegalStateException("Disconnected").fillInStackTrace();
    }

    private static String hex(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            return HexSupport.toHexFromBuffer(new Buffer(isa.getAddress().getAddress())) + Integer.toHexString(isa.getPort());
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoginHandler
    implements Callback<Transport> {
        final Callback<Void> cb;
        private final boolean initialConnect;

        LoginHandler(Callback<Void> cb, boolean initialConnect) {
            this.cb = cb;
            this.initialConnect = initialConnect;
        }

        @Override
        public void onSuccess(final Transport transport) {
            transport.setTransportListener(new DefaultTransportListener(){

                public void onTransportFailure(IOException error) {
                }

                public void onTransportCommand(Object command) {
                    MQTTFrame response = (MQTTFrame)command;
                    try {
                        block1 : switch (response.messageType()) {
                            case 2: {
                                CONNACK connack = new CONNACK().decode(response);
                                switch (connack.code()) {
                                    case CONNECTION_ACCEPTED: {
                                        CallbackConnection.this.onSessionEstablished(transport);
                                        LoginHandler.this.cb.onSuccess(null);
                                        CallbackConnection.this.listener.onConnected();
                                        CallbackConnection.this.queue.execute(new Runnable(){

                                            public void run() {
                                                CallbackConnection.this.drainOverflow();
                                            }
                                        });
                                        break block1;
                                    }
                                }
                                LoginHandler.this.cb.onFailure(new IOException("Could not connect: " + (Object)((Object)connack.code())));
                                break;
                            }
                            default: {
                                LoginHandler.this.cb.onFailure(new IOException("Could not connect. Received unexpected command: " + response.messageType()));
                                break;
                            }
                        }
                    }
                    catch (ProtocolException e) {
                        LoginHandler.this.cb.onFailure(e);
                    }
                }
            });
            transport.resumeRead();
            if (((CallbackConnection)CallbackConnection.this).mqtt.connect.clientId() == null) {
                String id = CallbackConnection.hex(transport.getLocalAddress()) + Long.toHexString(System.currentTimeMillis() / 1000L);
                if (id.length() > 23) {
                    id = id.substring(0, 23);
                }
                ((CallbackConnection)CallbackConnection.this).mqtt.connect.clientId(Buffer.utf8(id));
            }
            boolean accepted = transport.offer(((CallbackConnection)CallbackConnection.this).mqtt.connect.encode());
            assert (accepted) : "First frame should always be accepted by the transport";
        }

        private boolean tryReconnect() {
            if (this.initialConnect) {
                return ((CallbackConnection)CallbackConnection.this).mqtt.connectAttemptsMax < 0L || CallbackConnection.this.reconnects < ((CallbackConnection)CallbackConnection.this).mqtt.connectAttemptsMax;
            }
            return ((CallbackConnection)CallbackConnection.this).mqtt.reconnectAttemptsMax < 0L || CallbackConnection.this.reconnects < ((CallbackConnection)CallbackConnection.this).mqtt.reconnectAttemptsMax;
        }

        @Override
        public void onFailure(Throwable value) {
            if (!CallbackConnection.this.disconnected && this.tryReconnect()) {
                CallbackConnection.this.reconnect(this);
            } else {
                this.cb.onFailure(value);
            }
        }
    }

    private static class Request {
        final MQTTFrame frame;
        private final short id;
        final Callback cb;

        Request(int id, MQTTFrame frame, Callback cb) {
            this.id = (short)id;
            this.cb = cb;
            this.frame = frame;
        }
    }
}

