/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="cust-info")
public class CustomerInfo {
    private static Logger log;
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private int population;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private double controllableKW;
    @XStreamAsAttribute
    private double upRegulationKW;
    @XStreamAsAttribute
    private double downRegulationKW;
    @XStreamAsAttribute
    private double storageCapacity;
    @XStreamAsAttribute
    private boolean multiContracting;
    @XStreamAsAttribute
    private boolean canNegotiate;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("CustomerInfo.java", Class.forName("org.powertac.common.CustomerInfo"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.CustomerInfo", "java.lang.String:int:", "name:population:", ""), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPopulation", "org.powertac.common.CustomerInfo", "java.lang.Integer:", "population:", "", "void"), 120);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPowerType", "org.powertac.common.CustomerInfo", "org.powertac.common.enumerations.PowerType:", "type:", "", "org.powertac.common.CustomerInfo"), 139);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMultiContracting", "org.powertac.common.CustomerInfo", "boolean:", "value:", "", "org.powertac.common.CustomerInfo"), 160);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withCanNegotiate", "org.powertac.common.CustomerInfo", "boolean:", "value:", "", "org.powertac.common.CustomerInfo"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withControllableKW", "org.powertac.common.CustomerInfo", "double:", "value:", "", "org.powertac.common.CustomerInfo"), 213);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withUpRegulationKW", "org.powertac.common.CustomerInfo", "double:", "value:", "", "org.powertac.common.CustomerInfo"), 240);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDownRegulationKW", "org.powertac.common.CustomerInfo", "double:", "value:", "", "org.powertac.common.CustomerInfo"), 267);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withStorageCapacity", "org.powertac.common.CustomerInfo", "double:", "value:", "", "org.powertac.common.CustomerInfo"), 292);
        log = Logger.getLogger(CustomerInfo.class.getName());
    }

    public CustomerInfo(String name, int population) {
        String string = name;
        int n = population;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this, string, Conversions.intObject(n));
        this.id = IdGenerator.createId();
        this.controllableKW = 0.0;
        this.upRegulationKW = 0.0;
        this.downRegulationKW = 0.0;
        this.storageCapacity = 0.0;
        this.multiContracting = false;
        this.canNegotiate = false;
        this.powerType = PowerType.CONSUMPTION;
        this.name = name;
        this.population = population;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPopulation() {
        return this.population;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setPopulation(Integer n) {
        void population;
        Integer n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, n2);
        this.population = population.intValue();
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withPowerType(PowerType powerType) {
        void type;
        PowerType powerType2 = powerType;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, powerType2);
        this.powerType = type;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isMultiContracting() {
        return this.multiContracting;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withMultiContracting(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.multiContracting = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isCanNegotiate() {
        return this.canNegotiate;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withCanNegotiate(boolean bl) {
        void value;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.booleanObject(bl2));
        this.canNegotiate = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getControllableKW() {
        return this.controllableKW;
    }

    @Deprecated
    public double getControllableKWh() {
        return this.controllableKW;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withControllableKW(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.doubleObject(d2));
        if (value > 0.0) {
            log.error(String.valueOf(this.getName()) + ": controllableKW " + (double)value + " must be non-positive");
        } else {
            this.controllableKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getUpRegulationKW() {
        return this.upRegulationKW;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withUpRegulationKW(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, Conversions.doubleObject(d2));
        if (value > 0.0) {
            log.error(String.valueOf(this.getName()) + ": upRegulationKW " + (double)value + " must be non-positive");
        } else {
            this.upRegulationKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getDownRegulationKW() {
        return this.downRegulationKW;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withDownRegulationKW(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.doubleObject(d2));
        if (value < 0.0) {
            log.error(String.valueOf(this.getName()) + ": downRegulationKW " + (double)value + " must be non-negative");
        } else {
            this.downRegulationKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getStorageCapacity() {
        return this.storageCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public CustomerInfo withStorageCapacity(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.doubleObject(d2));
        if (value < 0.0) {
            log.error(String.valueOf(this.getName()) + ": storageCapacity " + (double)value + " must be non-negative");
        } else {
            this.storageCapacity = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public String toString() {
        return "CustomerInfo(" + this.name + ")";
    }
}

