/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="orderbook")
public class Orderbook {
    @XStreamAsAttribute
    private long id;
    private Instant dateExecuted;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private Double clearingPrice;
    @XStreamImplicit(itemFieldName="bid")
    private SortedSet<OrderbookOrder> bids;
    @XStreamImplicit(itemFieldName="ask")
    private SortedSet<OrderbookOrder> asks;
    private static TimeslotRepo timeslotRepo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Orderbook(int timeslot, Double clearingPrice, Instant dateExecuted) {
        int n = timeslot;
        Double d = clearingPrice;
        Instant instant = dateExecuted;
        Object[] objectArray = new Object[]{Conversions.intObject(n), d, instant};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, objectArray);
        this.id = IdGenerator.createId();
        this.bids = new TreeSet<OrderbookOrder>();
        this.asks = new TreeSet<OrderbookOrder>();
        this.timeslot = timeslot;
        this.clearingPrice = clearingPrice;
        this.dateExecuted = dateExecuted;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    @ChainedConstructor
    public Orderbook(Timeslot timeslot, Double clearingPrice, Instant dateExecuted) {
        this(timeslot.getSerialNumber(), clearingPrice, dateExecuted);
    }

    public long getId() {
        return this.id;
    }

    public Double getClearingPrice() {
        return this.clearingPrice;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return Orderbook.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public SortedSet<OrderbookOrder> getBids() {
        if (this.bids == null) {
            this.bids = new TreeSet<OrderbookOrder>();
        }
        return this.bids;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Orderbook addBid(OrderbookOrder orderbookOrder) {
        void bid;
        OrderbookOrder orderbookOrder2 = orderbookOrder;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, orderbookOrder2);
        this.bids.add((OrderbookOrder)bid);
        Orderbook orderbook = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return orderbook;
    }

    public SortedSet<OrderbookOrder> getAsks() {
        if (this.asks == null) {
            this.asks = new TreeSet<OrderbookOrder>();
        }
        return this.asks;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Orderbook addAsk(OrderbookOrder orderbookOrder) {
        void ask;
        OrderbookOrder orderbookOrder2 = orderbookOrder;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, orderbookOrder2);
        this.asks.add((OrderbookOrder)ask);
        Orderbook orderbook = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return orderbook;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (timeslotRepo == null) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }

    static {
        Factory factory = new Factory("Orderbook.java", Class.forName("org.powertac.common.Orderbook"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Orderbook", "int:java.lang.Double:org.joda.time.Instant:", "timeslot:clearingPrice:dateExecuted:", ""), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBid", "org.powertac.common.Orderbook", "org.powertac.common.OrderbookOrder:", "bid:", "", "org.powertac.common.Orderbook"), 145);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAsk", "org.powertac.common.Orderbook", "org.powertac.common.OrderbookOrder:", "ask:", "", "org.powertac.common.Orderbook"), 166);
    }
}

