/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.config.ConfigurationRecorder;
import org.powertac.util.Predicate;

public class Configurator {
    private static Logger log = Logger.getLogger(Configurator.class);
    private Configuration config;
    private HashMap<Class, HashMap<String, ConfigurableProperty>> annotationMap = new HashMap();

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void configureSingleton(Object thing) {
        if (this.config == null) {
            log.error("Cannot configure - no Configuration set");
            return;
        }
        String[] classnamePath = this.extractClassnamePath(thing);
        if (classnamePath == null) {
            return;
        }
        Configuration subset = this.extractConfigForClass(classnamePath);
        if (this.isSingletonConfig(subset)) {
            this.configureInstance(thing, subset);
        } else {
            log.error("Attempt to configure Singleton with multi-instance config data");
        }
    }

    private String[] extractClassnamePath(Object thing) {
        String classname = thing.getClass().getName();
        log.debug("configuring object of type " + classname);
        String[] classnamePath = classname.split("\\.");
        return classnamePath;
    }

    public Collection<?> configureInstances(Class<?> type) {
        if (this.config == null) {
            log.error("Cannot configure - no Configuration set");
            return null;
        }
        String classname = type.getName();
        log.debug("configuring instances for type " + classname);
        String[] classnamePath = classname.split("\\.");
        Configuration subset = this.extractConfigForClass(classnamePath);
        List names = subset.getList("instances");
        if (names.size() == 0) {
            log.warn("No instance names specified for class " + classname);
            return null;
        }
        HashMap itemMap = new HashMap();
        for (Object name : names) {
            try {
                Constructor<?> constructor = type.getConstructor(String.class);
                Object item = constructor.newInstance((String)name);
                itemMap.put((String)name, item);
            }
            catch (Exception e) {
                log.error("Unable to create instance " + name + " of class " + type + ": " + e.toString());
            }
        }
        for (Object name : itemMap.keySet()) {
            this.configureInstance(itemMap.get(name), subset.subset((String)name));
        }
        return itemMap.values();
    }

    public void gatherPublishedConfiguration(Object thing, ConfigurationRecorder recorder) {
        this.gatherConfiguration(thing, null, recorder, new Predicate<ConfigurableProperty>(){

            @Override
            public boolean apply(ConfigurableProperty prop) {
                return prop.cv.publish();
            }
        });
    }

    public void gatherBootstrapState(Object thing, ConfigurationRecorder recorder) {
        if (thing instanceof List) {
            this.gatherBootstrapList((List)thing, recorder);
        } else {
            this.gatherConfiguration(thing, null, recorder, new Predicate<ConfigurableProperty>(){

                @Override
                public boolean apply(ConfigurableProperty prop) {
                    return prop.cv.bootstrapState();
                }
            });
        }
    }

    public void gatherBootstrapList(List<Object> things, ConfigurationRecorder recorder) {
        for (Object thing : things) {
            Class<?> thingClass = thing.getClass();
            try {
                Method getNameMethod = thingClass.getMethod("getName", new Class[0]);
                Object name = getNameMethod.invoke(thing, new Object[0]);
                if (name == null) {
                    log.error("Null name for " + thing.toString());
                    continue;
                }
                this.gatherConfiguration(thing, (String)name, recorder, new Predicate<ConfigurableProperty>(){

                    @Override
                    public boolean apply(ConfigurableProperty prop) {
                        return prop.cv.bootstrapState();
                    }
                });
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Cannot extract bootstrap state from " + thing.toString() + ": no getName() method");
            }
            catch (SecurityException securityException) {
                log.error("Cannot extract bootstrap state from " + thing.toString() + ": security exception");
            }
            catch (Exception e) {
                log.error(String.valueOf(e.toString()) + " calling thing.getName()");
            }
        }
    }

    private void gatherConfiguration(Object thing, String name, ConfigurationRecorder recorder, Predicate<ConfigurableProperty> p) {
        String prefix = this.extractClassnamePrefix(this.extractClassnamePath(thing));
        Map<String, ConfigurableProperty> analysis = this.getAnalysis(thing.getClass());
        for (Map.Entry<String, ConfigurableProperty> prop : analysis.entrySet()) {
            ConfigurableProperty cp = prop.getValue();
            if (!p.apply(cp)) continue;
            String key = prefix;
            if (name != null) {
                key = String.valueOf(key) + "." + name;
            }
            key = String.valueOf(key) + "." + prop.getKey();
            log.debug("Recording property " + key);
            Object value = null;
            try {
                if (cp.field != null) {
                    cp.field.setAccessible(true);
                    value = cp.field.get(thing);
                } else if (cp.getter != null) {
                    value = cp.getter.invoke(thing, new Object[0]);
                } else {
                    throw new Exception("field and getter both null");
                }
                recorder.recordItem(key, value);
            }
            catch (IllegalArgumentException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (IllegalAccessException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (InvocationTargetException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (Exception e) {
                log.error("cannot read published value: " + e.toString());
            }
        }
    }

    private Configuration extractConfigForClass(String[] classnamePath) {
        String prefix = this.extractClassnamePrefix(classnamePath);
        log.debug("config prefix " + prefix);
        Configuration subset = this.config.subset(prefix);
        log.debug("config subset empty: " + subset.isEmpty());
        return subset;
    }

    private String extractClassnamePrefix(String[] classnamePath) {
        StringBuilder sb = new StringBuilder();
        int startIndex = 2;
        if (!classnamePath[0].equals("org") || !classnamePath[1].equals("powertac")) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < classnamePath.length - 1) {
            sb.append(classnamePath[i]).append(".");
            ++i;
        }
        sb.append(this.decapitalize(classnamePath[classnamePath.length - 1]));
        String prefix = sb.toString();
        return prefix;
    }

    private boolean isSingletonConfig(Configuration conf) {
        boolean result = true;
        Iterator keys = conf.getKeys();
        while (keys.hasNext() && result) {
            String key = (String)keys.next();
            if (!key.contains(".")) continue;
            result = false;
        }
        return result;
    }

    private void configureInstance(Object thing, Configuration conf) {
        Map<String, ConfigurableProperty> analysis = this.getAnalysis(thing.getClass());
        Iterator keys = conf.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            log.debug("Configuring property " + key);
            ConfigurableProperty cp = analysis.get(key);
            if (cp == null) {
                log.error("no configurable property named " + key + " on class " + thing.getClass().getName());
                continue;
            }
            ConfigurableValue cv = cp.cv;
            String type = cv.valueType();
            try {
                Object configValue;
                Object defaultValue = null;
                if (cp.field != null) {
                    cp.field.setAccessible(true);
                    defaultValue = cp.field.get(thing);
                    configValue = this.extractConfigValue(conf, key, type, defaultValue);
                    cp.field.set(thing, configValue);
                    continue;
                }
                if (cp.setter != null) {
                    if (cp.getter != null) {
                        defaultValue = cp.getter.invoke(thing, new Object[0]);
                    }
                    configValue = this.extractConfigValue(conf, key, type, defaultValue);
                    cp.setter.invoke(thing, configValue);
                    continue;
                }
                log.error("No field, no method for cv " + key);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Class " + type + " not found");
            }
            catch (IllegalArgumentException e) {
                log.error("cannot configure " + key + ": " + this.getExceptionDetails(e));
            }
            catch (IllegalAccessException e) {
                log.error("cannot configure " + key + ": " + this.getExceptionDetails(e));
            }
            catch (InvocationTargetException e) {
                log.error("cannot configure " + key + ": " + this.getExceptionDetails(e));
            }
            catch (NoSuchMethodException e) {
                log.error("cannot configure " + key + ": " + this.getExceptionDetails(e));
            }
        }
    }

    private String getExceptionDetails(Exception e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.toString()).append("\n");
        int i = 0;
        while (i < 5) {
            sb.append("...").append(e.getStackTrace()[i].toString()).append("\n");
            ++i;
        }
        return sb.toString();
    }

    private Object extractConfigValue(Configuration conf, String key, String type, Object defaultValue) throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (type.equals("List")) {
            ArrayList<String> def = new ArrayList<String>();
            if (defaultValue != null) {
                for (Object thing : (List)defaultValue) {
                    def.add((String)thing);
                }
            }
            return conf.getList(key, def);
        }
        Class<?> clazz = this.findNamedClass(type);
        String extractorName = "get" + type;
        Method extractor = conf.getClass().getMethod(extractorName, String.class, clazz);
        return extractor.invoke((Object)conf, key, defaultValue);
    }

    private Class<?> findNamedClass(String type) throws ClassNotFoundException {
        Class<?> clazz = type.equals("List") ? Class.forName("java.util.List") : Class.forName("java.lang." + type);
        return clazz;
    }

    private Map<String, ConfigurableProperty> getAnalysis(Class<? extends Object> clazz) {
        HashMap<String, ConfigurableProperty> result = this.annotationMap.get(clazz);
        if (result == null) {
            Field[] fields;
            result = new HashMap();
            this.annotationMap.put(clazz, result);
            log.debug("Analyzing class " + clazz.getName());
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                ConfigurableValue cv = field.getAnnotation(ConfigurableValue.class);
                if (cv != null) {
                    log.debug("ConfigurableValue field " + field.getName());
                    String propertyName = cv.name();
                    if ("".equals(propertyName)) {
                        propertyName = field.getName();
                    }
                    result.put(propertyName, new ConfigurableProperty(field, cv));
                }
                ++n2;
            }
            Method[] methods = clazz.getMethods();
            Method getter = null;
            Method[] methodArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                ConfigurableValue cv = method.getAnnotation(ConfigurableValue.class);
                if (cv != null) {
                    String getterName;
                    log.debug("ConfigurableValue method found on " + method.getName());
                    String propertyName = cv.name();
                    if ("".equals(propertyName)) {
                        propertyName = this.extractPropertyName(method);
                    }
                    if ("".equals(getterName = cv.getter())) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("get").append(this.capitalize(propertyName));
                        getterName = sb.toString();
                        log.debug("getter name " + getterName);
                        try {
                            getter = clazz.getMethod(getterName, new Class[0]);
                            if (getter != null) {
                                Class<?> valueClass = this.findNamedClass(cv.valueType());
                                if (!getter.getReturnType().isPrimitive() && !valueClass.isAssignableFrom(getter.getReturnType())) {
                                    log.warn("Type mismatch: cannot use default value (" + getter.getReturnType().getName() + ") for " + cv.name() + " (" + valueClass.getName() + ")");
                                    getter = null;
                                }
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            log.error("No getter method " + getterName + " for " + clazz.getName());
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Could not find value class: " + e.toString());
                        }
                    }
                    result.put(propertyName, new ConfigurableProperty(method, getter, cv));
                }
                ++n4;
            }
        }
        return result;
    }

    private String extractPropertyName(Method method) {
        String name = method.getName();
        if (name.startsWith("set")) {
            log.debug("removing 'set' from " + name);
            name = name.substring(3);
        } else if (name.startsWith("with")) {
            log.debug("removing 'with' from " + name);
            name = name.substring(4);
        }
        return this.decapitalize(name);
    }

    private String decapitalize(String name) {
        char first = name.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(first)).append(name.substring(1));
        return sb.toString();
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(first)).append(name.substring(1));
        return sb.toString();
    }

    class ConfigurableProperty {
        Method setter;
        Method getter;
        Field field;
        ConfigurableValue cv;

        ConfigurableProperty(Method setter, Method getter, ConfigurableValue cv) {
            this.setter = setter;
            this.getter = getter;
            this.field = null;
            this.cv = cv;
        }

        ConfigurableProperty(Field field, ConfigurableValue cv) {
            this.setter = null;
            this.getter = null;
            this.field = field;
            this.cv = cv;
        }
    }
}

