/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.powertac.common.WeatherReport;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WeatherReportRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger(WeatherReportRepo.class.getName());
    private Map<Integer, WeatherReport> indexedWeatherReports = new ConcurrentHashMap<Integer, WeatherReport>(2000, 0.9f, 1);
    private boolean hasRunOnce = false;
    @Autowired
    private TimeslotRepo timeslotRepo;

    public void add(WeatherReport weather) {
        this.runOnce();
        this.indexedWeatherReports.put(weather.getTimeslotIndex(), weather);
    }

    public WeatherReport currentWeatherReport() throws PowerTacException {
        if (!this.hasRunOnce) {
            log.error("Weather Service has yet to run, cannot retrieve report");
            throw new PowerTacException("Attempt to retrieve report before data available");
        }
        return this.indexedWeatherReports.get(this.timeslotRepo.currentSerialNumber());
    }

    public List<WeatherReport> allWeatherReports() {
        Integer current = this.timeslotRepo.currentSerialNumber();
        ArrayList<WeatherReport> issuedReports = new ArrayList<WeatherReport>();
        for (WeatherReport w : this.indexedWeatherReports.values()) {
            if (w.getTimeslotIndex() >= current) continue;
            issuedReports.add(w);
        }
        issuedReports.add(this.currentWeatherReport());
        return issuedReports;
    }

    public int count() {
        return this.indexedWeatherReports.size();
    }

    public void runOnce() {
        this.hasRunOnce = true;
    }

    @Override
    public void recycle() {
        this.hasRunOnce = false;
        this.indexedWeatherReports.clear();
    }
}

