/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.spring.SpringApplicationContext;

public class BrokerConverter
implements SingleValueConverter {
    private static Logger log = Logger.getLogger(BrokerConverter.class.getName());
    private BrokerRepo brokerRepo = (BrokerRepo)SpringApplicationContext.getBean("brokerRepo");

    @Override
    public boolean canConvert(Class type) {
        if (Broker.class.isAssignableFrom(type)) {
            return true;
        }
        log.info("BrokerConverter cannot convert " + type.getName());
        return false;
    }

    @Override
    public Object fromString(String username) {
        if (this.brokerRepo == null) {
            log.warn("no autowire BrokerRepo - using singleton");
            this.brokerRepo = BrokerRepo.getInstance();
        }
        return this.brokerRepo.findOrCreateByUsername(username);
    }

    @Override
    public String toString(Object broker) {
        return ((Broker)broker).getUsername();
    }
}

