/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.StatUtils;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Competition;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.TariffTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.common.msg.MarketBootstrapData;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.samplebroker.A29;
import org.powertac.samplebroker.C283;
import org.powertac.samplebroker.interfaces.Activatable;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.Initializable;
import org.powertac.samplebroker.interfaces.MM1;
import org.powertac.samplebroker.interfaces.PP1;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class M1
implements MM1,
Initializable,
Activatable {
    private BrokerContext a;
    @Autowired
    private TimeslotRepo b;
    @Autowired
    private PP1 c;
    @Autowired
    private C283 d;
    private Random e = new Random();
    private double f = -1.0;
    private double g = -70.0;
    private double h = 70.0;
    private double ii = 0.5;
    private double jj = 0.001;
    private double kk = 0.001;
    private double ll;
    private double mm;
    private HashMap<Integer, Order> nn;
    private double[] oo;
    private double[] pp;
    private double[][] qq;
    private double[] rr;
    private HashMap<Integer, Orderbook> ss;
    private double tt;
    private double uu;
    private TreeMap<Integer, ArrayList<A29.B>> vv;
    private DL ww;
    private ArrayList<Ch> xx;

    @Override
    public void initialize(BrokerContext brokerContext) {
        this.a = brokerContext;
        this.ll = 0.0;
        this.mm = 0.0;
        this.nn = new HashMap();
        this.oo = new double[this.d.bb.e()];
        this.pp = new double[this.d.bb.e()];
        this.qq = new double[24][2500];
        this.rr = new double[2500];
        this.ss = new HashMap();
        this.tt = -1.7976931348623157E308;
        this.uu = Double.MAX_VALUE;
        this.vv = new TreeMap();
        this.ww = new DL();
        this.xx = new ArrayList();
    }

    @Override
    public double a83() {
        if (this.ll == 0.0) {
            return 0.0;
        }
        return this.mm / this.ll;
    }

    @Override
    public double b82() {
        return this.a83() / 1000.0;
    }

    @Override
    public double c2394(int asd8fawr) {
        int asjas38 = asd8fawr % this.d.bb.e();
        double lsd8fw3 = this.oo[asjas38] * 1000.0;
        double sadfaw3r0 = this.pp[asjas38];
        return sadfaw3r0 / lsd8fw3;
    }

    @Override
    public double sd8f() {
        ArrayRealVector sdfj8 = this.ls83();
        return Math.sqrt(StatUtils.variance(sdfj8.toArray()));
    }

    @Override
    public ArrayRealVector ls83() {
        RealVector marketKWh_ = new ArrayRealVector(this.oo).mapMultiplyToSelf(1000.0);
        ArrayRealVector marketPayments_ = new ArrayRealVector(this.pp);
        ArrayRealVector marketAvgPricePerSlot = marketPayments_.ebeDivide(marketKWh_);
        return marketAvgPricePerSlot;
    }

    public synchronized void handleMessage(Competition comp) {
        this.jj = Math.max(this.jj, comp.getMinimumOrderQuantity());
    }

    public synchronized void handleMessage(BalancingTransaction tx) {
        if (tx.getCharge() < 0.0) {
            double mwhSuppliedToMe = -tx.getKWh() / 1000.0;
            this.xx.add(new Ch(tx.getCharge(), mwhSuppliedToMe));
        }
        if (this.d.l299()) {
            int timeslot = tx.getPostedTimeslotIndex();
            double mwh = -(tx.getKWh() / 1000.0);
            double price = tx.getCharge() / Math.abs(mwh);
            this.sdf8asa5(timeslot, mwh, price);
        }
    }

    public synchronized void handleMessage(ClearedTrade ct) {
        int timeslot = ct.getTimeslotIndex();
        double mwh = ct.getExecutionMWh();
        double price = ct.getExecutionPrice();
        int tradeCreationTimeslot = this.b.getTimeslotIndex(ct.getDateExecuted());
        if (!this.d.isUseMtx()) {
            this.sdf8asa5(timeslot, mwh, price);
        }
        this.lsd85(price);
        this.fdasdfa(tradeCreationTimeslot, timeslot, price, mwh);
    }

    void fdasdfa(int tradeCreationTimeslot, int timeslot, double price, double mwh) {
        int index = this.ld8(tradeCreationTimeslot, timeslot);
        double bidPrice = price;
        this.lsd8(index, bidPrice, mwh);
    }

    private void lsd8(int index, double bidPrice, double mwh) {
        ArrayList<A29.B> bidGroup = this.slld(index);
        A29.B trade = new A29.B(bidPrice, mwh);
        boolean exists = false;
        for (A29.B item : bidGroup) {
            if (item.ba() != trade.ba()) continue;
            item.b += trade.bb();
            exists = true;
            break;
        }
        if (!exists) {
            A29.ad(bidGroup, trade);
        }
    }

    private ArrayList<A29.B> slld(int bidGroupIndex) {
        ArrayList<A29.B> group = this.vv.get(bidGroupIndex);
        if (null == group) {
            group = new ArrayList();
            this.vv.put(bidGroupIndex, group);
        }
        return group;
    }

    private int ld8(int tradeCreationTimeslot, int timeslot) {
        int bidsSubmisionTimeslot = tradeCreationTimeslot - 1;
        return timeslot - bidsSubmisionTimeslot;
    }

    void lsd85(double price) {
        if (price > this.tt) {
            this.tt = price;
        }
        if (price < this.uu) {
            this.uu = price;
        }
    }

    public synchronized void handleMessage(DistributionTransaction dt) {
    }

    public synchronized void handleMessage(MarketBootstrapData data) {
        int discardedTimeslots = Competition.currentCompetition().getBootstrapDiscardedTimeslots();
        for (int i = 0; i < data.getMwh().length; ++i) {
            double mwh = data.getMwh()[i];
            double price = Math.abs(data.getMarketPrice()[i]);
            int timeslot = i + discardedTimeslots;
            this.sdf8asa5(timeslot, mwh, price);
        }
        double avgMktPrice = Math.abs(this.a83());
        this.g = -3.0 * avgMktPrice;
        this.h = 3.0 * avgMktPrice;
    }

    public synchronized void handleMessage(MarketPosition posn) {
        this.a.getBroker().addMarketPosition(posn, posn.getTimeslotIndex());
    }

    public synchronized void handleMessage(MarketTransaction tx) {
        Order lastTry = this.nn.get(tx.getTimeslotIndex());
        if (lastTry != null && tx.getMWh() == lastTry.getMWh().doubleValue()) {
            this.nn.put(tx.getTimeslotIndex(), null);
        }
        if (this.d.isUseMtx()) {
            this.sdf8asa5(tx.getTimeslotIndex(), Math.abs(tx.getMWh()), Math.abs(tx.getPrice()));
        }
    }

    public synchronized void handleMessage(Orderbook orderbook) {
        this.ss.put(orderbook.getTimeslotIndex(), orderbook);
    }

    public synchronized void handleMessage(WeatherForecast forecast) {
    }

    public synchronized void handleMessage(WeatherReport report) {
    }

    public synchronized void handleMessage(TariffTransaction ttx) {
        TariffTransaction.Type txType = ttx.getTxType();
        if ((TariffTransaction.Type.CONSUME == txType || TariffTransaction.Type.PRODUCE == txType) && ttx.getBroker().getUsername().equals(this.a.getBrokerUsername())) {
            double kwh = ttx.getKWh();
            int postedTimeslotIndex = ttx.getPostedTimeslotIndex();
            double oldKwh = this.rr[postedTimeslotIndex];
            this.rr[postedTimeslotIndex] = oldKwh + kwh;
        }
    }

    @Override
    public synchronized void activate(int currentTimeslotIndex) {
        try {
            List<Timeslot> enabledTimeslots = this.b.enabledTimeslots();
            try {
                this.lsd8383(enabledTimeslots);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                int prevTimeslot = currentTimeslotIndex - 1;
                String errors = " ee " + prevTimeslot + " a: " + String.format("%.2f", this.rr[prevTimeslot]) + " p: ";
                for (double[] p : this.qq) {
                    errors = errors + String.format("%.2f", p[prevTimeslot]) + " ";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            double neededKWh = 0.0;
            for (Timeslot timeslot : enabledTimeslots) {
                try {
                    int targetTimeslot = timeslot.getSerialNumber();
                    int index = targetTimeslot % this.d.bb.e();
                    neededKWh = this.c.sd82weds(index);
                    this.aljwe8(neededKWh, targetTimeslot, currentTimeslotIndex, enabledTimeslots);
                    this.ls8ra(-neededKWh, targetTimeslot, currentTimeslotIndex);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void sdf8asa5(int timeslot, double mwh, double price) {
        int index;
        int n = index = this.l338e(timeslot);
        this.oo[n] = this.oo[n] + mwh;
        int n2 = index;
        this.pp[n2] = this.pp[n2] + price * mwh;
        this.ll += mwh;
        this.mm += price * mwh;
    }

    private int l338e(int timeslot) {
        int bootstrapDiscardedTimeslots = Competition.currentCompetition().getBootstrapDiscardedTimeslots();
        return (timeslot - bootstrapDiscardedTimeslots) % this.d.bb.e();
    }

    private void ls8ra(double neededKWh, int futureTimeslot, int currentTimeslotIndex) {
        int predictionsIndex = this.s85qa(futureTimeslot, currentTimeslotIndex);
        this.qq[predictionsIndex][futureTimeslot] = neededKWh;
    }

    private int s85qa(int futureTimeslot, int currentTimeslotIndex) {
        return futureTimeslot - currentTimeslotIndex - 1;
    }

    protected void aljwe8(double neededKWh, int targetTimeslot, int currentTimeslotIndex, List<Timeslot> enabledTimeslots) {
        List<Order> orders;
        double neededMWh = neededKWh / 1000.0;
        MarketPosition posn = this.a.getBroker().findMarketPositionByTimeslot(targetTimeslot);
        if (posn != null) {
            neededMWh -= posn.getOverallBalance();
        }
        if (Math.abs(neededMWh) <= this.jj) {
            return;
        }
        if (neededMWh > 0.0) {
            switch (this.d.l2()) {
                case A: {
                    orders = this.sd8fa(targetTimeslot, currentTimeslotIndex, neededMWh);
                    break;
                }
                case C: {
                    orders = this.lsd8r(targetTimeslot, neededMWh);
                    break;
                }
                case D: {
                    if (this.sdll3(currentTimeslotIndex, enabledTimeslots)) {
                        List<Order> nonAdjustedOrders = this.asd7a3(targetTimeslot, neededMWh, currentTimeslotIndex);
                        orders = this.lsd8f(currentTimeslotIndex, nonAdjustedOrders);
                        break;
                    }
                    orders = this.sd8fa(targetTimeslot, currentTimeslotIndex, neededMWh);
                    break;
                }
                default: {
                    if (this.sdll3(currentTimeslotIndex, enabledTimeslots)) {
                        List<Order> nonAdjustedOrders = this.s58(targetTimeslot, neededMWh, currentTimeslotIndex);
                        orders = this.lsd8f(currentTimeslotIndex, nonAdjustedOrders);
                        break;
                    }
                    orders = this.sd8fa(targetTimeslot, currentTimeslotIndex, neededMWh);
                    break;
                }
            }
        } else {
            orders = this.sd8fa(targetTimeslot, currentTimeslotIndex, neededMWh);
        }
        if (orders != null) {
            this.ls8hws(targetTimeslot, orders);
        }
    }

    private List<Order> lsd8r(int targetTimeslot, double neededMWh) {
        ArrayList<Order> resultingOrders = new ArrayList<Order>();
        Order order = new Order(this.a.getBroker(), targetTimeslot, neededMWh, null);
        resultingOrders.add(order);
        return resultingOrders;
    }

    private List<Order> sd8fa(int targetTimeslot, int currentTimeslotIndex, double neededMWh) {
        ArrayList<Order> resultingOrders = new ArrayList<Order>();
        Double limitPrice = this.sdasd(targetTimeslot, neededMWh, currentTimeslotIndex);
        Order order = new Order(this.a.getBroker(), targetTimeslot, neededMWh, limitPrice);
        resultingOrders.add(order);
        return resultingOrders;
    }

    private List<Order> lsd8f(int currentTimeslotIndex, List<Order> nonAdjustedOrders) {
        List<Object> resultingOrders = new ArrayList();
        if (nonAdjustedOrders == null || resultingOrders == null) {
            resultingOrders = nonAdjustedOrders;
        }
        resultingOrders.clear();
        for (Order o : nonAdjustedOrders) {
            Double limitPrice = o.getLimitPrice();
            if (limitPrice != null) {
                limitPrice = limitPrice - this.d.g9a();
            }
            resultingOrders.add(new Order(this.a.getBroker(), o.getTimeslotIndex(), (double)o.getMWh(), limitPrice));
        }
        return resultingOrders;
    }

    private void ls8hws(int targetTimeslot, List<Order> orders) {
        for (Order o : orders) {
            this.nn.put(targetTimeslot, o);
            this.a.sendMessage(o);
        }
    }

    private Double sdasd(int timeslot, double neededMwh, int currentTimeslotIndex) {
        int current = currentTimeslotIndex;
        int remainingTries = timeslot - current - Competition.currentCompetition().getDeactivateTimeslotsAhead();
        boolean isBuying = neededMwh > 0.0;
        SortedSet<OrderbookOrder> outstandingOrders = this.lsdf8(timeslot, isBuying);
        double upperlimit = outstandingOrders != null ? this.sldq2(neededMwh, outstandingOrders) : this.ls83sa(isBuying);
        return this.sdf8a334d(timeslot, neededMwh, upperlimit, currentTimeslotIndex);
    }

    private SortedSet<OrderbookOrder> lsdf8(int timeslot, boolean isBuying) {
        Orderbook o = this.ss.get(timeslot);
        if (o == null) {
            return null;
        }
        return isBuying ? o.getAsks() : o.getBids();
    }

    boolean sdll3(int currentTimeslotIndex, List<Timeslot> enabledTimeslots) {
        int largeEnoughSample = this.d.bb.f();
        if (this.vv.size() < enabledTimeslots.size()) {
            return false;
        }
        if (this.xx.size() < largeEnoughSample) {
            return false;
        }
        int nextTradeCreationTimeslot = currentTimeslotIndex + 1;
        for (Timeslot timeslot : enabledTimeslots) {
            int index = this.ld8(nextTradeCreationTimeslot, timeslot.getSerialNumber());
            if (this.vv.get(index).size() >= largeEnoughSample) continue;
            return false;
        }
        return true;
    }

    private List<Order> asd7a3(int targetTimeslot, double neededMwh, int currentTimeslotIndex) {
        AS3e result = this.sdsd87(targetTimeslot, neededMwh, currentTimeslotIndex);
        double lowerLimit = result.ls835();
        double upperLimit = result.js8a5();
        return this.d8sa4(targetTimeslot, neededMwh, lowerLimit, upperLimit);
    }

    AS3e sdsd87(int targetTimeslot, double neededMwh, int currentTimeslot) {
        boolean isBuying;
        boolean bl = isBuying = neededMwh > 0.0;
        if (!isBuying) {
            // empty if block
        }
        ArrayList<Double> stateValues = new ArrayList<Double>();
        ArrayList<Double> bestActions = new ArrayList<Double>();
        SortedSet<OrderbookOrder> outstandingOrders = this.lsdf8(targetTimeslot, isBuying);
        double lowestAskPrice = outstandingOrders != null ? this.lsda52(outstandingOrders) : 0.0;
        double valueOfStep0 = this.sd83(this.xx);
        stateValues.add(valueOfStep0);
        bestActions.add(null);
        int currentMDPState = targetTimeslot - currentTimeslot;
        for (int index = 1; index <= currentMDPState; ++index) {
            ArrayList<A29.B> currentGroup = this.slld(index);
            double totalEnergyInCurrentGroup = this.sdjq238(currentGroup);
            int indexOfNextState = index - 1;
            double bestActionValue = stateValues.get(indexOfNextState);
            double bestPrice = -0.0;
            double acumulatedEnergy = 0.0;
            for (A29.B c : currentGroup) {
                double nextStateValue;
                if (c.ba() < lowestAskPrice) {
                    totalEnergyInCurrentGroup -= c.bb();
                    continue;
                }
                double Psuccess = (acumulatedEnergy += c.bb()) / totalEnergyInCurrentGroup;
                double Pfail = 1.0 - Psuccess;
                double bidPrice = -c.ba();
                double actionValue = Psuccess * bidPrice + Pfail * (nextStateValue = stateValues.get(indexOfNextState).doubleValue());
                if (!(actionValue > bestActionValue)) continue;
                bestActionValue = actionValue;
                bestPrice = bidPrice;
            }
            stateValues.add(bestActionValue);
            bestActions.add(bestPrice);
        }
        return new AS3e(currentMDPState, bestActions, stateValues);
    }

    private List<Order> s58(int targetTimeslot, double neededMwh, int currentTimeslotIndex) {
        if (!this.ww.asdf8a3(currentTimeslotIndex)) {
            this.aslsda3(neededMwh, currentTimeslotIndex);
        }
        int tradeCreationTimeslot = currentTimeslotIndex + 1;
        int bidGroupIndex = this.ld8(tradeCreationTimeslot, targetTimeslot);
        int numStairs = this.d.k2();
        if (numStairs == 24) {
            try {
                return this.sl58q(targetTimeslot, neededMwh, bidGroupIndex);
            }
            catch (Exception e) {
                return this.s8dafa35(targetTimeslot, neededMwh, bidGroupIndex);
            }
        }
        if (numStairs == 2) {
            return this.s8dafa35(targetTimeslot, neededMwh, bidGroupIndex);
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        double lowerLimit = this.ww.ls38(bidGroupIndex);
        orders.add(new Order(this.a.getBroker(), targetTimeslot, neededMwh, (Double)lowerLimit));
        return orders;
    }

    private List<Order> sl58q(int targetTimeslot, double neededMwh, int bidGroupIndex) {
        ArrayList<Double> limits = new ArrayList<Double>();
        limits.add(this.ww.ls38(bidGroupIndex));
        for (int i = bidGroupIndex - 1; i >= 0; --i) {
            limits.add(this.ww.sldf8a2().get(i));
        }
        return this.lsad85(targetTimeslot, neededMwh, limits);
    }

    private List<Order> s8dafa35(int targetTimeslot, double neededMwh, int bidGroupIndex) {
        double lowerLimit = this.ww.ls38(bidGroupIndex);
        double upperLimit = this.ww.sldf8a2().get(bidGroupIndex - 1);
        return this.d8sa4(targetTimeslot, neededMwh, lowerLimit, upperLimit);
    }

    private List<Order> lsad85(int targetTimeslot, double neededMwh, List<Double> limits) {
        int i;
        ArrayList<Order> orders = new ArrayList<Order>();
        double mwhLeft = neededMwh;
        for (i = 0; mwhLeft > 0.0 && i < limits.size() - 1; mwhLeft -= this.jj, ++i) {
            double limit = limits.get(i);
            orders.add(new Order(this.a.getBroker(), targetTimeslot, this.jj, (Double)limit));
        }
        double upperLimit = limits.get(i);
        if (mwhLeft >= this.jj) {
            orders.add(new Order(this.a.getBroker(), targetTimeslot, mwhLeft, (Double)upperLimit));
        }
        return orders;
    }

    private List<Order> d8sa4(int targetTimeslot, double neededMwh, double lowerLimit, double upperLimit) {
        ArrayList<Order> orders = new ArrayList<Order>();
        double mwhForUpperLimit = Math.max(neededMwh - this.jj, this.jj);
        double mwhForLowerLimit = this.jj;
        orders.add(new Order(this.a.getBroker(), targetTimeslot, mwhForUpperLimit, (Double)upperLimit));
        orders.add(new Order(this.a.getBroker(), targetTimeslot, mwhForLowerLimit, (Double)lowerLimit));
        return orders;
    }

    void aslsda3(double neededMwh, int currentTimeslot) {
        boolean isBuying;
        this.ww.clear();
        boolean bl = isBuying = neededMwh > 0.0;
        if (!isBuying) {
            // empty if block
        }
        ArrayList<Double> stateValues = this.ww.sldf8a2();
        ArrayList<Double> bestActions = this.ww.sd8aas();
        double valueOfStep0 = this.sd83(this.xx);
        stateValues.add(valueOfStep0);
        bestActions.add(null);
        for (int index = 1; index <= this.vv.size(); ++index) {
            ArrayList<A29.B> currentGroup = this.slld(index);
            double totalEnergyInCurrentGroup = this.sdjq238(currentGroup);
            int targetTimeslot = currentTimeslot + index;
            SortedSet<OrderbookOrder> outstandingOrders = this.lsdf8(targetTimeslot, isBuying);
            double lowestAskPrice = outstandingOrders != null ? this.lsda52(outstandingOrders) : 0.0;
            double bestActionValue = stateValues.get(stateValues.size() - 1);
            double bestPrice = -0.0;
            double acumulatedEnergy = 0.0;
            for (A29.B c : currentGroup) {
                double nextStateValue;
                if (c.ba() < lowestAskPrice) {
                    totalEnergyInCurrentGroup -= c.bb();
                    continue;
                }
                double Psuccess = (acumulatedEnergy += c.bb()) / totalEnergyInCurrentGroup;
                double Pfail = 1.0 - Psuccess;
                double bidPrice = -c.ba();
                double actionValue = Psuccess * bidPrice + Pfail * (nextStateValue = stateValues.get(stateValues.size() - 1).doubleValue());
                if (!(actionValue > bestActionValue)) continue;
                bestActionValue = actionValue;
                bestPrice = bidPrice;
            }
            stateValues.add(bestActionValue);
            bestActions.add(bestPrice);
        }
        this.ww.ls8(currentTimeslot);
    }

    private double lsda52(SortedSet<OrderbookOrder> outstandingOrders) {
        if (null == outstandingOrders) {
            return 0.0;
        }
        double lowestAsk = Double.MAX_VALUE;
        for (OrderbookOrder ask : outstandingOrders) {
            if (ask == null) continue;
            lowestAsk = Math.min(lowestAsk, ask.getLimitPrice());
        }
        return lowestAsk < Double.MAX_VALUE ? lowestAsk : 0.0;
    }

    private double sdjq238(ArrayList<A29.B> currentGroup) {
        double totalEnergyInCurrentGroup = 0.0;
        for (A29.B c : currentGroup) {
            totalEnergyInCurrentGroup += c.bb();
        }
        return totalEnergyInCurrentGroup;
    }

    double sd83(ArrayList<Ch> balancingTxData) {
        int N = balancingTxData.size();
        if (N == 0) {
            return 0.0;
        }
        double totalMwh = 0.0;
        double totalCharge = 0.0;
        for (Ch c : balancingTxData) {
            totalCharge += c.ls3s();
            totalMwh += c.sl3();
        }
        if (0.0 == totalMwh) {
            return 0.0;
        }
        return totalCharge / totalMwh;
    }

    double asd8q235(ArrayList<A29.B> supportingBidsGroup) {
        int N = supportingBidsGroup.size();
        if (N == 0) {
            return this.g;
        }
        double total = 0.0;
        for (A29.B c : supportingBidsGroup) {
            total += c.ba();
        }
        return total / (double)N;
    }

    private Double sdf8a334d(int timeslot, double neededMwh, double upperlimit, int currentTimeslotIndex) {
        int remainingTries;
        Double tmp;
        double minPrice;
        double maxPrice;
        if (neededMwh > 0.0) {
            maxPrice = this.f;
            minPrice = this.g;
        } else {
            maxPrice = this.h;
            minPrice = this.ii;
        }
        Order lastTry = this.nn.get(timeslot);
        if (lastTry != null && Math.signum(neededMwh) == Math.signum(lastTry.getMWh()) && (tmp = lastTry.getLimitPrice()) != null) {
            maxPrice = tmp;
        }
        if ((remainingTries = timeslot - currentTimeslotIndex - Competition.currentCompetition().getDeactivateTimeslotsAhead()) > 0) {
            double range = (minPrice - maxPrice) * 2.0 / (double)remainingTries;
            double computedPrice = maxPrice + this.e.nextDouble() * range;
            return Math.min(Math.max(minPrice, computedPrice), upperlimit);
        }
        return null;
    }

    private double ls83sa(boolean isBuying) {
        double tradeBasedLimit;
        double globalLimit = isBuying ? this.f : this.h;
        double d = tradeBasedLimit = isBuying ? -Math.abs(this.uu) : Math.abs(this.tt);
        if (this.asldr8faw3(tradeBasedLimit, isBuying)) {
            return tradeBasedLimit;
        }
        return globalLimit;
    }

    private boolean asldr8faw3(double tradeBasedLimit, boolean isBuying) {
        if (isBuying) {
            return this.g < tradeBasedLimit && tradeBasedLimit < this.f;
        }
        return this.ii < tradeBasedLimit && tradeBasedLimit < this.h;
    }

    private double sldq2(double neededMwh, SortedSet<OrderbookOrder> outstandingOrders) {
        double totalMwh = 0.0;
        double bestPossiblePrice = -1.7976931348623157E308;
        for (OrderbookOrder order : outstandingOrders) {
            if (null == order) continue;
            totalMwh += -order.getMWh();
            bestPossiblePrice = Math.max(bestPossiblePrice, order.getLimitPrice());
            if (!(Math.abs(totalMwh) > Math.abs(neededMwh))) continue;
            break;
        }
        double limitPrice = -bestPossiblePrice - 1.0E-5 * Math.abs(bestPossiblePrice);
        return limitPrice;
    }

    private void lsd8383(List<Timeslot> enabledTimeslots) {
        Iterator<Map.Entry<Integer, Orderbook>> it = this.ss.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Orderbook> entry = it.next();
            Integer timeslot = entry.getKey();
            if (this.l23r8s(enabledTimeslots, timeslot)) continue;
            it.remove();
        }
    }

    boolean l23r8s(List<Timeslot> enabledTimeslots, int timeslotIndex) {
        for (Timeslot t : enabledTimeslots) {
            if (t.getSerialNumber() != timeslotIndex) continue;
            return true;
        }
        return false;
    }

    class AS3e {
        private int ls8a;
        private ArrayList<Double> sld83;
        private ArrayList<Double> s348;

        public AS3e(int currentMDPState, ArrayList<Double> bestActions, ArrayList<Double> stateValues) {
            this.ls8a = currentMDPState;
            this.sld83 = bestActions;
            this.s348 = stateValues;
        }

        double sd8q() {
            double bestAction = this.sld83.get(this.ls8a);
            return bestAction;
        }

        double ls835() {
            return this.sd8q() - M1.this.kk;
        }

        double js8a5() {
            return this.s348.get(this.ls8a - 1);
        }

        ArrayList<Double> s853() {
            return this.s348;
        }

        ArrayList<Double> asdf8i3() {
            return this.sld83;
        }
    }

    class DL {
        private HashMap<Integer, Boolean> sd8a5 = new HashMap();
        private ArrayList<Double> ljs = new ArrayList();
        private ArrayList<Double> sadlf3 = new ArrayList();

        public void clear() {
            this.sd8a5.clear();
            this.ljs.clear();
            this.sadlf3.clear();
        }

        public boolean asdf8a3(int timeslot) {
            return this.sletg8(timeslot);
        }

        public void ls8(int timeslot) {
            this.sd8a5.put(timeslot, true);
        }

        public Double s38(int bidGroupIndex) {
            return this.sd8aas().get(bidGroupIndex);
        }

        public double ls38(int bidGroupIndex) {
            return this.s38(bidGroupIndex) - M1.this.kk;
        }

        public ArrayList<Double> sd8aas() {
            return this.sadlf3;
        }

        public ArrayList<Double> sldf8a2() {
            return this.ljs;
        }

        private boolean sletg8(int timeslot) {
            Boolean valid = this.sd8a5.get(timeslot);
            if (null == valid) {
                valid = false;
                this.sd8a5.put(timeslot, valid);
            }
            return valid;
        }
    }

    public class Ch {
        double sldr83;
        double ls83;

        public Ch(double charge, double mwh) {
            this.sldr83 = charge;
            this.ls83 = mwh;
        }

        public double ls3s() {
            return this.sldr83;
        }

        public double sl3() {
            return this.ls83;
        }
    }
}

