/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.powertac.samplebroker.core.PowerTacBroker;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BrokerRunner {
    private AbstractApplicationContext context;
    private PowerTacBroker broker;

    public void processCmdLine(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> jmsUrlOption = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<File> configOption = parser.accepts("config").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Integer> repeatCountOption = parser.accepts("repeat-count").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<Integer> repeatHoursOption = parser.accepts("repeat-hours").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> queueNameOption = parser.accepts("queue-name").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> serverQueueOption = parser.accepts("server-queue").withRequiredArg().ofType(String.class);
        parser.accepts("no-ntp");
        OptionSet options = parser.parse(args);
        File configFile = null;
        String jmsUrl = null;
        boolean noNtp = false;
        String queueName = null;
        String serverQueue = null;
        Integer repeatCount = 1;
        long end = 0L;
        try {
            System.out.println("Options: ");
            if (options.has(configOption)) {
                configFile = options.valueOf(configOption);
                System.out.println("  config=" + configFile.getName());
            }
            if (options.has(jmsUrlOption)) {
                jmsUrl = options.valueOf(jmsUrlOption);
                System.out.println("  jms-url=" + jmsUrl);
            }
            if (options.has("no-ntp")) {
                noNtp = true;
                System.out.println("  no ntp - estimate offset");
            }
            if (options.has(repeatCountOption)) {
                repeatCount = options.valueOf(repeatCountOption);
                System.out.println("  repeat " + repeatCount + " times");
            } else if (options.has(repeatHoursOption)) {
                Integer repeatHours = options.valueOf(repeatCountOption);
                System.out.println("  repeat for " + repeatHours + " hours");
                long now = new Date().getTime();
                end = now + (long)(3600000 * repeatHours);
            }
            if (options.has(queueNameOption)) {
                queueName = options.valueOf(queueNameOption);
                System.out.println("  queue-name=" + queueName);
            }
            if (options.has(serverQueueOption)) {
                serverQueue = options.valueOf(serverQueueOption);
                System.out.println("  server-queue=" + serverQueue);
            }
            int counter = 0;
            while (null != repeatCount && repeatCount > 0 || new Date().getTime() < end) {
                this.reopenLogs(++counter);
                if (null == this.context) {
                    this.context = new ClassPathXmlApplicationContext("broker.xml");
                } else {
                    this.context.close();
                    this.context.refresh();
                }
                this.context.registerShutdownHook();
                this.broker = (PowerTacBroker)this.context.getBeansOfType(PowerTacBroker.class).values().toArray()[0];
                System.out.println("Starting session " + counter);
                this.broker.startSession(configFile, jmsUrl, noNtp, queueName, serverQueue, end);
                if (null == repeatCount) continue;
                repeatCount = repeatCount - 1;
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    private void reopenLogs(int counter) {
        Logger root = Logger.getRootLogger();
        Enumeration rootAppenders = root.getAllAppenders();
        FileAppender logOutput = (FileAppender)rootAppenders.nextElement();
        logOutput.setFile("log/broker" + counter + ".trace");
        logOutput.activateOptions();
        Logger state = Logger.getLogger("State");
        Enumeration stateAppenders = state.getAllAppenders();
        FileAppender stateOutput = (FileAppender)stateAppenders.nextElement();
        stateOutput.setFile("log/broker" + counter + ".state");
        stateOutput.activateOptions();
    }
}

