/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Service
public class BrokerTournamentService {
    private static Logger log = Logger.getLogger(BrokerTournamentService.class);
    @Autowired
    private BrokerPropertiesService brokerPropertiesService;
    private String jmsUrl = null;
    private String brokerQueueName = null;
    private String serverQueueName = null;
    private String authToken = null;
    private String tourneyName = null;
    @ConfigurableValue(valueType="String", description="Response type to receive from the TS xml or json")
    private String responseType = "xml";
    @ConfigurableValue(valueType="Integer", description="Maximum number of tries to connect to Tournament Scheduler")
    private int maxTry = 50;

    public void init() {
        this.brokerPropertiesService.configureMe(this);
    }

    public String getResponseType() {
        return this.responseType;
    }

    public int getMaxTry() {
        return this.maxTry;
    }

    public String getJmsUrl() {
        return this.jmsUrl;
    }

    public String getServerQueueName() {
        return this.serverQueueName;
    }

    public String getBrokerQueueName() {
        return this.brokerQueueName;
    }

    private void spin(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean loginMaybe(String tsUrl) {
        try {
            String restAuthToken = "authToken=" + this.authToken;
            String restTourneyName = "requestJoin=" + this.tourneyName;
            String restResponseType = "type=" + this.responseType;
            String finalUrl = tsUrl + "?" + restAuthToken + "&" + restTourneyName + "&" + restResponseType;
            log.info("Connecting to TS with " + finalUrl);
            log.info("Tournament : " + this.tourneyName);
            URL url = new URL(finalUrl);
            URLConnection conn = url.openConnection();
            InputStream input = conn.getInputStream();
            if (this.responseType.compareTo("xml") == 0) {
                System.out.println("Parsing message..");
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(input);
                doc.getDocumentElement().normalize();
                System.out.println("login response: " + doc.toString());
                Node retryNode = doc.getElementsByTagName("retry").item(0);
                Node loginNode = doc.getElementsByTagName("login").item(0);
                Node doneNode = doc.getElementsByTagName("done").item(0);
                if (retryNode != null) {
                    String checkRetry = retryNode.getFirstChild().getNodeValue();
                    log.info("Retry message received for : " + checkRetry + " seconds");
                    System.out.println("Retry message received for : " + checkRetry + " seconds");
                    this.spin(Integer.parseInt(checkRetry));
                    return false;
                }
                if (loginNode != null) {
                    String checkServerQueue;
                    String checkBrokerQueue;
                    String checkJmsUrl;
                    System.out.println("Login response received!");
                    log.info("Login response received! ");
                    this.jmsUrl = checkJmsUrl = doc.getElementsByTagName("jmsUrl").item(0).getFirstChild().getNodeValue();
                    log.info("jmsUrl=" + checkJmsUrl);
                    this.brokerQueueName = checkBrokerQueue = doc.getElementsByTagName("queueName").item(0).getFirstChild().getNodeValue();
                    log.info("brokerQueueName=" + checkBrokerQueue);
                    this.serverQueueName = checkServerQueue = doc.getElementsByTagName("serverQueue").item(0).getFirstChild().getNodeValue();
                    log.info("serverQueueName=" + checkServerQueue);
                    System.out.printf("Login message receieved!\n  jmsUrl=%s\n  queueName=%s\n  serverQueue=%s\n", checkJmsUrl, checkBrokerQueue, checkServerQueue);
                    return true;
                }
                if (doneNode != null) {
                    System.out.println("Recieved Done Message no more games!");
                    this.maxTry = 0;
                    return false;
                }
                log.fatal("Invalid message type recieved");
                return false;
            }
            String jsonTxt = IOUtils.toString(input);
            JSONObject json = (JSONObject)JSONSerializer.toJSON(jsonTxt);
            int retry = json.getInt("retry");
            System.out.println("Retry message received for : " + retry + " seconds");
            this.spin(retry);
            return false;
        }
        catch (Exception e) {
            --this.maxTry;
            System.out.println("Retries left: " + this.maxTry);
            log.fatal("Error making connection to Tournament Scheduler");
            log.fatal(e.getMessage());
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e1) {
                return false;
            }
            return false;
        }
    }

    public boolean login(String tournamentName, String tsUrl, String authToken, long quittingTime) {
        this.tourneyName = tournamentName;
        this.authToken = authToken;
        if (this.authToken != null && tsUrl != null) {
            while (this.maxTry > 0 && (quittingTime == 0L || new Date().getTime() < quittingTime)) {
                System.out.println("Connecting to TS at " + tsUrl);
                System.out.println("Tournament : " + this.tourneyName);
                if (!this.loginMaybe(tsUrl)) continue;
                log.info("Login Successful!");
                return true;
            }
            System.out.println("Max attempts reached...shutting down");
            log.fatal("Max attempts to log in reached");
            System.exit(0);
        } else {
            log.fatal("Incorrect Tournament Scheduler URL or Broker Auth Token");
            System.exit(0);
        }
        return false;
    }
}

