/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class JmsManagementService {
    private static Logger log = Logger.getLogger(JmsManagementService.class);
    @Resource(name="jmsFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private Executor taskExecutor;
    @Autowired
    private BrokerPropertiesService brokerPropertiesService;
    private String serverQueueName = "serverInput";
    private String jmsBrokerUrl = "tcp://localhost:61616";
    Connection connection;
    boolean connectionOpen = false;
    DefaultMessageListenerContainer container;
    Session session;
    private Map<MessageListener, AbstractMessageListenerContainer> listenerContainerMap = new HashMap<MessageListener, AbstractMessageListenerContainer>();

    public void init(String overridenBrokerUrl, String serverQueueName) {
        CachingConnectionFactory cachingConnectionFactory;
        this.brokerPropertiesService.configureMe(this);
        this.serverQueueName = serverQueueName;
        if (overridenBrokerUrl != null && !overridenBrokerUrl.isEmpty()) {
            this.setJmsBrokerUrl(overridenBrokerUrl);
        }
        ActiveMQConnectionFactory amqConnectionFactory = null;
        if (this.connectionFactory instanceof PooledConnectionFactory) {
            PooledConnectionFactory pooledConnectionFactory = (PooledConnectionFactory)this.connectionFactory;
            if (pooledConnectionFactory.getConnectionFactory() instanceof ActiveMQConnectionFactory) {
                amqConnectionFactory = (ActiveMQConnectionFactory)pooledConnectionFactory.getConnectionFactory();
            }
        } else if (this.connectionFactory instanceof CachingConnectionFactory && (cachingConnectionFactory = (CachingConnectionFactory)this.connectionFactory).getTargetConnectionFactory() instanceof ActiveMQConnectionFactory) {
            amqConnectionFactory = (ActiveMQConnectionFactory)cachingConnectionFactory.getTargetConnectionFactory();
        }
        if (amqConnectionFactory != null) {
            amqConnectionFactory.setBrokerURL(this.getJmsBrokerUrl());
        }
    }

    public void registerMessageListener(MessageListener listener, String destinationName) {
        this.container = new DefaultMessageListenerContainer();
        this.container.setConnectionFactory(this.connectionFactory);
        this.container.setDestinationName(destinationName);
        this.container.setMessageListener(listener);
        this.container.setTaskExecutor(this.taskExecutor);
        this.container.afterPropertiesSet();
        this.container.start();
        this.listenerContainerMap.put(listener, this.container);
    }

    public synchronized void shutdown() {
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                JmsManagementService.this.closeConnection();
            }
        };
        this.container.stop(callback);
        while (this.connectionOpen) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void closeConnection() {
        this.connectionOpen = false;
        this.notifyAll();
    }

    public String getServerQueueName() {
        return this.serverQueueName;
    }

    public void setServerQueueName(String serverQueueName) {
        this.serverQueueName = serverQueueName;
    }

    public String getJmsBrokerUrl() {
        return this.jmsBrokerUrl;
    }

    @ConfigurableValue(valueType="String", description="JMS broker URL to use")
    public void setJmsBrokerUrl(String jmsBrokerUrl) {
        this.jmsBrokerUrl = jmsBrokerUrl;
    }
}

