/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.jndi.support.SimpleJndiBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAnnotationBeanPostProcessor
extends InitDestroyAnnotationBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
Serializable {
    private static Class<? extends Annotation> webServiceRefClass;
    private static Class<? extends Annotation> ejbRefClass;
    private final Set<String> ignoredResourceTypes = new HashSet<String>(1);
    private boolean fallbackToDefaultTypeMatch = true;
    private boolean alwaysUseJndiLookup = false;
    private transient BeanFactory jndiFactory = new SimpleJndiBeanFactory();
    private transient BeanFactory resourceFactory;
    private transient BeanFactory beanFactory;
    private final transient Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();

    static {
        Class<?> clazz;
        webServiceRefClass = null;
        ejbRefClass = null;
        ClassLoader cl = CommonAnnotationBeanPostProcessor.class.getClassLoader();
        try {
            clazz = cl.loadClass("javax.xml.ws.WebServiceRef");
            webServiceRefClass = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            webServiceRefClass = null;
        }
        try {
            clazz = cl.loadClass("javax.ejb.EJB");
            ejbRefClass = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ejbRefClass = null;
        }
    }

    public CommonAnnotationBeanPostProcessor() {
        this.setOrder(0x7FFFFFFC);
        this.setInitAnnotationType(PostConstruct.class);
        this.setDestroyAnnotationType(PreDestroy.class);
        this.ignoreResourceType("javax.xml.ws.WebServiceContext");
    }

    public void ignoreResourceType(String resourceType) {
        Assert.notNull(resourceType, "Ignored resource type must not be null");
        this.ignoredResourceTypes.add(resourceType);
    }

    public void setFallbackToDefaultTypeMatch(boolean fallbackToDefaultTypeMatch) {
        this.fallbackToDefaultTypeMatch = fallbackToDefaultTypeMatch;
    }

    public void setAlwaysUseJndiLookup(boolean alwaysUseJndiLookup) {
        this.alwaysUseJndiLookup = alwaysUseJndiLookup;
    }

    public void setJndiFactory(BeanFactory jndiFactory) {
        Assert.notNull(jndiFactory, "BeanFactory must not be null");
        this.jndiFactory = jndiFactory;
    }

    public void setResourceFactory(BeanFactory resourceFactory) {
        Assert.notNull(resourceFactory, "BeanFactory must not be null");
        this.resourceFactory = resourceFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
        if (this.resourceFactory == null) {
            this.resourceFactory = beanFactory;
        }
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        super.postProcessMergedBeanDefinition(beanDefinition, beanType, beanName);
        if (beanType != null) {
            InjectionMetadata metadata = this.findResourceMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    @Override
    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findResourceMetadata(Class<?> clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
                    Class<?> targetClass = clazz;
                    do {
                        LinkedList<LookupElement> currElements = new LinkedList<LookupElement>();
                        AccessibleObject[] accessibleObjectArray = targetClass.getDeclaredFields();
                        int n = accessibleObjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field field = accessibleObjectArray[n2];
                            if (webServiceRefClass != null && field.isAnnotationPresent(webServiceRefClass)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("@WebServiceRef annotation is not supported on static fields");
                                }
                                currElements.add(new WebServiceRefElement(field, null));
                            } else if (ejbRefClass != null && field.isAnnotationPresent(ejbRefClass)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("@EJB annotation is not supported on static fields");
                                }
                                currElements.add(new EjbRefElement(field, null));
                            } else if (field.isAnnotationPresent(Resource.class)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("@Resource annotation is not supported on static fields");
                                }
                                if (!this.ignoredResourceTypes.contains(field.getType().getName())) {
                                    currElements.add(new ResourceElement(field, null));
                                }
                            }
                            ++n2;
                        }
                        accessibleObjectArray = targetClass.getDeclaredMethods();
                        n = accessibleObjectArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            Method mostSpecificMethod;
                            AccessibleObject method = accessibleObjectArray[n2];
                            if (((Method)(method = BridgeMethodResolver.findBridgedMethod((Method)method))).equals(mostSpecificMethod = BridgeMethodResolver.findBridgedMethod(ClassUtils.getMostSpecificMethod((Method)method, clazz)))) {
                                PropertyDescriptor pd;
                                if (webServiceRefClass != null && method.isAnnotationPresent(webServiceRefClass)) {
                                    if (Modifier.isStatic(((Method)method).getModifiers())) {
                                        throw new IllegalStateException("@WebServiceRef annotation is not supported on static methods");
                                    }
                                    if (((Method)method).getParameterTypes().length != 1) {
                                        throw new IllegalStateException("@WebServiceRef annotation requires a single-arg method: " + method);
                                    }
                                    pd = BeanUtils.findPropertyForMethod((Method)method);
                                    currElements.add(new WebServiceRefElement((Member)((Object)method), pd));
                                } else if (ejbRefClass != null && method.isAnnotationPresent(ejbRefClass)) {
                                    if (Modifier.isStatic(((Method)method).getModifiers())) {
                                        throw new IllegalStateException("@EJB annotation is not supported on static methods");
                                    }
                                    if (((Method)method).getParameterTypes().length != 1) {
                                        throw new IllegalStateException("@EJB annotation requires a single-arg method: " + method);
                                    }
                                    pd = BeanUtils.findPropertyForMethod((Method)method);
                                    currElements.add(new EjbRefElement((Member)((Object)method), pd));
                                } else if (method.isAnnotationPresent(Resource.class)) {
                                    if (Modifier.isStatic(((Method)method).getModifiers())) {
                                        throw new IllegalStateException("@Resource annotation is not supported on static methods");
                                    }
                                    Class<?>[] paramTypes = ((Method)method).getParameterTypes();
                                    if (paramTypes.length != 1) {
                                        throw new IllegalStateException("@Resource annotation requires a single-arg method: " + method);
                                    }
                                    if (!this.ignoredResourceTypes.contains(paramTypes[0].getName())) {
                                        PropertyDescriptor pd2 = BeanUtils.findPropertyForMethod((Method)method);
                                        currElements.add(new ResourceElement((Member)((Object)method), pd2));
                                    }
                                }
                            }
                            ++n2;
                        }
                        elements.addAll(0, currElements);
                    } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
                    metadata = new InjectionMetadata(clazz, elements);
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected Object getResource(LookupElement element, String requestingBeanName) throws BeansException {
        if (StringUtils.hasLength(element.mappedName)) {
            return this.jndiFactory.getBean(element.mappedName, element.lookupType);
        }
        if (this.alwaysUseJndiLookup) {
            return this.jndiFactory.getBean(element.name, element.lookupType);
        }
        if (this.resourceFactory == null) {
            throw new NoSuchBeanDefinitionException(element.lookupType, "No resource factory configured - specify the 'resourceFactory' property");
        }
        return this.autowireResource(this.resourceFactory, element, requestingBeanName);
    }

    protected Object autowireResource(BeanFactory factory, LookupElement element, String requestingBeanName) throws BeansException {
        Object resource;
        Set<String> autowiredBeanNames;
        String name = element.name;
        if (this.fallbackToDefaultTypeMatch && element.isDefaultName && factory instanceof AutowireCapableBeanFactory && !factory.containsBean(name)) {
            autowiredBeanNames = new LinkedHashSet<String>();
            resource = ((AutowireCapableBeanFactory)factory).resolveDependency(element.getDependencyDescriptor(), requestingBeanName, autowiredBeanNames, null);
        } else {
            resource = factory.getBean(name, element.lookupType);
            autowiredBeanNames = Collections.singleton(name);
        }
        if (factory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory beanFactory = (ConfigurableBeanFactory)factory;
            for (String autowiredBeanName : autowiredBeanNames) {
                beanFactory.registerDependentBean(autowiredBeanName, requestingBeanName);
            }
        }
        return resource;
    }

    private class EjbRefElement
    extends LookupElement {
        private String beanName;

        public EjbRefElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
        }

        protected void initAnnotation(AnnotatedElement ae) {
            Class resourceType;
            EJB resource = ae.getAnnotation(EJB.class);
            String resourceBeanName = resource.beanName();
            String resourceName = resource.name();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            }
            if ((resourceType = resource.beanInterface()) != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.beanName = resourceBeanName;
            this.name = resourceName;
            this.lookupType = resourceType;
            this.mappedName = resource.mappedName();
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            if (StringUtils.hasLength(this.beanName)) {
                if (CommonAnnotationBeanPostProcessor.this.beanFactory != null && CommonAnnotationBeanPostProcessor.this.beanFactory.containsBean(this.beanName)) {
                    Object bean = CommonAnnotationBeanPostProcessor.this.beanFactory.getBean(this.beanName, this.lookupType);
                    if (CommonAnnotationBeanPostProcessor.this.beanFactory instanceof ConfigurableBeanFactory) {
                        ((ConfigurableBeanFactory)CommonAnnotationBeanPostProcessor.this.beanFactory).registerDependentBean(this.beanName, requestingBeanName);
                    }
                    return bean;
                }
                if (this.isDefaultName && !StringUtils.hasLength(this.mappedName)) {
                    throw new NoSuchBeanDefinitionException(this.beanName, "Cannot resolve 'beanName' in local BeanFactory. Consider specifying a general 'name' value instead.");
                }
            }
            return CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupDependencyDescriptor
    extends DependencyDescriptor {
        private final Class<?> lookupType;

        public LookupDependencyDescriptor(Field field, Class<?> lookupType) {
            super(field, true);
            this.lookupType = lookupType;
        }

        public LookupDependencyDescriptor(Method method, Class<?> lookupType) {
            super(new MethodParameter(method, 0), true);
            this.lookupType = lookupType;
        }

        @Override
        public Class<?> getDependencyType() {
            return this.lookupType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class LookupElement
    extends InjectionMetadata.InjectedElement {
        protected String name;
        protected boolean isDefaultName;
        protected Class<?> lookupType;
        protected String mappedName;

        public LookupElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
            this.isDefaultName = false;
            this.initAnnotation((AnnotatedElement)((Object)member));
        }

        protected abstract void initAnnotation(AnnotatedElement var1);

        public final String getName() {
            return this.name;
        }

        public final Class<?> getLookupType() {
            return this.lookupType;
        }

        public final DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new LookupDependencyDescriptor((Field)this.member, this.lookupType);
            }
            return new LookupDependencyDescriptor((Method)this.member, this.lookupType);
        }
    }

    private class ResourceElement
    extends LookupElement {
        protected boolean shareable;

        public ResourceElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
            this.shareable = true;
        }

        protected void initAnnotation(AnnotatedElement ae) {
            Resource resource = ae.getAnnotation(Resource.class);
            String resourceName = resource.name();
            Class resourceType = resource.type();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            } else if (CommonAnnotationBeanPostProcessor.this.beanFactory instanceof ConfigurableBeanFactory) {
                resourceName = ((ConfigurableBeanFactory)CommonAnnotationBeanPostProcessor.this.beanFactory).resolveEmbeddedValue(resourceName);
            }
            if (resourceType != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName;
            this.lookupType = resourceType;
            this.mappedName = resource.mappedName();
            this.shareable = resource.shareable();
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            return CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
        }
    }

    private class WebServiceRefElement
    extends LookupElement {
        private Class<?> elementType;
        private String wsdlLocation;

        public WebServiceRefElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
        }

        protected void initAnnotation(AnnotatedElement ae) {
            WebServiceRef resource = ae.getAnnotation(WebServiceRef.class);
            String resourceName = resource.name();
            Class resourceType = resource.type();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            }
            if (resourceType != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName;
            this.elementType = resourceType;
            this.lookupType = Service.class.isAssignableFrom(resourceType) ? resourceType : (!Object.class.equals((Object)resource.value()) ? resource.value() : Service.class);
            this.mappedName = resource.mappedName();
            this.wsdlLocation = resource.wsdlLocation();
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            Service service;
            try {
                service = (Service)CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                if (Service.class.equals((Object)this.lookupType)) {
                    throw new IllegalStateException("No resource with name '" + this.name + "' found in context, " + "and no specific JAX-WS Service subclass specified. The typical solution is to either specify " + "a LocalJaxWsServiceFactoryBean with the given name or to specify the (generated) Service " + "subclass as @WebServiceRef(...) value.");
                }
                if (StringUtils.hasLength(this.wsdlLocation)) {
                    try {
                        Constructor ctor = this.lookupType.getConstructor(URL.class, QName.class);
                        WebServiceClient clientAnn = this.lookupType.getAnnotation(WebServiceClient.class);
                        if (clientAnn == null) {
                            throw new IllegalStateException("JAX-WS Service class [" + this.lookupType.getName() + "] does not carry a WebServiceClient annotation");
                        }
                        service = (Service)BeanUtils.instantiateClass(ctor, new URL(this.wsdlLocation), new QName(clientAnn.targetNamespace(), clientAnn.name()));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new IllegalStateException("JAX-WS Service class [" + this.lookupType.getName() + "] does not have a (URL, QName) constructor. Cannot apply specified WSDL location [" + this.wsdlLocation + "].");
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IllegalArgumentException("Specified WSDL location [" + this.wsdlLocation + "] isn't a valid URL");
                    }
                }
                service = (Service)BeanUtils.instantiateClass(this.lookupType);
            }
            return service.getPort(this.elementType);
        }
    }
}

