/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceSupport;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageSource
extends MessageSourceSupport
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;
    private boolean useCodeAsDefaultMessage = false;

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String fallback;
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (defaultMessage == null && (fallback = this.getDefaultMessage(code)) != null) {
            return fallback;
        }
        return this.renderDefaultMessage(defaultMessage, args, locale);
    }

    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        String fallback = this.getDefaultMessage(code);
        if (fallback != null) {
            return fallback;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String fallback;
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            codes = new String[]{};
        }
        String[] stringArray = codes;
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            String code = stringArray[n2];
            String msg = this.getMessageInternal(code, resolvable.getArguments(), locale);
            if (msg != null) {
                return msg;
            }
            ++n2;
        }
        String defaultMessage = resolvable.getDefaultMessage();
        if (defaultMessage != null) {
            return this.renderDefaultMessage(defaultMessage, resolvable.getArguments(), locale);
        }
        if (codes.length > 0 && (fallback = this.getDefaultMessage(codes[0])) != null) {
            return fallback;
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Object[] argsToUse = args;
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty(args)) {
            String message = this.resolveCodeWithoutArguments(code, locale);
            if (message != null) {
                return message;
            }
        } else {
            argsToUse = this.resolveArguments(args, locale);
            MessageFormat messageFormat = this.resolveCode(code, locale);
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(argsToUse);
                }
            }
        }
        return this.getMessageFromParent(code, argsToUse, locale);
    }

    protected String getMessageFromParent(String code, Object[] args, Locale locale) {
        MessageSource parent = this.getParentMessageSource();
        if (parent != null) {
            if (parent instanceof AbstractMessageSource) {
                return ((AbstractMessageSource)parent).getMessageInternal(code, args, locale);
            }
            return parent.getMessage(code, args, null, locale);
        }
        return null;
    }

    protected String getDefaultMessage(String code) {
        if (this.isUseCodeAsDefaultMessage()) {
            return code;
        }
        return null;
    }

    protected Object[] resolveArguments(Object[] args, Locale locale) {
        if (args == null) {
            return new Object[0];
        }
        ArrayList<Object> resolvedArgs = new ArrayList<Object>(args.length);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg instanceof MessageSourceResolvable) {
                resolvedArgs.add(this.getMessage((MessageSourceResolvable)arg, locale));
            } else {
                resolvedArgs.add(arg);
            }
            ++n2;
        }
        return resolvedArgs.toArray(new Object[resolvedArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

