/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSourceResourceBundle
extends ResourceBundle {
    private final MessageSource messageSource;
    private final Locale locale;

    public MessageSourceResourceBundle(MessageSource source, Locale locale) {
        Assert.notNull(source, "MessageSource must not be null");
        this.messageSource = source;
        this.locale = locale;
    }

    public MessageSourceResourceBundle(MessageSource source, Locale locale, ResourceBundle parent) {
        this(source, locale);
        this.setParent(parent);
    }

    @Override
    protected Object handleGetObject(String code) {
        try {
            return this.messageSource.getMessage(code, null, this.locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

