/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import org.springframework.core.env.CommandLinePropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOptCommandLinePropertySource
extends CommandLinePropertySource<OptionSet> {
    public JOptCommandLinePropertySource(OptionSet options) {
        super(options);
    }

    public JOptCommandLinePropertySource(String name, OptionSet options) {
        super(name, options);
    }

    @Override
    protected boolean containsOption(String name) {
        return ((OptionSet)this.source).has(name);
    }

    @Override
    public List<String> getOptionValues(String name) {
        List<?> argValues = ((OptionSet)this.source).valuesOf(name);
        ArrayList<String> stringArgValues = new ArrayList<String>();
        for (Object argValue : argValues) {
            if (!(argValue instanceof String)) {
                throw new IllegalArgumentException("argument values must be of type String");
            }
            stringArgValues.add((String)argValue);
        }
        if (stringArgValues.size() == 0) {
            if (((OptionSet)this.source).has(name)) {
                return Collections.emptyList();
            }
            return null;
        }
        return Collections.unmodifiableList(stringArgValues);
    }

    @Override
    protected List<String> getNonOptionArgs() {
        return ((OptionSet)this.source).nonOptionArguments();
    }
}

