/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode$State;
import AST.Annotation;
import AST.Block;
import AST.BodyDecl;
import AST.Case;
import AST.ClassDecl;
import AST.CodeGeneration;
import AST.CompilationUnit;
import AST.ConstructorDecl;
import AST.ElementValue;
import AST.EnumDecl;
import AST.Expr;
import AST.GLBType;
import AST.GenericConstructorDecl;
import AST.GenericMethodDecl;
import AST.LUBType;
import AST.LabeledStmt;
import AST.List;
import AST.MethodDecl;
import AST.NameType;
import AST.Opt;
import AST.Options;
import AST.Problem;
import AST.Program;
import AST.SimpleSet;
import AST.Stmt;
import AST.TryStmt;
import AST.TypeDecl;
import AST.Variable;
import AST.VariableScope;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import jpe.Environment;
import jpe.Util;

public class ASTNode<T extends ASTNode>
extends Symbol
implements Cloneable,
Iterable<T> {
    protected static final String PRIMITIVE_PACKAGE_NAME = "@primitive";
    public static final boolean generatedWithCircularEnabled = true;
    public static final boolean generatedWithCacheCycle = false;
    public static final boolean generatedWithComponentCheck = false;
    protected static ASTNode$State state = new ASTNode$State();
    public boolean in$Circle = false;
    public boolean is$Final = false;
    private int childIndex;
    protected int numChildren;
    protected ASTNode parent;
    protected ASTNode[] children;

    public void flushCache() {
    }

    public void flushCollectionCache() {
    }

    public ASTNode<T> clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode<T> copy() {
        try {
            Object node = this.clone();
            if (this.children != null) {
                ((ASTNode)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode<T> fullCopy() {
        ASTNode<T> res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void accessControl() {
    }

    protected void collectExceptions(Collection c, ASTNode target) {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).collectExceptions(c, target);
            ++i;
        }
    }

    public void collectBranches(Collection c) {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).collectBranches(c);
            ++i;
        }
    }

    public Stmt branchTarget(Stmt branchStmt) {
        if (this.getParent() != null) {
            return this.getParent().branchTarget(branchStmt);
        }
        return null;
    }

    public void collectFinally(Stmt branchStmt, ArrayList list) {
        if (this.getParent() != null) {
            this.getParent().collectFinally(branchStmt, list);
        }
    }

    public int varChildIndex(Block b) {
        ASTNode node = this;
        while (node.getParent().getParent() != b) {
            node = node.getParent();
        }
        return b.getStmtListNoTransform().getIndexOfChild(node);
    }

    public int varChildIndex(TypeDecl t) {
        ASTNode node = this;
        while (node != null && node.getParent() != null && node.getParent().getParent() != t) {
            node = node.getParent();
        }
        if (node == null) {
            return -1;
        }
        return t.getBodyDeclListNoTransform().getIndexOfChild(node);
    }

    public void definiteAssignment() {
    }

    protected boolean checkDUeverywhere(Variable v) {
        int i = 0;
        while (i < this.getNumChild()) {
            if (!((ASTNode)this.getChild(i)).checkDUeverywhere(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isDescendantTo(ASTNode node) {
        if (this == node) {
            return true;
        }
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().isDescendantTo(node);
    }

    protected String sourceFile() {
        ASTNode node = this;
        while (node != null && !(node instanceof CompilationUnit)) {
            node = node.getParent();
        }
        if (node == null) {
            return "Unknown file";
        }
        CompilationUnit u = (CompilationUnit)node;
        return u.relativeName();
    }

    public ASTNode setLocation(ASTNode node) {
        this.setStart(node.getStart());
        this.setEnd(node.getEnd());
        return this;
    }

    public ASTNode setStart(int i) {
        this.start = i;
        return this;
    }

    public int start() {
        return this.start;
    }

    public ASTNode setEnd(int i) {
        this.end = i;
        return this;
    }

    public int end() {
        return this.end;
    }

    public String location() {
        return "" + this.lineNumber();
    }

    public String errorPrefix() {
        return String.valueOf(this.sourceFile()) + ":" + this.location() + ":\n" + "  *** Semantic Error: ";
    }

    public String warningPrefix() {
        return String.valueOf(this.sourceFile()) + ":" + this.location() + ":\n" + "  *** WARNING: ";
    }

    public void error(String s) {
        ASTNode node = this;
        while (node != null && !(node instanceof CompilationUnit)) {
            node = node.getParent();
        }
        CompilationUnit cu = (CompilationUnit)node;
        if (this.getNumChild() == 0 && this.getStart() != 0 && this.getEnd() != 0) {
            int line = ASTNode.getLine(this.getStart());
            int column = ASTNode.getColumn(this.getStart());
            int endLine = ASTNode.getLine(this.getEnd());
            int endColumn = ASTNode.getColumn(this.getEnd());
            cu.errors.add(new Problem(this.sourceFile(), s, line, column, endLine, endColumn, Problem.Severity.ERROR, Problem.Kind.SEMANTIC));
        } else {
            cu.errors.add(new Problem(this.sourceFile(), s, this.lineNumber(), Problem.Severity.ERROR, Problem.Kind.SEMANTIC));
        }
    }

    public void warning(String s) {
        ASTNode node = this;
        while (node != null && !(node instanceof CompilationUnit)) {
            node = node.getParent();
        }
        CompilationUnit cu = (CompilationUnit)node;
        cu.warnings.add(new Problem(this.sourceFile(), "WARNING: " + s, this.lineNumber(), Problem.Severity.WARNING));
    }

    public void collectErrors() {
        this.nameCheck();
        this.typeCheck();
        this.accessControl();
        this.exceptionHandling();
        this.checkUnreachableStmt();
        this.definiteAssignment();
        this.checkModifiers();
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).collectErrors();
            ++i;
        }
    }

    public void exceptionHandling() {
    }

    protected boolean reachedException(TypeDecl type) {
        int i = 0;
        while (i < this.getNumChild()) {
            if (((ASTNode)this.getChild(i)).reachedException(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Collection removeInstanceMethods(Collection c) {
        c = new LinkedList(c);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            if (m.isStatic()) continue;
            iter.remove();
        }
        return c;
    }

    protected static void putSimpleSetElement(HashMap map, Object key, Object value) {
        SimpleSet set = (SimpleSet)map.get(key);
        if (set == null) {
            set = SimpleSet.emptySet;
        }
        map.put(key, set.add(value));
    }

    public SimpleSet removeInstanceVariables(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            Variable v = (Variable)iter.next();
            if (v.isInstanceVariable()) continue;
            newSet = newSet.add(v);
        }
        return newSet;
    }

    void checkModifiers() {
    }

    public void nameCheck() {
    }

    public TypeDecl extractSingleType(SimpleSet c) {
        if (c.size() != 1) {
            return null;
        }
        return (TypeDecl)c.iterator().next();
    }

    public Options options() {
        return this.state().options;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.toString(s);
        return s.toString().trim();
    }

    public void toString(StringBuffer s) {
        throw new Error("Operation toString(StringBuffer s) not implemented for " + this.getClass().getName());
    }

    public String dumpTree() {
        StringBuffer s = new StringBuffer();
        this.dumpTree(s, 0);
        return s.toString();
    }

    public void dumpTree(StringBuffer s, int j) {
        int i = 0;
        while (i < j) {
            s.append("  ");
            ++i;
        }
        s.append(String.valueOf(this.dumpString()) + "\n");
        i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).dumpTree(s, j + 1);
            ++i;
        }
    }

    public String dumpTreeNoRewrite() {
        StringBuffer s = new StringBuffer();
        this.dumpTreeNoRewrite(s, 0);
        return s.toString();
    }

    protected void dumpTreeNoRewrite(StringBuffer s, int indent) {
        int i = 0;
        while (i < indent) {
            s.append("  ");
            ++i;
        }
        s.append(this.dumpString());
        s.append("\n");
        i = 0;
        while (i < this.getNumChildNoTransform()) {
            ((ASTNode)this.getChildNoTransform(i)).dumpTreeNoRewrite(s, indent + 1);
            ++i;
        }
    }

    public void typeCheck() {
    }

    void checkUnreachableStmt() {
    }

    public void clearLocations() {
        this.setStart(0);
        this.setEnd(0);
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            ((ASTNode)this.getChildNoTransform(i)).clearLocations();
            ++i;
        }
    }

    public void setSourceLineNumber(int i) {
        this.setStart(ASTNode.makePosition(i, 1));
    }

    protected int findFirstSourceLineNumber() {
        if (this.getStart() != 0) {
            return ASTNode.getLine(this.getStart());
        }
        int i = 0;
        while (i < this.getNumChild()) {
            int num = ((ASTNode)this.getChild(i)).findFirstSourceLineNumber();
            if (num != -1) {
                return num;
            }
            ++i;
        }
        return -1;
    }

    public void error() {
        Throwable t = new Throwable();
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String s = ste[1].toString();
        throw new Error(String.valueOf(s) + " Cannot create bytecode for:" + this.getClass().getName());
    }

    public void createBCode(CodeGeneration gen) {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).createBCode(gen);
            ++i;
        }
    }

    public boolean clear() {
        boolean empty = true;
        int i = 0;
        while (i < this.getNumChild()) {
            T child = this.getChild(i);
            if (!((ASTNode)child).clear()) {
                empty = false;
            } else if (child instanceof List) {
                this.setChild(new List(), i);
            } else if (child instanceof Opt) {
                this.setChild(new Opt(), i);
            }
            ++i;
        }
        if (empty) {
            this.setParent(null);
        }
        if (this.flush()) {
            this.flushCache();
        }
        return empty;
    }

    public void collectEnclosingVariables(HashSet set, TypeDecl typeDecl) {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).collectEnclosingVariables(set, typeDecl);
            ++i;
        }
    }

    public void flushCaches() {
        this.flushCache();
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).flushCaches();
            ++i;
        }
    }

    public void transformation() {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).transformation();
            ++i;
        }
    }

    protected ASTNode replace(ASTNode node) {
        this.state().replacePos = node.getParent().getIndexOfChild(node);
        node.getParent().in$Circle(true);
        return node.getParent();
    }

    protected ASTNode with(ASTNode node) {
        this.setChild(node, this.state().replacePos);
        this.in$Circle(false);
        return node;
    }

    protected void transformEnumConstructors() {
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            T child = this.getChildNoTransform(i);
            if (child != null) {
                ((ASTNode)child).transformEnumConstructors();
            }
            ++i;
        }
    }

    protected void checkEnum(EnumDecl enumDecl) {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).checkEnum(enumDecl);
            ++i;
        }
    }

    public ASTNode inline() {
        int i = 0;
        while (i < this.getNumChild()) {
            T a = this.getChild(i);
            this.setChild(((ASTNode)a).inline(), i);
            ++i;
        }
        return this;
    }

    public final ASTNode$State state() {
        return state;
    }

    public boolean in$Circle() {
        return this.in$Circle;
    }

    public void in$Circle(boolean b) {
        this.in$Circle = b;
    }

    public boolean is$Final() {
        return this.is$Final;
    }

    public void is$Final(boolean b) {
        this.is$Final = b;
    }

    public T getChild(int i) {
        return (T)ASTNode.getChild(this, i);
    }

    public static ASTNode getChild(ASTNode that, int i) {
        Object node = that.getChildNoTransform(i);
        if (((ASTNode)node).is$Final()) {
            return node;
        }
        if (!((ASTNode)node).mayHaveRewrite()) {
            ((ASTNode)node).is$Final(that.is$Final());
            return node;
        }
        if (!((ASTNode)node).in$Circle()) {
            int rewriteState;
            int num = that.state().boundariesCrossed;
            do {
                that.state().push(1);
                Object oldNode = node;
                ((ASTNode)oldNode).in$Circle(true);
                node = ((ASTNode)node).rewriteTo();
                if (node != oldNode) {
                    that.setChild(node, i);
                }
                ((ASTNode)oldNode).in$Circle(false);
            } while ((rewriteState = that.state().pop()) == 1);
            if (rewriteState == 2 && that.is$Final()) {
                ((ASTNode)node).is$Final(true);
                that.state().boundariesCrossed = num;
            }
        } else if (that.is$Final() != ((ASTNode)node).is$Final()) {
            ++that.state().boundariesCrossed;
        }
        return node;
    }

    public int getIndexOfChild(ASTNode node) {
        if (node != null && node.childIndex < this.getNumChildNoTransform() && node == this.getChildNoTransform(node.childIndex)) {
            return node.childIndex;
        }
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            if (this.getChildNoTransform(i) == node) {
                node.childIndex = i;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addChild(T node) {
        this.setChild(node, this.getNumChildNoTransform());
    }

    public final T getChildNoTransform(int i) {
        return (T)this.children[i];
    }

    protected int numChildren() {
        return this.numChildren;
    }

    public int getNumChild() {
        return this.numChildren();
    }

    public final int getNumChildNoTransform() {
        return this.numChildren();
    }

    public void setChild(T node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i << 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        if (node != null) {
            ((ASTNode)node).setParent(this);
            ((ASTNode)node).childIndex = i;
        }
    }

    public void insertChild(T node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            }
            this.children = c;
        }
        ++this.numChildren;
        if (node != null) {
            ((ASTNode)node).setParent(this);
            ((ASTNode)node).childIndex = i;
        }
    }

    public void removeChild(int i) {
        if (this.children != null) {
            ASTNode child = this.children[i];
            if (child != null) {
                child.setParent(null);
                child.childIndex = -1;
            }
            System.arraycopy(this.children, i + 1, this.children, i, this.children.length - i - 1);
            --this.numChildren;
        }
    }

    public ASTNode getParent() {
        if (this.parent != null && this.parent.is$Final() != this.is$Final()) {
            ++this.state().boundariesCrossed;
        }
        return this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    protected boolean duringLookupConstructor() {
        if (this.state().duringLookupConstructor == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringBoundNames() {
        if (this.state().duringBoundNames == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringResolveAmbiguousNames() {
        if (this.state().duringResolveAmbiguousNames == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringSyntacticClassification() {
        if (this.state().duringSyntacticClassification == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringAnonymousClasses() {
        if (this.state().duringAnonymousClasses == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringVariableDeclaration() {
        if (this.state().duringVariableDeclaration == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringConstantExpression() {
        if (this.state().duringConstantExpression == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringDefiniteAssignment() {
        if (this.state().duringDefiniteAssignment == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringAnnotations() {
        if (this.state().duringAnnotations == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringEnums() {
        if (this.state().duringEnums == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    protected boolean duringGenericTypeVariables() {
        if (this.state().duringGenericTypeVariables == 0) {
            return false;
        }
        this.state().pop();
        this.state().push(3);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < ASTNode.this.getNumChild();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ASTNode.this.getChild(this.counter++);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    protected void collect_contributors_TypeDecl_subClasses() {
        int i = 0;
        while (i < this.getNumChild()) {
            ((ASTNode)this.getChild(i)).collect_contributors_TypeDecl_subClasses();
            ++i;
        }
    }

    protected void contributeTo_TypeDecl_TypeDecl_subClasses(Set<ClassDecl> collection) {
    }

    public boolean unassignedEverywhere(Variable v, TryStmt stmt) {
        ASTNode$State state = this.state();
        boolean unassignedEverywhere_Variable_TryStmt_value = this.unassignedEverywhere_compute(v, stmt);
        return unassignedEverywhere_Variable_TryStmt_value;
    }

    private boolean unassignedEverywhere_compute(Variable v, TryStmt stmt) {
        int i = 0;
        while (i < this.getNumChild()) {
            if (!((ASTNode)this.getChild(i)).unassignedEverywhere(v, stmt)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int lineNumber() {
        ASTNode$State state = this.state();
        int lineNumber_value = this.lineNumber_compute();
        return lineNumber_value;
    }

    private int lineNumber_compute() {
        ASTNode n = this;
        while (n.getParent() != null && n.getStart() == 0) {
            n = n.getParent();
        }
        return ASTNode.getLine(n.getStart());
    }

    public String indent() {
        ASTNode$State state = this.state();
        String indent_value = this.indent_compute();
        return indent_value;
    }

    private String indent_compute() {
        String indent = this.extractIndent();
        return indent.startsWith("\n") ? indent : "\n" + indent;
    }

    public String extractIndent() {
        ASTNode$State state = this.state();
        String extractIndent_value = this.extractIndent_compute();
        return extractIndent_value;
    }

    private String extractIndent_compute() {
        if (this.getParent() == null) {
            return "";
        }
        String indent = this.getParent().extractIndent();
        if (this.getParent().addsIndentationLevel()) {
            indent = String.valueOf(indent) + "  ";
        }
        return indent;
    }

    public boolean addsIndentationLevel() {
        ASTNode$State state = this.state();
        boolean addsIndentationLevel_value = this.addsIndentationLevel_compute();
        return addsIndentationLevel_value;
    }

    private boolean addsIndentationLevel_compute() {
        return false;
    }

    public String dumpString() {
        ASTNode$State state = this.state();
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return this.getClass().getName();
    }

    public int sourceLineNumber() {
        ASTNode$State state = this.state();
        int sourceLineNumber_value = this.sourceLineNumber_compute();
        return sourceLineNumber_value;
    }

    private int sourceLineNumber_compute() {
        return this.getStart() != 0 ? ASTNode.getLine(this.getStart()) : -1;
    }

    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return false;
    }

    public boolean flush() {
        ASTNode$State state = this.state();
        boolean flush_value = this.flush_compute();
        return flush_value;
    }

    private boolean flush_compute() {
        return true;
    }

    public boolean isStringAdd() {
        ASTNode$State state = this.state();
        boolean isStringAdd_value = this.isStringAdd_compute();
        return isStringAdd_value;
    }

    private boolean isStringAdd_compute() {
        return false;
    }

    public boolean usesTypeVariable() {
        ASTNode$State state = this.state();
        boolean usesTypeVariable_value = this.usesTypeVariable_compute();
        return usesTypeVariable_value;
    }

    private boolean usesTypeVariable_compute() {
        int i = 0;
        while (i < this.getNumChild()) {
            if (((ASTNode)this.getChild(i)).usesTypeVariable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Program getProgram() {
        ASTNode$State state = this.state();
        Program getProgram_value = this.getProgram_compute();
        return getProgram_value;
    }

    private Program getProgram_compute() {
        return this.getParent().getProgram();
    }

    public boolean isCompileTime(Environment env) {
        ASTNode$State state = this.state();
        boolean isCompileTime_jpe_Environment_value = this.isCompileTime_compute(env);
        return isCompileTime_jpe_Environment_value;
    }

    private boolean isCompileTime_compute(Environment env) {
        boolean b = false;
        int i = 0;
        while (i < this.getNumChild()) {
            b = ((ASTNode)this.getChild(i)).isCompileTime(env);
            if (!b) {
                return false;
            }
            ++i;
        }
        return b;
    }

    public ASTNode pe(Environment env) {
        ASTNode$State state = this.state();
        ASTNode pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private ASTNode pe_compute(Environment env) {
        ASTNode<ASTNode> ast = this.fullCopy();
        int i = 0;
        while (i < this.getNumChild()) {
            ast.setChild(((ASTNode)this.getChild(i)).fullCopy().peCatch(env), i);
            ++i;
        }
        return ast;
    }

    public ASTNode peCatch(Environment env) {
        ASTNode$State state = this.state();
        ASTNode peCatch_jpe_Environment_value = this.peCatch_compute(env);
        return peCatch_jpe_Environment_value;
    }

    private ASTNode peCatch_compute(Environment env) {
        try {
            return this.pe(env);
        }
        catch (RuntimeException e) {
            Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
            throw e;
        }
    }

    public boolean fillInMethodDeclarations() {
        ASTNode$State state = this.state();
        boolean fillInMethodDeclarations_value = this.fillInMethodDeclarations_compute();
        return fillInMethodDeclarations_value;
    }

    private boolean fillInMethodDeclarations_compute() {
        int i = 0;
        while (i < this.getNumChild()) {
            T a = this.getChild(i);
            ((ASTNode)a).fillInMethodDeclarations();
            ++i;
        }
        return true;
    }

    public boolean hasSource() {
        ASTNode$State state = this.state();
        boolean hasSource_value = this.hasSource_compute();
        return hasSource_value;
    }

    private boolean hasSource_compute() {
        return false;
    }

    public ASTNode fuse() {
        ASTNode$State state = this.state();
        ASTNode fuse_value = this.fuse_compute();
        return fuse_value;
    }

    private ASTNode fuse_compute() {
        int i = 0;
        while (i < this.getNumChild()) {
            this.setChild(((ASTNode)this.getChild(i)).fuse(), i);
            ++i;
        }
        return this;
    }

    public ASTNode spe(Environment env) {
        ASTNode$State state = this.state();
        ASTNode spe_jpe_Environment_value = this.spe_compute(env);
        return spe_jpe_Environment_value;
    }

    private ASTNode spe_compute(Environment env) {
        ASTNode<ASTNode> ast = this.fullCopy();
        int i = 0;
        while (i < this.getNumChild()) {
            ast.setChild(((ASTNode)this.getChild(i)).fullCopy().spe(env), i);
            ++i;
        }
        return ast;
    }

    public ASTNode rewriteTo() {
        if (this.state().peek() == 1) {
            this.state().pop();
            this.state().push(2);
        }
        return this;
    }

    public TypeDecl Define_TypeDecl_superType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_superType(this, caller);
    }

    public ConstructorDecl Define_ConstructorDecl_constructorDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ConstructorDecl_constructorDecl(this, caller);
    }

    public TypeDecl Define_TypeDecl_componentType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_componentType(this, caller);
    }

    public LabeledStmt Define_LabeledStmt_lookupLabel(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_LabeledStmt_lookupLabel(this, caller, name);
    }

    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    public boolean Define_boolean_isIncOrDec(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isIncOrDec(this, caller);
    }

    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    public TypeDecl Define_TypeDecl_typeException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeException(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeRuntimeException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeRuntimeException(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeError(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeError(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeNullPointerException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeNullPointerException(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeThrowable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeThrowable(this, caller);
    }

    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    public Collection Define_Collection_lookupConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Collection_lookupConstructor(this, caller);
    }

    public Collection Define_Collection_lookupSuperConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Collection_lookupSuperConstructor(this, caller);
    }

    public Expr Define_Expr_nestedScope(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Expr_nestedScope(this, caller);
    }

    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    public TypeDecl Define_TypeDecl_typeObject(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeObject(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeCloneable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeCloneable(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeSerializable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeSerializable(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeBoolean(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeBoolean(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeByte(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeByte(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeShort(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeShort(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeChar(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeChar(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeInt(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeInt(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeLong(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeLong(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeFloat(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeFloat(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeDouble(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeDouble(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeString(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeString(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeVoid(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeVoid(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeNull(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeNull(this, caller);
    }

    public TypeDecl Define_TypeDecl_unknownType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_unknownType(this, caller);
    }

    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    public TypeDecl Define_TypeDecl_lookupType(ASTNode caller, ASTNode child, String packageName, String typeName) {
        return this.getParent().Define_TypeDecl_lookupType(this, caller, packageName, typeName);
    }

    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeStatic(this, caller);
    }

    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeFinal(this, caller);
    }

    public boolean Define_boolean_mayBeAbstract(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeAbstract(this, caller);
    }

    public boolean Define_boolean_mayBeVolatile(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeVolatile(this, caller);
    }

    public boolean Define_boolean_mayBeTransient(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeTransient(this, caller);
    }

    public boolean Define_boolean_mayBeStrictfp(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeStrictfp(this, caller);
    }

    public boolean Define_boolean_mayBeSynchronized(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeSynchronized(this, caller);
    }

    public boolean Define_boolean_mayBeNative(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeNative(this, caller);
    }

    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    public VariableScope Define_VariableScope_outerScope(ASTNode caller, ASTNode child) {
        return this.getParent().Define_VariableScope_outerScope(this, caller);
    }

    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_insideLoop(this, caller);
    }

    public boolean Define_boolean_insideSwitch(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_insideSwitch(this, caller);
    }

    public Case Define_Case_bind(ASTNode caller, ASTNode child, Case c) {
        return this.getParent().Define_Case_bind(this, caller, c);
    }

    public String Define_String_typeDeclIndent(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_typeDeclIndent(this, caller);
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public boolean Define_boolean_isAnonymous(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isAnonymous(this, caller);
    }

    public Variable Define_Variable_unknownField(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Variable_unknownField(this, caller);
    }

    public MethodDecl Define_MethodDecl_unknownMethod(ASTNode caller, ASTNode child) {
        return this.getParent().Define_MethodDecl_unknownMethod(this, caller);
    }

    public ConstructorDecl Define_ConstructorDecl_unknownConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ConstructorDecl_unknownConstructor(this, caller);
    }

    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_declType(this, caller);
    }

    public BodyDecl Define_BodyDecl_enclosingBodyDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_BodyDecl_enclosingBodyDecl(this, caller);
    }

    public boolean Define_boolean_isMemberType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isMemberType(this, caller);
    }

    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_hostType(this, caller);
    }

    public TypeDecl Define_TypeDecl_switchType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_switchType(this, caller);
    }

    public TypeDecl Define_TypeDecl_returnType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_returnType(this, caller);
    }

    public TypeDecl Define_TypeDecl_enclosingInstance(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingInstance(this, caller);
    }

    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_methodHost(this, caller);
    }

    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_inExplicitConstructorInvocation(this, caller);
    }

    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isMethodParameter(this, caller);
    }

    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isConstructorParameter(this, caller);
    }

    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isExceptionHandlerParameter(this, caller);
    }

    public int Define_int_variableScopeEndLabel(ASTNode caller, ASTNode child, CodeGeneration gen) {
        return this.getParent().Define_int_variableScopeEndLabel(this, caller, gen);
    }

    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_expectedType(this, caller);
    }

    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        return this.getParent().Define_int_localNum(this, caller);
    }

    public int Define_int_resultSaveLocalNum(ASTNode caller, ASTNode child) {
        return this.getParent().Define_int_resultSaveLocalNum(this, caller);
    }

    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    public ElementValue Define_ElementValue_lookupElementTypeValue(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_ElementValue_lookupElementTypeValue(this, caller, name);
    }

    public boolean Define_boolean_withinSuppressWarnings(ASTNode caller, ASTNode child, String s) {
        return this.getParent().Define_boolean_withinSuppressWarnings(this, caller, s);
    }

    public boolean Define_boolean_withinDeprecatedAnnotation(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_withinDeprecatedAnnotation(this, caller);
    }

    public Annotation Define_Annotation_lookupAnnotation(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_Annotation_lookupAnnotation(this, caller, typeDecl);
    }

    public TypeDecl Define_TypeDecl_enclosingAnnotationDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingAnnotationDecl(this, caller);
    }

    public GenericMethodDecl Define_GenericMethodDecl_genericMethodDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_GenericMethodDecl_genericMethodDecl(this, caller);
    }

    public GenericConstructorDecl Define_GenericConstructorDecl_genericConstructorDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_GenericConstructorDecl_genericConstructorDecl(this, caller);
    }

    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeWildcard(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeWildcard(this, caller);
    }

    public TypeDecl Define_TypeDecl_lookupWildcardExtends(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_TypeDecl_lookupWildcardExtends(this, caller, typeDecl);
    }

    public TypeDecl Define_TypeDecl_lookupWildcardSuper(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_TypeDecl_lookupWildcardSuper(this, caller, typeDecl);
    }

    public LUBType Define_LUBType_lookupLUBType(ASTNode caller, ASTNode child, Collection bounds) {
        return this.getParent().Define_LUBType_lookupLUBType(this, caller, bounds);
    }

    public GLBType Define_GLBType_lookupGLBType(ASTNode caller, ASTNode child, ArrayList bounds) {
        return this.getParent().Define_GLBType_lookupGLBType(this, caller, bounds);
    }

    public TypeDecl Define_TypeDecl_genericDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_genericDecl(this, caller);
    }

    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_variableArityValid(this, caller);
    }

    public CompilationUnit Define_CompilationUnit_compilationUnit(ASTNode caller, ASTNode child) {
        return this.getParent().Define_CompilationUnit_compilationUnit(this, caller);
    }

    public SimpleSet Define_SimpleSet_allImportedTypes(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_allImportedTypes(this, caller, name);
    }

    public String Define_String_packageName(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_packageName(this, caller);
    }

    public TypeDecl Define_TypeDecl_enclosingType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingType(this, caller);
    }

    public boolean Define_boolean_isNestedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isNestedType(this, caller);
    }

    public boolean Define_boolean_isLocalClass(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isLocalClass(this, caller);
    }

    public String Define_String_hostPackage(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_hostPackage(this, caller);
    }

    public String Define_String_destinationPath(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_destinationPath(this, caller);
    }

    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    public boolean Define_boolean_reachableCatchClause(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reachableCatchClause(this, caller);
    }
}

