/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.ArrayTypeAccess;
import AST.ArrayTypeWithSizeAccess;
import AST.CodeGeneration;
import AST.ConstructorDecl;
import AST.Dims;
import AST.Dot;
import AST.Expr;
import AST.List;
import AST.NameType;
import AST.Opt;
import AST.TypeDecl;
import AST.Variable;
import jpe.Environment;

public abstract class Access
extends Expr
implements Cloneable {
    protected boolean prevExpr_computed = false;
    protected Expr prevExpr_value;
    protected boolean hasPrevExpr_computed = false;
    protected boolean hasPrevExpr_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.prevExpr_computed = false;
        this.prevExpr_value = null;
        this.hasPrevExpr_computed = false;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Access clone() throws CloneNotSupportedException {
        Access node = (Access)super.clone();
        node.prevExpr_computed = false;
        node.prevExpr_value = null;
        node.hasPrevExpr_computed = false;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Access addArrayDims(List list) {
        Access a = this;
        int i = 0;
        while (i < list.getNumChildNoTransform()) {
            Dims dims = (Dims)list.getChildNoTransform(i);
            Opt<Expr> opt = dims.getExprOpt();
            a = opt.getNumChildNoTransform() == 1 ? new ArrayTypeWithSizeAccess(a, (Expr)opt.getChildNoTransform(0)) : new ArrayTypeAccess(a);
            a.setStart(dims.start());
            a.setEnd(dims.end());
            ++i;
        }
        return a;
    }

    public void emitLoadLocalInNestedClass(CodeGeneration gen, Variable v) {
        if (this.inExplicitConstructorInvocation() && this.enclosingBodyDecl() instanceof ConstructorDecl) {
            ConstructorDecl c = (ConstructorDecl)this.enclosingBodyDecl();
            v.type().emitLoadLocal(gen, c.localIndexOfEnclosingVariable(v));
        } else {
            String classname = this.hostType().constantPoolName();
            String desc = v.type().typeDescriptor();
            String name = "val$" + v.name();
            int index = gen.constantPool().addFieldref(classname, name, desc);
            gen.emit((byte)42);
            gen.emit((byte)-76, v.type().variableSize() - 1).add2(index);
        }
    }

    public void emitThis(CodeGeneration gen, TypeDecl targetDecl) {
        if (targetDecl == this.hostType()) {
            gen.emit((byte)42);
        } else {
            TypeDecl enclosing = this.hostType();
            if (this.inExplicitConstructorInvocation()) {
                gen.emit((byte)43);
                enclosing = enclosing.enclosing();
            } else {
                gen.emit((byte)42);
            }
            while (enclosing != targetDecl) {
                String classname = enclosing.constantPoolName();
                enclosing = enclosing.enclosingType();
                String desc = enclosing.typeDescriptor();
                int index = gen.constantPool().addFieldref(classname, "this$0", desc);
                gen.emit((byte)-76, 0).add2(index);
            }
        }
    }

    protected TypeDecl superConstructorQualifier(TypeDecl targetEnclosingType) {
        TypeDecl enclosing = this.hostType();
        while (!enclosing.instanceOf(targetEnclosingType)) {
            enclosing = enclosing.enclosingType();
        }
        return enclosing;
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public Expr unqualifiedScope() {
        ASTNode$State state = this.state();
        Expr unqualifiedScope_value = this.unqualifiedScope_compute();
        return unqualifiedScope_value;
    }

    private Expr unqualifiedScope_compute() {
        return this.isQualified() ? this.nestedScope() : this;
    }

    public boolean isQualified() {
        ASTNode$State state = this.state();
        boolean isQualified_value = this.isQualified_compute();
        return isQualified_value;
    }

    private boolean isQualified_compute() {
        return this.hasPrevExpr();
    }

    public Expr qualifier() {
        ASTNode$State state = this.state();
        Expr qualifier_value = this.qualifier_compute();
        return qualifier_value;
    }

    private Expr qualifier_compute() {
        return this.prevExpr();
    }

    public Access lastAccess() {
        ASTNode$State state = this.state();
        Access lastAccess_value = this.lastAccess_compute();
        return lastAccess_value;
    }

    private Access lastAccess_compute() {
        return this;
    }

    public Expr prevExpr() {
        if (this.prevExpr_computed) {
            return this.prevExpr_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.prevExpr_value = this.prevExpr_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.prevExpr_computed = true;
        }
        return this.prevExpr_value;
    }

    private Expr prevExpr_compute() {
        if (this.isLeftChildOfDot()) {
            if (this.parentDot().isRightChildOfDot()) {
                return this.parentDot().parentDot().leftSide();
            }
        } else if (this.isRightChildOfDot()) {
            return this.parentDot().leftSide();
        }
        throw new Error(this + " does not have a previous expression");
    }

    public boolean hasPrevExpr() {
        if (this.hasPrevExpr_computed) {
            return this.hasPrevExpr_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.hasPrevExpr_value = this.hasPrevExpr_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.hasPrevExpr_computed = true;
        }
        return this.hasPrevExpr_value;
    }

    private boolean hasPrevExpr_compute() {
        return this.isLeftChildOfDot() ? this.parentDot().isRightChildOfDot() : this.isRightChildOfDot();
    }

    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.NO_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.unknownType();
    }

    @Override
    public int sourceLineNumber() {
        ASTNode$State state = this.state();
        int sourceLineNumber_value = this.sourceLineNumber_compute();
        return sourceLineNumber_value;
    }

    private int sourceLineNumber_compute() {
        return this.findFirstSourceLineNumber();
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        if (this.hasPrevExpr()) {
            return new Dot((Expr)this.qualifier().fullCopy(), (Access)this.fullCopy());
        }
        return (Access)this.fullCopy();
    }

    public Expr nestedScope() {
        ASTNode$State state = this.state();
        Expr nestedScope_value = this.getParent().Define_Expr_nestedScope(this, null);
        return nestedScope_value;
    }

    @Override
    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public Variable unknownField() {
        ASTNode$State state = this.state();
        Variable unknownField_value = this.getParent().Define_Variable_unknownField(this, null);
        return unknownField_value;
    }

    public boolean inExplicitConstructorInvocation() {
        ASTNode$State state = this.state();
        boolean inExplicitConstructorInvocation_value = this.getParent().Define_boolean_inExplicitConstructorInvocation(this, null);
        return inExplicitConstructorInvocation_value;
    }

    public boolean withinSuppressWarnings(String s) {
        ASTNode$State state = this.state();
        boolean withinSuppressWarnings_String_value = this.getParent().Define_boolean_withinSuppressWarnings(this, null, s);
        return withinSuppressWarnings_String_value;
    }

    public boolean withinDeprecatedAnnotation() {
        ASTNode$State state = this.state();
        boolean withinDeprecatedAnnotation_value = this.getParent().Define_boolean_withinDeprecatedAnnotation(this, null);
        return withinDeprecatedAnnotation_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

