/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.CodeGeneration;
import AST.Dot;
import AST.Expr;
import AST.Literal;
import AST.NameType;
import AST.ObjectLiteral;
import AST.SimpleSet;
import AST.TypeDecl;
import AST.Variable;
import java.util.Collection;
import jpe.Environment;

public class ArrayAccess
extends Access
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ArrayAccess clone() throws CloneNotSupportedException {
        ArrayAccess node = (ArrayAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ArrayAccess copy() {
        try {
            ArrayAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ArrayAccess fullCopy() {
        ArrayAccess res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("[");
        this.getExpr().toString(s);
        s.append("]");
    }

    @Override
    public void typeCheck() {
        if (this.isQualified() && !this.qualifier().type().isArrayDecl() && !this.qualifier().type().isUnknown()) {
            this.error("the type " + this.qualifier().type().name() + " of the indexed element is not an array");
        }
        if (!this.getExpr().type().unaryNumericPromotion().isInt() || !this.getExpr().type().isIntegralType()) {
            this.error("array index must be int after unary numeric promotion which " + this.getExpr().type().typeName() + " is not");
        }
    }

    @Override
    public void emitStore(CodeGeneration gen) {
        gen.emit(this.type().arrayStore());
    }

    @Override
    public void createPushAssignmentResult(CodeGeneration gen) {
        this.type().emitDup_x2(gen);
    }

    public ArrayAccess() {
    }

    public ArrayAccess(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void createAssignSimpleLoadDest(CodeGeneration gen) {
        this.prevExpr().createBCode(gen);
        this.getExpr().createBCode(gen);
        this.getExpr().type().emitCastTo(gen, this.typeInt());
    }

    @Override
    public void createAssignLoadDest(CodeGeneration gen) {
        this.prevExpr().createBCode(gen);
        gen.emitDup();
        this.getExpr().createBCode(gen);
        this.getExpr().type().emitCastTo(gen, this.typeInt());
        this.typeInt().emitDup_x1(gen);
        gen.emit(this.type().arrayLoad());
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.prevExpr().createBCode(gen);
        this.getExpr().createBCode(gen);
        this.getExpr().type().emitCastTo(gen, this.typeInt());
        gen.emit(this.type().arrayLoad());
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    @Override
    public boolean isArrayAccess() {
        ASTNode$State state = this.state();
        boolean isArrayAccess_value = this.isArrayAccess_compute();
        return isArrayAccess_value;
    }

    private boolean isArrayAccess_compute() {
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.EXPRESSION_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.isQualified() ? this.qualifier().type().componentType() : this.unknownType();
    }

    @Override
    public boolean isVariable() {
        ASTNode$State state = this.state();
        boolean isVariable_value = this.isVariable_compute();
        return isVariable_value;
    }

    private boolean isVariable_compute() {
        return true;
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        Expr target = this.qualifier().pe(env);
        Expr index = this.getExpr().pe(env);
        if (target instanceof ObjectLiteral && index instanceof Literal) {
            Object val = index.literalValueObject();
            return ((ObjectLiteral)target).getArrayItem(((Number)val).intValue());
        }
        return new Dot(target, new ArrayAccess(index));
    }

    @Override
    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupType(name);
        }
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getExprNoTransform()) {
            return this.unqualifiedScope().lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

