/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.ArrayInit;
import AST.ArrayTypeAccess;
import AST.ArrayTypeWithSizeAccess;
import AST.CodeGeneration;
import AST.Expr;
import AST.IntegerLiteral;
import AST.List;
import AST.Literal;
import AST.NameType;
import AST.ObjectLiteral;
import AST.Opt;
import AST.PrimaryExpr;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.Variable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import jpe.ArrayProperty;
import jpe.Environment;
import jpe.Util;

public class ArrayCreationExpr
extends PrimaryExpr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean numArrays_computed = false;
    protected int numArrays_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.numArrays_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ArrayCreationExpr clone() throws CloneNotSupportedException {
        ArrayCreationExpr node = (ArrayCreationExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.numArrays_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ArrayCreationExpr copy() {
        try {
            ArrayCreationExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ArrayCreationExpr fullCopy() {
        ArrayCreationExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("new ");
        this.getTypeAccess().toString(s);
        if (this.hasArrayInit()) {
            this.getArrayInit().toString(s);
        }
    }

    private ArrayProperty getArrayProperty(ArrayTypeWithSizeAccess atwsa, java.util.List<Integer> dims) {
        if (atwsa.getExpr() instanceof IntegerLiteral) {
            int asize = atwsa.getExpr().constant().intValue();
            dims.add(0, asize);
            if (atwsa.getAccess() instanceof ArrayTypeWithSizeAccess) {
                return this.getArrayProperty((ArrayTypeWithSizeAccess)atwsa.getAccess(), dims);
            }
            if (atwsa.getAccess() instanceof TypeAccess) {
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.typeAccess = (TypeAccess)atwsa.getAccess();
                arrayProperty.dims = new int[dims.size()];
                int i = 0;
                while (i < dims.size()) {
                    arrayProperty.dims[i] = dims.get(i);
                    ++i;
                }
                return arrayProperty;
            }
            Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "The array creation type not resolved to a type.");
            throw new Error("The array creation type not resolved to a type.");
        }
        Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "The size is not an integer in array creation expression. It should be because the left hand side is Static stage.");
        throw new Error("The size is not an integer in array creation expression. It should be because the left hand side is Static stage.");
    }

    public ArrayCreationExpr() {
        this.setChild(new Opt(), 1);
    }

    public ArrayCreationExpr(Access p0, Opt<ArrayInit> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setArrayInitOpt(Opt<ArrayInit> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasArrayInit() {
        return this.getArrayInitOpt().getNumChild() != 0;
    }

    public ArrayInit getArrayInit() {
        return (ArrayInit)this.getArrayInitOpt().getChild(0);
    }

    public void setArrayInit(ArrayInit node) {
        this.getArrayInitOpt().setChild(node, 0);
    }

    public Opt<ArrayInit> getArrayInitOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<ArrayInit> getArrayInitOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        if (this.hasArrayInit()) {
            this.getArrayInit().createBCode(gen);
        } else {
            this.getTypeAccess().createBCode(gen);
            if (this.type().componentType().isPrimitive() && !this.type().componentType().isReferenceType()) {
                gen.emit((byte)-68).add(this.type().componentType().arrayPrimitiveTypeDescriptor());
            } else if (this.numArrays() == 1) {
                String n = this.type().componentType().arrayTypeDescriptor();
                int index = gen.constantPool().addClass(n);
                gen.emit((byte)-67).add2(index);
            } else {
                String n = this.type().arrayTypeDescriptor();
                int index = gen.constantPool().addClass(n);
                gen.emit((byte)-59, 1 - this.numArrays()).add2(index).add(this.numArrays());
            }
        }
    }

    public boolean isDAafterCreation(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterCreation_Variable_value = this.isDAafterCreation_compute(v);
        return isDAafterCreation_Variable_value;
    }

    private boolean isDAafterCreation_compute(Variable v) {
        return this.getTypeAccess().isDAafter(v);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.hasArrayInit() ? this.getArrayInit().isDAafter(v) : this.isDAafterCreation(v);
    }

    public boolean isDUafterCreation(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterCreation_Variable_value = this.isDUafterCreation_compute(v);
        return isDUafterCreation_Variable_value;
    }

    private boolean isDUafterCreation_compute(Variable v) {
        return this.getTypeAccess().isDUafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.hasArrayInit() ? this.getArrayInit().isDUafter(v) : this.isDUafterCreation(v);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    public int numArrays() {
        if (this.numArrays_computed) {
            return this.numArrays_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.numArrays_value = this.numArrays_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.numArrays_computed = true;
        }
        return this.numArrays_value;
    }

    private int numArrays_compute() {
        int i = this.type().dimension();
        Access a = this.getTypeAccess();
        while (a instanceof ArrayTypeAccess && !(a instanceof ArrayTypeWithSizeAccess)) {
            --i;
            a = ((ArrayTypeAccess)a).getAccess();
        }
        return i;
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        ArrayCreationExpr ace = this.fullCopy();
        Access na = (Access)this.getTypeAccess().pe(env);
        ace.setTypeAccess(na);
        if (env.isExecuteFlagOn()) {
            if (na instanceof ArrayTypeWithSizeAccess) {
                ArrayProperty ap = this.getArrayProperty((ArrayTypeWithSizeAccess)na, new ArrayList<Integer>());
                Object objectArray = null;
                try {
                    objectArray = Array.newInstance(Util.getClassForType(String.valueOf(ap.typeAccess.getPackage()) + "." + ap.typeAccess.getID()), ap.dims);
                    ObjectLiteral arrayObjectLiteral = new ObjectLiteral();
                    arrayObjectLiteral.setObject(objectArray);
                    arrayObjectLiteral.setTypeDecl(this.type());
                    arrayObjectLiteral.setParent(this);
                    return arrayObjectLiteral;
                }
                catch (NegativeArraySizeException e) {
                    Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
                    e.printStackTrace();
                }
            } else if (na instanceof ArrayTypeAccess) {
                TypeAccess t1TypeAccess = (TypeAccess)na;
                Object objectArray = null;
                if (this.hasArrayInit()) {
                    ArrayInit ainit = (ArrayInit)this.getArrayInit().pe(env);
                    try {
                        List<Expr> initList = ainit.getInitList();
                        objectArray = Array.newInstance(Util.getClassForType(String.valueOf(t1TypeAccess.getPackage()) + "." + t1TypeAccess.getID()), initList.getNumChild());
                        int j = 0;
                        while (j < initList.getNumChild()) {
                            if (!(initList.getChild(j) instanceof Literal)) {
                                Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "Array init expression are expected to produce literal results.");
                                throw new Error("Array init expression are expected to produce literal results.");
                            }
                            Array.set(objectArray, j, ((Literal)initList.getChild(j)).literalValueObject());
                            ++j;
                        }
                        ObjectLiteral arrayObjectLiteral = new ObjectLiteral();
                        arrayObjectLiteral.setObject(objectArray);
                        arrayObjectLiteral.setTypeDecl(this.type());
                        arrayObjectLiteral.setParent(this);
                        return arrayObjectLiteral;
                    }
                    catch (NegativeArraySizeException e) {
                        Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
                        e.printStackTrace();
                    }
                } else {
                    Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "Array init is missing");
                    throw new Error("Array init is missing");
                }
            }
        }
        if (this.hasArrayInit()) {
            ArrayInit ainit = (ArrayInit)this.getArrayInit().pe(env);
            ace.setArrayInit(ainit);
        }
        return ace;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.isDAafterCreation(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.isDUafterCreation(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.type();
        }
        return this.getParent().Define_TypeDecl_declType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.type().componentType();
        }
        return this.getParent().Define_TypeDecl_expectedType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

