/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.BoundFieldAccess;
import AST.CastExpr;
import AST.ClassInstanceExpr;
import AST.CodeGeneration;
import AST.Expr;
import AST.FieldDeclaration;
import AST.IfStmt;
import AST.List;
import AST.LogNotExpr;
import AST.Opt;
import AST.OrLogicalExpr;
import AST.ParExpr;
import AST.Stmt;
import AST.ThrowStmt;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.Variable;
import java.util.HashMap;

public class AssertStmt
extends Stmt
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssertStmt clone() throws CloneNotSupportedException {
        AssertStmt node = (AssertStmt)super.clone();
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssertStmt copy() {
        try {
            AssertStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AssertStmt fullCopy() {
        AssertStmt res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("assert ");
        this.getfirst().toString(s);
        if (this.hasExpr()) {
            s.append(" : ");
            this.getExpr().toString(s);
        }
        s.append(";");
    }

    @Override
    public void typeCheck() {
        if (!this.getfirst().type().isBoolean()) {
            this.error("Assert requires boolean condition");
        }
        if (this.hasExpr() && this.getExpr().type().isVoid()) {
            this.error("The second part of an assert statement may not be void");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        throw new UnsupportedOperationException("Assert not implemented yet");
    }

    @Override
    public void transformation() {
        super.transformation();
        FieldDeclaration f = this.hostType().topLevelType().createStaticClassField(this.hostType().topLevelType().referenceClassFieldName());
        FieldDeclaration assertionsDisabled = this.hostType().createAssertionsDisabled();
        Expr condition = (Expr)this.getfirst().fullCopy();
        List<Expr> args = new List<Expr>();
        if (this.hasExpr()) {
            if (this.getExpr().type().isString()) {
                args.add(new CastExpr(new TypeAccess("java.lang", "Object"), (Expr)this.getExpr().fullCopy()));
            } else {
                args.add((Expr)this.getExpr().fullCopy());
            }
        }
        IfStmt stmt = new IfStmt((Expr)new LogNotExpr(new ParExpr(new OrLogicalExpr(new BoundFieldAccess(assertionsDisabled), condition))), (Stmt)new ThrowStmt(new ClassInstanceExpr(this.lookupType("java.lang", "AssertionError").createQualifiedAccess(), args, new Opt<TypeDecl>())), new Opt<Stmt>());
        this.replace(this).with(stmt);
        stmt.transformation();
    }

    public AssertStmt() {
        this.setChild(new Opt(), 1);
    }

    public AssertStmt(Expr p0, Opt<Expr> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setfirst(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getfirst() {
        return (Expr)this.getChild(0);
    }

    public Expr getfirstNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setExprOpt(Opt<Expr> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasExpr() {
        return this.getExprOpt().getNumChild() != 0;
    }

    public Expr getExpr() {
        return (Expr)this.getExprOpt().getChild(0);
    }

    public void setExpr(Expr node) {
        this.getExprOpt().setChild(node, 0);
    }

    public Opt<Expr> getExprOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<Expr> getExprOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getfirst().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getfirst().isDUafter(v);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

