/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AssignSimpleExpr;
import AST.CodeGeneration;
import AST.Expr;
import AST.ExprStmt;
import AST.NameType;
import AST.Stmt;
import AST.TypeDecl;
import AST.Variable;

public abstract class AssignExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssignExpr clone() throws CloneNotSupportedException {
        AssignExpr node = (AssignExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    protected boolean checkDUeverywhere(Variable v) {
        if (this.getDest().isVariable() && this.getDest().varDecl() == v && !this.getSource().isDAafter(v)) {
            return false;
        }
        return super.checkDUeverywhere(v);
    }

    public static Stmt asStmt(Expr left, Expr right) {
        return new ExprStmt(new AssignSimpleExpr(left, right));
    }

    @Override
    public void toString(StringBuffer s) {
        this.getDest().toString(s);
        s.append(this.printOp());
        this.getSource().toString(s);
    }

    @Override
    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else {
            TypeDecl source = this.sourceType();
            TypeDecl dest = this.getDest().type();
            if (this.getSource().type().isPrimitive() && this.getDest().type().isPrimitive()) {
                return;
            }
            this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
        }
    }

    public void emitShiftExpr(CodeGeneration gen) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        TypeDecl type = dest.unaryNumericPromotion();
        this.getDest().createAssignLoadDest(gen);
        dest.emitCastTo(gen, type);
        this.getSource().createBCode(gen);
        source.emitCastTo(gen, this.typeInt());
        this.createAssignOp(gen, type);
        type.emitCastTo(gen, dest);
        if (this.needsPush()) {
            this.getDest().createPushAssignmentResult(gen);
        }
        this.getDest().emitStore(gen);
    }

    public void createAssignOp(CodeGeneration gen, TypeDecl type) {
        throw new Error("Operation createAssignOp is not implemented for " + this.getClass().getName());
    }

    public AssignExpr() {
    }

    public AssignExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        TypeDecl type = dest.isNumericType() && source.isNumericType() ? dest.binaryNumericPromotion(source) : (dest.isBoolean() && source.isBoolean() ? (dest.isReferenceType() ? dest.unboxed() : dest) : dest);
        this.getDest().createAssignLoadDest(gen);
        dest.emitCastTo(gen, type);
        this.getSource().createBCode(gen);
        source.emitCastTo(gen, type);
        this.createAssignOp(gen, type);
        type.emitCastTo(gen, dest);
        if (this.needsPush()) {
            this.getDest().createPushAssignmentResult(gen);
        }
        this.getDest().emitStore(gen);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getSource().isDAafter(v);
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.isDAafter(v) || this.isFalse();
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.isDAafter(v) || this.isTrue();
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getSource().isDUafter(v);
    }

    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterTrue_Variable_value = this.isDUafterTrue_compute(v);
        return isDUafterTrue_Variable_value;
    }

    private boolean isDUafterTrue_compute(Variable v) {
        return this.isDUafter(v);
    }

    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterFalse_Variable_value = this.isDUafterFalse_compute(v);
        return isDUafterFalse_Variable_value;
    }

    private boolean isDUafterFalse_compute(Variable v) {
        return this.isDUafter(v);
    }

    public String printOp() {
        ASTNode$State state = this.state();
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " = ";
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getDest().type();
    }

    public TypeDecl sourceType() {
        ASTNode$State state = this.state();
        TypeDecl sourceType_value = this.sourceType_compute();
        return sourceType_value;
    }

    private TypeDecl sourceType_compute() {
        return this.getSource().type().isPrimitive() ? this.getSource().type() : this.unknownType();
    }

    @Override
    public boolean needsPop() {
        ASTNode$State state = this.state();
        boolean needsPop_value = this.needsPop_compute();
        return needsPop_value;
    }

    private boolean needsPop_compute() {
        return this.getDest().isVarAccessWithAccessor();
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return false;
        }
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return true;
        }
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getDestNoTransform()) {
            return this.isDAbefore(v);
        }
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().isDAafter(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getDestNoTransform()) {
            return this.isDUbefore(v);
        }
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().isDUafter(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

