/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.ArrayAccess;
import AST.AssignExpr;
import AST.CodeGeneration;
import AST.Dot;
import AST.Expr;
import AST.Literal;
import AST.MethodAccess;
import AST.ObjectLiteral;
import AST.ParameterDeclaration;
import AST.PartialObject;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.VarAccess;
import AST.Variable;
import java.lang.reflect.Array;
import java.util.Map;
import jpe.Environment;
import jpe.Util;
import jpe.error.UnInlinableException;

public class AssignSimpleExpr
extends AssignExpr
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssignSimpleExpr clone() throws CloneNotSupportedException {
        AssignSimpleExpr node = (AssignSimpleExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssignSimpleExpr copy() {
        try {
            AssignSimpleExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AssignSimpleExpr fullCopy() {
        AssignSimpleExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else if (!this.sourceType().assignConversionTo(this.getDest().type(), this.getSource()) && !this.sourceType().isUnknown()) {
            this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.getDest().createAssignSimpleLoadDest(gen);
        this.getSource().createBCode(gen);
        this.getSource().type().emitAssignConvTo(gen, this.getDest().type());
        if (this.needsPush()) {
            this.getDest().createPushAssignmentResult(gen);
        }
        this.getDest().emitStore(gen);
    }

    private VarAccess getArrayVarAccess(ArrayAccess lastAccess) {
        if (lastAccess.qualifier() instanceof VarAccess) {
            return (VarAccess)lastAccess.qualifier();
        }
        if (lastAccess.qualifier() instanceof Dot) {
            return this.getArrayVarAccess((ArrayAccess)((Dot)lastAccess.qualifier()).lastAccess());
        }
        return this.getArrayVarAccess((ArrayAccess)lastAccess.qualifier());
    }

    @Override
    public Expr inline(Map<ParameterDeclaration, Expr> paramVarMap) throws UnInlinableException {
        Expr e = this.getDest();
        if (!(e instanceof VarAccess)) {
            throw new UnInlinableException();
        }
        VarAccess v = (VarAccess)e;
        Expr newDest = v.inline(paramVarMap);
        Expr s = this.getSource();
        if (s instanceof MethodAccess) {
            throw new UnInlinableException();
        }
        Expr newSource = s.inline(paramVarMap);
        return new AssignSimpleExpr(newDest, s);
    }

    @Override
    public boolean canRemove(Map<String, Boolean> usedVars) {
        this.getDest().addUsedVars(usedVars);
        Access acc = (Access)this.getDest();
        VarAccess v = acc.isArrayAccess() ? this.getArrayVarAccess((ArrayAccess)acc.lastAccess()) : (VarAccess)acc.lastAccess();
        String varName = v.name();
        if (!acc.hasPrevExpr() && !usedVars.containsKey(varName)) {
            return this.getSource().canRemove(usedVars);
        }
        this.getSource().addUsedVars(usedVars);
        if (usedVars.containsKey(varName) && !usedVars.get(varName).booleanValue()) {
            return true;
        }
        if (!usedVars.containsKey(varName)) {
            usedVars.put(varName, new Boolean(false));
        }
        return false;
    }

    public AssignSimpleExpr() {
    }

    public AssignSimpleExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public String printOp() {
        ASTNode$State state = this.state();
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " = ";
    }

    @Override
    public TypeDecl sourceType() {
        ASTNode$State state = this.state();
        TypeDecl sourceType_value = this.sourceType_compute();
        return sourceType_value;
    }

    private TypeDecl sourceType_compute() {
        return this.getSource().type();
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        Access d = (Access)this.getDest();
        VarAccess targetVar = d.isArrayAccess() ? this.getArrayVarAccess((ArrayAccess)d.lastAccess()) : (VarAccess)d.lastAccess();
        Variable targetvardecl = targetVar.decl();
        if (targetvardecl.getCompileTimeInfo() == null) {
            Util.populateCompileTimeInfo(targetvardecl);
        }
        Expr pe1 = null;
        Expr pe2 = null;
        if (targetVar.hasPrevExpr()) {
            pe1 = targetVar.prevExpr().pe(env);
        }
        if (d.isArrayAccess()) {
            if (targetvardecl.getCompileTimeInfo().canBeStaticInEnv(env) || pe1 instanceof Literal) {
                ObjectLiteral arrayOL = (ObjectLiteral)d.lastAccess().qualifier().pe(env);
                ArrayAccess aacc = (ArrayAccess)d.lastAccess();
                int index = aacc.getExpr().constant().intValue();
                env.setExecuteFlag();
                pe2 = this.getSource().pe(env);
                env.unsetExecuteFlag();
                boolean literalSource = pe2 instanceof Literal;
                if (!literalSource) {
                    Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "The right hand side has to be static stage.");
                    throw new Error("The right hand side has to be static stage.");
                }
                Array.set(arrayOL.getObject(), index, ((Literal)pe2).literalValueObject());
                return null;
            }
            pe2 = this.getSource().pe(env);
            return new AssignSimpleExpr(this.getDest().pe(env), pe2);
        }
        if (targetvardecl.getCompileTimeInfo().canBeStaticInEnv(env) || pe1 instanceof Literal) {
            env.setExecuteFlag();
            pe2 = this.getSource().pe(env);
            env.unsetExecuteFlag();
            boolean literalSource = pe2 instanceof Literal;
            if (!literalSource) {
                Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "The right hand side has to be static stage.");
                throw new Error("The right hand side has to be static stage.");
            }
            if (pe1 == null) {
                env.add(targetvardecl, pe2);
            } else if (pe1 instanceof ObjectLiteral) {
                ((ObjectLiteral)pe1).setFieldValue(targetvardecl, pe2);
            } else if (pe1 instanceof PartialObject) {
                ((PartialObject)pe1).setFieldValue(targetvardecl, pe2);
            } else if (pe1 instanceof TypeAccess) {
                // empty if block
            }
            return null;
        }
        pe2 = this.getSource().pe(env);
        if (pe2 instanceof ObjectLiteral) {
            if (pe1 == null) {
                env.add(targetvardecl, pe2);
            } else if (pe1 instanceof ObjectLiteral) {
                ((ObjectLiteral)pe1).setFieldValue(targetvardecl, pe2);
            } else if (pe1 instanceof PartialObject) {
                ((PartialObject)pe1).setFieldValue(targetvardecl, pe2);
            } else if (pe1 instanceof TypeAccess) {
                // empty if block
            }
            return null;
        }
        Access newDest = targetVar.hasPrevExpr() ? new Dot(pe1, targetVar) : targetVar;
        return new AssignSimpleExpr(newDest, pe2);
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return super.Define_boolean_isDest(caller, child);
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return false;
        }
        return super.Define_boolean_isSource(caller, child);
    }

    @Override
    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().type();
        }
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

