/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.BytecodeDebug;

public class ByteArray {
    private int stackDepth = 0;
    private int maxStackDepth = 0;
    private int size = 64;
    private byte[] bytes = new byte[this.size];
    private int pos = 0;
    private int lastGotoPos = 0;

    ByteArray add(int i) {
        return this.add((byte)i);
    }

    ByteArray add(byte b) {
        if (this.pos >= this.size) {
            byte[] ba = new byte[this.size * 2];
            System.arraycopy(this.bytes, 0, ba, 0, this.size);
            this.size *= 2;
            this.bytes = ba;
        }
        this.bytes[this.pos++] = b;
        return this;
    }

    ByteArray add4(int i) {
        this.add(i >> 24 & 0xFF);
        this.add(i >> 16 & 0xFF);
        this.add(i >> 8 & 0xFF);
        this.add(i & 0xFF);
        return this;
    }

    ByteArray add2(int index) {
        this.add(index >> 8 & 0xFF);
        this.add(index & 0xFF);
        return this;
    }

    ByteArray emit(byte b) {
        this.changeStackDepth(BytecodeDebug.stackChange(b));
        this.add(b);
        return this;
    }

    ByteArray emitGoto(byte b) {
        this.changeStackDepth(BytecodeDebug.stackChange(b));
        this.lastGotoPos = this.pos;
        this.add(b);
        return this;
    }

    ByteArray emit(byte b, int stackChange) {
        this.changeStackDepth(stackChange);
        this.add(b);
        return this;
    }

    public int maxStackDepth() {
        return this.maxStackDepth;
    }

    public int stackDepth() {
        return this.stackDepth;
    }

    public void changeStackDepth(int i) {
        this.stackDepth += i;
        if (this.stackDepth > this.maxStackDepth) {
            this.maxStackDepth = this.stackDepth;
        }
    }

    public int pos() {
        return this.pos;
    }

    public int lastGotoPos() {
        return this.lastGotoPos;
    }

    public void setPos(int index) {
        this.pos = index;
    }

    public int size() {
        return this.pos;
    }

    public byte get(int index) {
        return this.bytes[index];
    }

    public void set(int index, byte value) {
        this.bytes[index] = value;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.pos) {
            b.append(" " + this.bytes[i]);
            ++i;
        }
        return b.toString();
    }

    public byte[] toArray() {
        byte[] b = new byte[this.pos];
        System.arraycopy(this.bytes, 0, b, 0, this.pos);
        return b;
    }
}

