/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ByteArray;
import AST.ConstantPool;
import AST.SynchronizedStmt;
import AST.TryStmt;
import AST.TypeDecl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class CodeGeneration {
    private ByteArray bytes = new ByteArray();
    private ConstantPool constantPool;
    private boolean wideGoto = false;
    private boolean numberFormatError = false;
    private int variableScopeLabel = 1;
    private HashMap variableScopeLabelAddress = new HashMap();
    private HashMap variableScopeLabelUses = new HashMap();
    public Collection localVariableTable = new ArrayList();
    public Collection lineNumberTable = new ArrayList();
    public Collection exceptions = new ArrayList();
    int maxLocals = 0;
    private HashMap address = new HashMap();
    private HashMap uses = new HashMap();

    public void clearCodeGeneration() {
        this.bytes = null;
        this.constantPool = null;
        this.variableScopeLabelAddress = null;
        this.variableScopeLabelUses = null;
        this.localVariableTable = null;
        this.lineNumberTable = null;
        this.exceptions = null;
        this.address = null;
        this.uses = null;
    }

    public boolean numberFormatError() {
        return this.numberFormatError;
    }

    public CodeGeneration(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public CodeGeneration(ConstantPool constantPool, boolean wideGoto) {
        this.constantPool = constantPool;
        this.wideGoto = wideGoto;
    }

    public ConstantPool constantPool() {
        return this.constantPool;
    }

    public int variableScopeLabel() {
        return this.variableScopeLabel++;
    }

    public void addVariableScopeLabel(int label) {
        Integer label_object = new Integer(label);
        this.variableScopeLabelAddress.put(label_object, new Integer(this.pos()));
        if (this.variableScopeLabelUses.containsKey(label_object)) {
            ArrayList array = (ArrayList)this.variableScopeLabelUses.get(label_object);
            for (LocalVariableEntry e : array) {
                e.length = this.pos() - e.start_pc;
            }
        }
    }

    public void addLocalVariableEntryAtCurrentPC(String name, String typeDescriptor, int localNum, int variableScopeEndLabel) {
        LocalVariableEntry e = new LocalVariableEntry();
        e.start_pc = this.pos();
        e.length = 0;
        e.name_index = this.constantPool().addUtf8(name);
        e.descriptor_index = this.constantPool().addUtf8(typeDescriptor);
        e.index = localNum;
        this.localVariableTable.add(e);
        Integer label_object = new Integer(variableScopeEndLabel);
        if (!this.variableScopeLabelUses.containsKey(label_object)) {
            this.variableScopeLabelUses.put(label_object, new ArrayList());
        }
        Collection c = (Collection)this.variableScopeLabelUses.get(label_object);
        c.add(e);
    }

    public void addLineNumberEntryAtCurrentPC(ASTNode node) {
        LineNumberEntry e = new LineNumberEntry();
        e.start_pc = this.pos();
        e.line_number = node.sourceLineNumber();
        if (e.line_number != -1 && e.line_number != 65535) {
            this.lineNumberTable.add(e);
        }
    }

    public void addException(int start_pc, int end_pc, int handler_pc, int catch_type) {
        ExceptionEntry e = new ExceptionEntry();
        e.start_pc = start_pc;
        e.end_pc = end_pc;
        e.handler_pc = handler_pc;
        e.catch_type = catch_type;
        if (e.start_pc != e.end_pc) {
            this.exceptions.add(e);
        }
    }

    public void createExceptionTable(TryStmt tryStmt) {
        int i = 0;
        while (i < tryStmt.getNumCatchClause()) {
            this.addException(this.addressOf(tryStmt.label_begin()), this.addressOf(tryStmt.label_block_end()), this.addressOf(tryStmt.getCatchClause(i).label()), this.constantPool().addClass(tryStmt.getCatchClause(i).getParameter().type().constantPoolName()));
            ++i;
        }
        if (tryStmt.hasFinally()) {
            this.addException(this.addressOf(tryStmt.label_begin()), this.addressOf(tryStmt.label_finally()), this.addressOf(tryStmt.label_exception_handler()), 0);
        }
    }

    public void createExceptionTable(SynchronizedStmt stmt) {
        this.addException(this.addressOf(stmt.label_begin()), this.addressOf(stmt.label_finally()), this.addressOf(stmt.label_exception_handler()), 0);
    }

    public int maxLocals() {
        return this.maxLocals + 1;
    }

    public void addLabel(int label) {
        Integer label_object = new Integer(label);
        this.address.put(label_object, new Integer(this.pos()));
        if (this.uses.containsKey(label_object)) {
            ArrayList array = (ArrayList)this.uses.get(label_object);
            int i = 0;
            while (i < array.size()) {
                int p = (Integer)array.get(i);
                if (this.bytes.get(p) == -56) {
                    this.setAddress32(p + 1, this.pos() - p);
                } else {
                    this.setAddress(p + 1, this.pos() - p);
                }
                ++i;
            }
        }
    }

    public int addressOf(int label) {
        Integer label_object = new Integer(label);
        if (!this.address.containsKey(label_object)) {
            throw new Error("Can not compute address of unplaced label");
        }
        return (Integer)this.address.get(label_object);
    }

    private int jump(int label) {
        Integer label_object = new Integer(label);
        if (!this.uses.containsKey(label_object)) {
            this.uses.put(label_object, new ArrayList());
        }
        ArrayList a = (ArrayList)this.uses.get(label_object);
        a.add(new Integer(this.pos()));
        Integer val = (Integer)this.address.get(label_object);
        if (val != null) {
            return val - this.pos();
        }
        return 0;
    }

    private void setAddress(int position, int address) {
        if (address > Short.MAX_VALUE || address < Short.MIN_VALUE) {
            this.numberFormatError = true;
        }
        this.bytes.set(position + 0, (byte)((address & 0xFF00) >> 8));
        this.bytes.set(position + 1, (byte)(address & 0xFF));
    }

    private void setAddress32(int position, int address) {
        this.bytes.set(position + 0, (byte)(address >> 24 & 0xFF));
        this.bytes.set(position + 1, (byte)(address >> 16 & 0xFF));
        this.bytes.set(position + 2, (byte)(address >> 8 & 0xFF));
        this.bytes.set(position + 3, (byte)(address & 0xFF));
    }

    public void emitStoreReference(int pos) {
        this.maxLocals = Math.max(this.maxLocals, pos + 1);
        if (pos == 0) {
            this.emit((byte)75);
        } else if (pos == 1) {
            this.emit((byte)76);
        } else if (pos == 2) {
            this.emit((byte)77);
        } else if (pos == 3) {
            this.emit((byte)78);
        } else if (pos < 256) {
            this.emit((byte)58).add(pos);
        } else {
            this.emit((byte)-60).emit((byte)58).add2(pos);
        }
    }

    public void emitLoadReference(int pos) {
        this.maxLocals = Math.max(this.maxLocals, pos + 1);
        if (pos == 0) {
            this.emit((byte)42);
        } else if (pos == 1) {
            this.emit((byte)43);
        } else if (pos == 2) {
            this.emit((byte)44);
        } else if (pos == 3) {
            this.emit((byte)45);
        } else if (pos < 256) {
            this.emit((byte)25).add(pos);
        } else {
            this.emit((byte)-60).emit((byte)25).add2(pos);
        }
    }

    public void emitReturn() {
        this.bytes.emit((byte)-79);
    }

    public void emitThrow() {
        this.bytes.emit((byte)-65);
    }

    public void emitInstanceof(TypeDecl type) {
        int p = this.constantPool().addClass(type.isArrayDecl() ? type.typeDescriptor() : type.constantPoolName());
        this.bytes.emit((byte)-63).add2(p);
    }

    public void emitCheckCast(TypeDecl type) {
        int p = this.constantPool().addClass(type.isArrayDecl() ? type.typeDescriptor() : type.constantPoolName());
        this.bytes.emit((byte)-64).add2(p);
    }

    public void emitDup() {
        this.bytes.emit((byte)89);
    }

    public void emitDup2() {
        this.bytes.emit((byte)92);
    }

    public void emitPop() {
        this.bytes.emit((byte)87);
    }

    public void emitSwap() {
        this.bytes.emit((byte)95);
    }

    public void emitBranchNonNull(int label) {
        int p = this.jump(label);
        this.bytes.emit((byte)-57).add2(p);
    }

    public void emitGoto(int label) {
        int p = this.jump(label);
        if (this.wideGoto) {
            this.bytes.emitGoto((byte)-56).add4(p);
        } else {
            if (p > Short.MAX_VALUE || p < Short.MIN_VALUE) {
                this.numberFormatError = true;
            }
            this.bytes.emitGoto((byte)-89).add2(p);
        }
    }

    public void emitJsr(int label) {
        int p = this.jump(label);
        this.bytes.emit((byte)-88).add2(p);
    }

    public void emitCompare(byte bytecode, int label) {
        int p = this.jump(label);
        this.bytes.emit(bytecode).add2(p);
    }

    public String toString() {
        return this.bytes.toString();
    }

    public int size() {
        return this.bytes.size();
    }

    public int pos() {
        return this.bytes.pos();
    }

    public byte[] toArray() {
        return this.bytes.toArray();
    }

    CodeGeneration add(int i) {
        return this.add((byte)i);
    }

    CodeGeneration add(byte b) {
        this.bytes.add(b);
        return this;
    }

    CodeGeneration add2(int index) {
        this.bytes.add2(index);
        return this;
    }

    CodeGeneration add4(int index) {
        this.bytes.add4(index);
        return this;
    }

    CodeGeneration emit(byte b) {
        this.bytes.emit(b);
        return this;
    }

    CodeGeneration emit(byte b, int stackChange) {
        this.bytes.emit(b, stackChange);
        return this;
    }

    public int maxStackDepth() {
        return this.bytes.maxStackDepth();
    }

    public int stackDepth() {
        return this.bytes.stackDepth();
    }

    public void changeStackDepth(int i) {
        this.bytes.changeStackDepth(i);
    }

    class ExceptionEntry {
        int start_pc;
        int end_pc;
        int handler_pc;
        int catch_type;

        ExceptionEntry() {
        }
    }

    class LineNumberEntry {
        int start_pc;
        int line_number;

        LineNumberEntry() {
        }
    }

    class LocalVariableEntry {
        int start_pc;
        int length;
        int name_index;
        int descriptor_index;
        int index;

        LocalVariableEntry() {
        }
    }
}

