/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.CPInfo;
import AST.ConstantClass;
import AST.ConstantDouble;
import AST.ConstantFieldref;
import AST.ConstantFloat;
import AST.ConstantInteger;
import AST.ConstantInterfaceMethodref;
import AST.ConstantLong;
import AST.ConstantMethodref;
import AST.ConstantNameAndType;
import AST.ConstantString;
import AST.ConstantUtf8;
import AST.TypeDecl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ConstantPool {
    public TypeDecl typeDecl;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;
    private int posCounter = 1;
    private ArrayList list = new ArrayList();
    private int labelCounter = 1;
    private HashMap classConstants = new HashMap();
    private HashMap fieldrefConstants = new HashMap();
    private HashMap methodrefConstants = new HashMap();
    private HashMap interfaceMethodrefConstants = new HashMap();
    private HashMap nameAndTypeConstants = new HashMap();
    private HashMap utf8Constants = new HashMap();
    private HashMap stringConstants = new HashMap();
    private HashMap intConstants = new HashMap();
    private HashMap floatConstants = new HashMap();
    private HashMap longConstants = new HashMap();
    private HashMap doubleConstants = new HashMap();

    public ConstantPool(TypeDecl typeDecl) {
        this.typeDecl = typeDecl;
    }

    private void addCPInfo(CPInfo info) {
        this.list.add(info);
    }

    public int numElements() {
        return this.list.size();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            s.append(iter.next().toString());
            s.append("\n");
        }
        return s.toString();
    }

    public void emit(DataOutputStream out) throws IOException {
        out.writeChar(this.posCounter);
        for (CPInfo info : this.list) {
            info.emit(out);
        }
    }

    public int newLabel() {
        return this.labelCounter++;
    }

    public int addClass(String name) {
        HashMap map = this.classConstants;
        String key = name;
        if (!map.containsKey(key)) {
            ConstantClass info = new ConstantClass(this.addUtf8(name.replace('.', '/')));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addFieldref(String classname, String name, String type) {
        HashMap map = this.fieldrefConstants;
        String key = String.valueOf(classname) + name + type;
        if (!map.containsKey(key)) {
            ConstantFieldref info = new ConstantFieldref(this.addClass(classname), this.addNameAndType(name, type));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addMethodref(String classname, String name, String desc) {
        HashMap map = this.methodrefConstants;
        String key = String.valueOf(classname) + name + desc;
        if (!map.containsKey(key)) {
            ConstantMethodref info = new ConstantMethodref(this.addClass(classname), this.addNameAndType(name, desc));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addInterfaceMethodref(String classname, String name, String desc) {
        HashMap map = this.interfaceMethodrefConstants;
        String key = String.valueOf(classname) + name + desc;
        if (!map.containsKey(key)) {
            ConstantInterfaceMethodref info = new ConstantInterfaceMethodref(this.addClass(classname), this.addNameAndType(name, desc));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addNameAndType(String name, String type) {
        HashMap map = this.nameAndTypeConstants;
        String key = String.valueOf(name) + type;
        if (!map.containsKey(key)) {
            ConstantNameAndType info = new ConstantNameAndType(this.addUtf8(name), this.addUtf8(type));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addUtf8(String name) {
        HashMap map = this.utf8Constants;
        String key = name;
        if (!map.containsKey(key)) {
            ConstantUtf8 info = new ConstantUtf8(name);
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addConstant(String val) {
        HashMap map = this.stringConstants;
        String key = val;
        if (!map.containsKey(key)) {
            ConstantString info = new ConstantString(this.addUtf8(val));
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            String s = ((Object)info).toString();
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addConstant(int val) {
        HashMap map = this.intConstants;
        Integer key = new Integer(val);
        if (!map.containsKey(key)) {
            ConstantInteger info = new ConstantInteger(val);
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addConstant(float val) {
        HashMap map = this.floatConstants;
        Float key = new Float(val);
        if (!map.containsKey(key)) {
            ConstantFloat info = new ConstantFloat(val);
            info.pos = this.posCounter;
            this.posCounter += info.size();
            this.addCPInfo(info);
            map.put(key, info);
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addConstant(long val) {
        HashMap map = this.longConstants;
        Long key = new Long(val);
        if (!map.containsKey(key)) {
            ConstantLong info = new ConstantLong(val);
            info.pos = this.posCounter;
            this.posCounter += ((CPInfo)info).size();
            this.addCPInfo(info);
            map.put(key, info);
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }

    public int addConstant(double val) {
        HashMap map = this.doubleConstants;
        Double key = new Double(val);
        if (!map.containsKey(key)) {
            ConstantDouble info = new ConstantDouble(val);
            info.pos = this.posCounter;
            this.posCounter += ((CPInfo)info).size();
            this.addCPInfo(info);
            map.put(key, info);
            return info.pos;
        }
        CPInfo info = (CPInfo)map.get(key);
        return info.pos;
    }
}

