/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ArrayDecl;
import AST.ClassDecl;
import AST.GLBTypeFactory;
import AST.GenericTypeDecl;
import AST.InterfaceDecl;
import AST.ParTypeDecl;
import AST.TypeDecl;
import AST.TypeVariable;
import AST.WildcardExtendsType;
import AST.WildcardSuperType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Constraints {
    private Collection typeVariables = new ArrayList(4);
    private Map constraintsMap = new HashMap();
    public boolean rawAccess = false;

    public void addTypeVariable(TypeVariable T) {
        if (!this.typeVariables.contains(T)) {
            this.typeVariables.add(T);
            this.constraintsMap.put(T, new ConstraintSet());
        }
    }

    public boolean unresolvedTypeArguments() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.typeArgument != null) continue;
            return true;
        }
        return false;
    }

    public void printConstraints() {
        System.err.println("Current constraints:");
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            for (TypeDecl U : set.supertypeConstraints) {
                System.err.println("  " + T.fullName() + " :> " + U.fullName());
            }
            for (TypeDecl U : set.subtypeConstraints) {
                System.err.println("  " + T.fullName() + " <: " + U.fullName());
            }
            for (TypeDecl U : set.equaltypeConstraints) {
                System.err.println("  " + T.fullName() + " = " + U.fullName());
            }
        }
    }

    public void resolveBounds() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.typeArgument != null) continue;
            set.typeArgument = T.getTypeBound(0).type();
        }
    }

    public void resolveEqualityConstraints() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            boolean done = false;
            Iterator i2 = set.equaltypeConstraints.iterator();
            while (!done && i2.hasNext()) {
                TypeDecl U = (TypeDecl)i2.next();
                if (!this.typeVariables.contains(U)) {
                    this.replaceEqualityConstraints(T, U);
                    set.equaltypeConstraints.clear();
                    set.equaltypeConstraints.add(U);
                    set.typeArgument = U;
                    done = true;
                    continue;
                }
                if (T == U) continue;
                this.replaceAllConstraints(T, U);
                done = true;
            }
            if (set.typeArgument != null || set.equaltypeConstraints.size() != 1 || !set.equaltypeConstraints.contains(T)) continue;
            set.typeArgument = T;
        }
    }

    public void replaceEqualityConstraints(TypeDecl before, TypeDecl after) {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            this.replaceConstraints(set.equaltypeConstraints, before, after);
        }
    }

    public void replaceAllConstraints(TypeDecl before, TypeDecl after) {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            this.replaceConstraints(set.supertypeConstraints, before, after);
            this.replaceConstraints(set.subtypeConstraints, before, after);
            this.replaceConstraints(set.equaltypeConstraints, before, after);
        }
    }

    private void replaceConstraints(Collection constraints, TypeDecl before, TypeDecl after) {
        ArrayList<TypeDecl> newConstraints = new ArrayList<TypeDecl>();
        Iterator i2 = constraints.iterator();
        while (i2.hasNext()) {
            TypeDecl U = (TypeDecl)i2.next();
            if (U != before) continue;
            i2.remove();
            newConstraints.add(after);
        }
        constraints.addAll(newConstraints);
    }

    public void resolveSubtypeConstraints() {
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.subtypeConstraints.isEmpty() && T.getNumTypeBound() <= 0 || set.typeArgument != null) continue;
            ArrayList bounds = new ArrayList();
            Iterator i2 = set.subtypeConstraints.iterator();
            while (i2.hasNext()) {
                bounds.add(i2.next());
            }
            int i = 0;
            while (i < T.getNumTypeBound()) {
                bounds.add(T.getTypeBound(i).type());
                ++i;
            }
            set.typeArgument = GLBTypeFactory.glb(bounds);
        }
    }

    public void resolveSupertypeConstraints() {
        for (TypeVariable T : this.typeVariables) {
            TypeDecl typeDecl;
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            if (set.supertypeConstraints.isEmpty() || set.typeArgument != null) continue;
            set.typeArgument = typeDecl = T.lookupLUBType(set.supertypeConstraints).lub();
        }
    }

    public static HashSet directSupertypes(TypeDecl t) {
        if (t instanceof ClassDecl) {
            ClassDecl type = (ClassDecl)t;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            if (type.hasSuperclass()) {
                set.add(type.superclass());
            }
            int i = 0;
            while (i < type.getNumImplements()) {
                set.add(type.getImplements(i).type());
                ++i;
            }
            return set;
        }
        if (t instanceof InterfaceDecl) {
            InterfaceDecl type = (InterfaceDecl)t;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            int i = 0;
            while (i < type.getNumSuperInterfaceId()) {
                set.add(type.getSuperInterfaceId(i).type());
                ++i;
            }
            return set;
        }
        if (t instanceof TypeVariable) {
            TypeVariable type = (TypeVariable)t;
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            int i = 0;
            while (i < type.getNumTypeBound()) {
                set.add(type.getTypeBound(i).type());
                ++i;
            }
            return set;
        }
        throw new Error("Operation not supported for " + t.fullName() + ", " + t.getClass().getName());
    }

    public static HashSet parameterizedSupertypes(TypeDecl t) {
        HashSet result = new HashSet();
        Constraints.addParameterizedSupertypes(t, new HashSet(), result);
        return result;
    }

    public static void addParameterizedSupertypes(TypeDecl t, HashSet processed, HashSet result) {
        if (!processed.contains(t)) {
            processed.add(t);
            if (t.isParameterizedType()) {
                result.add(t);
            }
            for (TypeDecl typeDecl : Constraints.directSupertypes(t)) {
                Constraints.addParameterizedSupertypes(typeDecl, processed, result);
            }
        }
    }

    public Collection typeArguments() {
        ArrayList<TypeDecl> list = new ArrayList<TypeDecl>(this.typeVariables.size());
        for (TypeVariable T : this.typeVariables) {
            ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
            list.add(set.typeArgument);
        }
        return list;
    }

    public void addSupertypeConstraint(TypeDecl T, TypeDecl A) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.supertypeConstraints.add(A);
    }

    public void addSubtypeConstraint(TypeDecl T, TypeDecl A) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.subtypeConstraints.add(A);
    }

    public void addEqualConstraint(TypeDecl T, TypeDecl A) {
        ConstraintSet set = (ConstraintSet)this.constraintsMap.get(T);
        set.equaltypeConstraints.add(A);
    }

    public void convertibleTo(TypeDecl A, TypeDecl F) {
        block22: {
            block24: {
                TypeDecl U;
                block25: {
                    block23: {
                        block21: {
                            if (!F.involvesTypeParameters()) {
                                return;
                            }
                            if (A.isNull()) {
                                return;
                            }
                            if (!A.isUnboxedPrimitive()) break block21;
                            TypeDecl U2 = A.boxed();
                            this.convertibleTo(U2, F);
                            break block22;
                        }
                        if (!(F instanceof TypeVariable)) break block23;
                        if (!this.typeVariables.contains(F)) break block22;
                        this.addSupertypeConstraint(F, A);
                        break block22;
                    }
                    if (!F.isArrayDecl()) break block24;
                    U = ((ArrayDecl)F).componentType();
                    if (!U.involvesTypeParameters()) {
                        return;
                    }
                    if (!A.isArrayDecl()) break block25;
                    TypeDecl V = ((ArrayDecl)A).componentType();
                    if (!V.isReferenceType()) break block22;
                    this.convertibleTo(V, U);
                    break block22;
                }
                if (!A.isTypeVariable()) break block22;
                TypeVariable t = (TypeVariable)A;
                int i = 0;
                while (i < t.getNumTypeBound()) {
                    TypeDecl typeBound = t.getTypeBound(i).type();
                    if (typeBound.isArrayDecl() && ((ArrayDecl)typeBound).componentType().isReferenceType()) {
                        TypeDecl V = ((ArrayDecl)typeBound).componentType();
                        this.convertibleTo(V, U);
                    }
                    ++i;
                }
                break block22;
            }
            if (F instanceof ParTypeDecl && !F.isRawType()) {
                Iterator iter = Constraints.parameterizedSupertypes(A).iterator();
                while (iter.hasNext()) {
                    ParTypeDecl PF = (ParTypeDecl)((Object)F);
                    ParTypeDecl PA = (ParTypeDecl)iter.next();
                    if (PF.genericDecl() != PA.genericDecl()) continue;
                    if (A.isRawType()) {
                        this.rawAccess = true;
                        continue;
                    }
                    int i = 0;
                    while (i < PF.getNumArgument()) {
                        TypeDecl T = PF.getArgument(i).type();
                        if (T.involvesTypeParameters()) {
                            TypeDecl V;
                            TypeDecl S;
                            TypeDecl U;
                            if (!T.isWildcard()) {
                                U = T;
                                TypeDecl V2 = PA.getArgument(i).type();
                                this.constraintEqual(V2, U);
                            } else if (T instanceof WildcardExtendsType) {
                                U = ((WildcardExtendsType)T).getAccess().type();
                                S = PA.getArgument(i).type();
                                if (!S.isWildcard()) {
                                    V = S;
                                    this.convertibleTo(V, U);
                                } else if (S instanceof WildcardExtendsType) {
                                    V = ((WildcardExtendsType)S).getAccess().type();
                                    this.convertibleTo(V, U);
                                }
                            } else if (T instanceof WildcardSuperType) {
                                U = ((WildcardSuperType)T).getAccess().type();
                                S = PA.getArgument(i).type();
                                if (!S.isWildcard()) {
                                    V = S;
                                    this.convertibleFrom(V, U);
                                } else if (S instanceof WildcardSuperType) {
                                    V = ((WildcardSuperType)S).getAccess().type();
                                    this.convertibleFrom(V, U);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void convertibleFrom(TypeDecl A, TypeDecl F) {
        if (!F.involvesTypeParameters()) {
            return;
        }
        if (A.isNull()) {
            return;
        }
        if (F instanceof TypeVariable) {
            if (this.typeVariables.contains(F)) {
                this.addSubtypeConstraint(F, A);
            }
        } else if (F.isArrayDecl()) {
            TypeDecl U = ((ArrayDecl)F).componentType();
            if (A.isArrayDecl()) {
                TypeDecl V = ((ArrayDecl)A).componentType();
                this.convertibleFrom(V, U);
            } else if (A.isTypeVariable()) {
                TypeVariable t = (TypeVariable)A;
                int i = 0;
                while (i < t.getNumTypeBound()) {
                    TypeDecl typeBound = t.getTypeBound(i).type();
                    if (typeBound.isArrayDecl() && ((ArrayDecl)typeBound).componentType().isReferenceType()) {
                        TypeDecl V = ((ArrayDecl)typeBound).componentType();
                        this.convertibleFrom(V, U);
                    }
                    ++i;
                }
            }
        } else if (F instanceof ParTypeDecl && !F.isRawType() && A instanceof ParTypeDecl && !A.isRawType()) {
            ParTypeDecl PF = (ParTypeDecl)((Object)F);
            ParTypeDecl PA = (ParTypeDecl)((Object)A);
            TypeDecl G = PF.genericDecl();
            TypeDecl H = PA.genericDecl();
            int i = 0;
            while (i < PF.getNumArgument()) {
                TypeDecl T = PF.getArgument(i).type();
                if (T.involvesTypeParameters()) {
                    int j;
                    ArrayList<TypeDecl> list;
                    TypeDecl W;
                    TypeDecl X;
                    TypeDecl U;
                    if (!T.isWildcard()) {
                        U = T;
                        if (G.instanceOf(H)) {
                            if (H != G) {
                                for (TypeDecl V : Constraints.parameterizedSupertypes(F)) {
                                    if (V.isRawType() || ((ParTypeDecl)((Object)V)).genericDecl() != H || !F.instanceOf(V)) continue;
                                    this.convertibleFrom(A, V);
                                }
                            } else if (PF.getNumArgument() == PA.getNumArgument()) {
                                X = PA.getArgument(i).type();
                                if (!X.isWildcard()) {
                                    W = X;
                                    this.constraintEqual(W, U);
                                } else if (X instanceof WildcardExtendsType) {
                                    W = ((WildcardExtendsType)X).getAccess().type();
                                    this.convertibleFrom(W, U);
                                } else if (X instanceof WildcardSuperType) {
                                    W = ((WildcardSuperType)X).getAccess().type();
                                    this.convertibleTo(W, U);
                                }
                            }
                        }
                    } else if (T instanceof WildcardExtendsType) {
                        U = ((WildcardExtendsType)T).getAccess().type();
                        if (G.instanceOf(H)) {
                            if (H != G) {
                                for (TypeDecl V : Constraints.parameterizedSupertypes(F)) {
                                    if (V.isRawType() || ((ParTypeDecl)((Object)V)).genericDecl() != H) continue;
                                    list = new ArrayList<TypeDecl>();
                                    j = 0;
                                    while (j < ((ParTypeDecl)((Object)V)).getNumArgument()) {
                                        list.add(((ParTypeDecl)((Object)V)).getArgument(j).type().asWildcardExtends());
                                        ++j;
                                    }
                                    V = ((GenericTypeDecl)((Object)H)).lookupParTypeDecl(list);
                                    this.convertibleFrom(A, V);
                                }
                            } else if (PF.getNumArgument() == PA.getNumArgument() && (X = PA.getArgument(i).type()) instanceof WildcardExtendsType) {
                                W = ((WildcardExtendsType)X).getAccess().type();
                                this.convertibleFrom(W, U);
                            }
                        }
                    } else if (T instanceof WildcardSuperType) {
                        U = ((WildcardSuperType)T).getAccess().type();
                        if (G.instanceOf(H)) {
                            if (H != G) {
                                for (TypeDecl V : Constraints.parameterizedSupertypes(F)) {
                                    if (V.isRawType() || ((ParTypeDecl)((Object)V)).genericDecl() != H) continue;
                                    list = new ArrayList();
                                    j = 0;
                                    while (j < ((ParTypeDecl)((Object)V)).getNumArgument()) {
                                        list.add(((ParTypeDecl)((Object)V)).getArgument(j).type().asWildcardExtends());
                                        ++j;
                                    }
                                    V = ((GenericTypeDecl)((Object)H)).lookupParTypeDecl(list);
                                    this.convertibleFrom(A, V);
                                }
                            } else if (PF.getNumArgument() == PA.getNumArgument() && (X = PA.getArgument(i).type()) instanceof WildcardSuperType) {
                                W = ((WildcardSuperType)X).getAccess().type();
                                this.convertibleTo(W, U);
                            }
                        }
                    }
                }
                ++i;
            }
        } else if (F.isRawType()) {
            this.rawAccess = true;
        }
    }

    public void constraintEqual(TypeDecl A, TypeDecl F) {
        block18: {
            block19: {
                TypeDecl U;
                block20: {
                    block17: {
                        if (!F.involvesTypeParameters()) {
                            return;
                        }
                        if (A.isNull()) {
                            return;
                        }
                        if (!(F instanceof TypeVariable)) break block17;
                        if (!this.typeVariables.contains(F)) break block18;
                        this.addEqualConstraint(F, A);
                        break block18;
                    }
                    if (!F.isArrayDecl()) break block19;
                    U = ((ArrayDecl)F).componentType();
                    if (!A.isArrayDecl()) break block20;
                    TypeDecl V = ((ArrayDecl)A).componentType();
                    this.constraintEqual(V, U);
                    break block18;
                }
                if (!A.isTypeVariable()) break block18;
                TypeVariable t = (TypeVariable)A;
                int i = 0;
                while (i < t.getNumTypeBound()) {
                    TypeDecl typeBound = t.getTypeBound(i).type();
                    if (typeBound.isArrayDecl() && ((ArrayDecl)typeBound).componentType().isReferenceType()) {
                        TypeDecl V = ((ArrayDecl)typeBound).componentType();
                        this.constraintEqual(V, U);
                    }
                    ++i;
                }
                break block18;
            }
            if (F instanceof ParTypeDecl && !F.isRawType() && A instanceof ParTypeDecl) {
                ParTypeDecl PF = (ParTypeDecl)((Object)F);
                ParTypeDecl PA = (ParTypeDecl)((Object)A);
                if (PF.genericDecl() == PA.genericDecl()) {
                    if (A.isRawType()) {
                        this.rawAccess = true;
                    } else {
                        int i = 0;
                        while (i < PF.getNumArgument()) {
                            TypeDecl T = PF.getArgument(i).type();
                            if (T.involvesTypeParameters()) {
                                TypeDecl V;
                                TypeDecl S;
                                TypeDecl U;
                                if (!T.isWildcard()) {
                                    U = T;
                                    TypeDecl V2 = PA.getArgument(i).type();
                                    this.constraintEqual(V2, U);
                                } else if (T instanceof WildcardExtendsType) {
                                    U = ((WildcardExtendsType)T).getAccess().type();
                                    S = PA.getArgument(i).type();
                                    if (S instanceof WildcardExtendsType) {
                                        V = ((WildcardExtendsType)S).getAccess().type();
                                        this.constraintEqual(V, U);
                                    }
                                } else if (T instanceof WildcardSuperType) {
                                    U = ((WildcardSuperType)T).getAccess().type();
                                    S = PA.getArgument(i).type();
                                    if (S instanceof WildcardSuperType) {
                                        V = ((WildcardSuperType)S).getAccess().type();
                                        this.constraintEqual(V, U);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }

    static class ConstraintSet {
        public Collection supertypeConstraints = new HashSet(4);
        public Collection subtypeConstraints = new HashSet(4);
        public Collection equaltypeConstraints = new HashSet(4);
        public TypeDecl typeArgument;

        ConstraintSet() {
        }
    }
}

