/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.Attribute;
import AST.Block;
import AST.BodyDecl;
import AST.ClassDecl;
import AST.CodeAttribute;
import AST.CodeGeneration;
import AST.CompilationUnit;
import AST.ConstantPool;
import AST.ConstructorAccess;
import AST.ConstructorDeclSubstituted;
import AST.ExceptionHolder;
import AST.ExceptionsAttribute;
import AST.Expr;
import AST.ExprStmt;
import AST.FieldDeclaration;
import AST.InstanceInitializer;
import AST.List;
import AST.MethodDecl;
import AST.Modifier;
import AST.Modifiers;
import AST.NameType;
import AST.Opt;
import AST.ParameterDeclaration;
import AST.Parameterization;
import AST.PartialObject;
import AST.ReturnStmt;
import AST.SimpleSet;
import AST.Stmt;
import AST.SuperConstructorAccess;
import AST.SyntheticAttribute;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.VarAccess;
import AST.Variable;
import beaver.Symbol;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jpe.Environment;
import jpe.Util;

public class ConstructorDecl
extends BodyDecl
implements Cloneable,
ExceptionHolder {
    protected boolean addEnclosingVariables = true;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected Map accessibleFrom_TypeDecl_values;
    protected Map throwsException_TypeDecl_values;
    protected boolean name_computed = false;
    protected String name_value;
    protected boolean signature_computed = false;
    protected String signature_value;
    protected Map sameSignature_ConstructorDecl_values;
    protected Map moreSpecificThan_ConstructorDecl_values;
    protected Map parameterDeclaration_String_values;
    protected Map circularThisInvocation_ConstructorDecl_values;
    protected boolean descName_computed = false;
    protected String descName_value;
    protected Map bytecodes_ConstantPool_values;
    protected boolean flags_computed = false;
    protected int flags_value;
    protected boolean localNumOfFirstParameter_computed = false;
    protected int localNumOfFirstParameter_value;
    protected boolean offsetFirstEnclosingVariable_computed = false;
    protected int offsetFirstEnclosingVariable_value;
    protected boolean sourceConstructorDecl_computed = false;
    protected ConstructorDecl sourceConstructorDecl_value;
    protected Map handlesException_TypeDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.accessibleFrom_TypeDecl_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.throwsException_TypeDecl_values = null;
        this.name_computed = false;
        this.name_value = null;
        this.signature_computed = false;
        this.signature_value = null;
        this.sameSignature_ConstructorDecl_values = null;
        this.moreSpecificThan_ConstructorDecl_values = null;
        this.parameterDeclaration_String_values = null;
        this.circularThisInvocation_ConstructorDecl_values = null;
        this.attributes_computed = false;
        this.attributes_value = null;
        this.descName_computed = false;
        this.descName_value = null;
        this.bytecodes_ConstantPool_values = null;
        this.flags_computed = false;
        this.localNumOfFirstParameter_computed = false;
        this.offsetFirstEnclosingVariable_computed = false;
        this.sourceConstructorDecl_computed = false;
        this.sourceConstructorDecl_value = null;
        this.handlesException_TypeDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ConstructorDecl clone() throws CloneNotSupportedException {
        ConstructorDecl node = (ConstructorDecl)super.clone();
        node.accessibleFrom_TypeDecl_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.throwsException_TypeDecl_values = null;
        node.name_computed = false;
        node.name_value = null;
        node.signature_computed = false;
        node.signature_value = null;
        node.sameSignature_ConstructorDecl_values = null;
        node.moreSpecificThan_ConstructorDecl_values = null;
        node.parameterDeclaration_String_values = null;
        node.circularThisInvocation_ConstructorDecl_values = null;
        node.attributes_computed = false;
        node.attributes_value = null;
        node.descName_computed = false;
        node.descName_value = null;
        node.bytecodes_ConstantPool_values = null;
        node.flags_computed = false;
        node.localNumOfFirstParameter_computed = false;
        node.offsetFirstEnclosingVariable_computed = false;
        node.sourceConstructorDecl_computed = false;
        node.sourceConstructorDecl_value = null;
        node.handlesException_TypeDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ConstructorDecl copy() {
        try {
            ConstructorDecl node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ConstructorDecl fullCopy() {
        ConstructorDecl res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public boolean applicable(List argList) {
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            TypeDecl parameter;
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (!arg.instanceOf(parameter = this.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        if (!this.hostType().name().equals(this.name())) {
            this.error("constructor " + this.name() + " does not have the same name as the simple name of the host class " + this.hostType().name());
        }
        if (this.hostType().lookupConstructor(this) != this) {
            this.error("constructor with signature " + this.signature() + " is multiply declared in type " + this.hostType().typeName());
        }
        if (this.circularThisInvocation(this)) {
            this.error("The constructor " + this.signature() + " may not directly or indirectly invoke itself");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        int i;
        s.append(this.indent());
        this.getModifiers().toString(s);
        s.append(String.valueOf(this.name()) + "(");
        if (this.getNumParameter() > 0) {
            this.getParameter(0).toString(s);
            i = 1;
            while (i < this.getNumParameter()) {
                s.append(", ");
                this.getParameter(i).toString(s);
                ++i;
            }
        }
        s.append(")");
        if (this.getNumException() > 0) {
            s.append(" throws ");
            this.getException(0).toString(s);
            i = 1;
            while (i < this.getNumException()) {
                s.append(", ");
                this.getException(i).toString(s);
                ++i;
            }
        }
        s.append(" {");
        if (this.hasConstructorInvocation()) {
            this.getConstructorInvocation().toString(s);
        }
        i = 0;
        while (i < this.getBlock().getNumStmt()) {
            this.getBlock().getStmt(i).toString(s);
            ++i;
        }
        s.append(this.indent());
        s.append("}");
    }

    @Override
    public void typeCheck() {
        TypeDecl exceptionType = this.typeThrowable();
        int i = 0;
        while (i < this.getNumException()) {
            TypeDecl typeDecl = this.getException(i).type();
            if (!typeDecl.instanceOf(exceptionType)) {
                this.error(String.valueOf(this.signature()) + " throws non throwable type " + typeDecl.fullName());
            }
            ++i;
        }
    }

    public void emitInvokeConstructor(CodeGeneration gen) {
        int size = -1;
        int i = 0;
        while (i < this.getNumParameter()) {
            size -= this.getParameter(i).type().variableSize();
            ++i;
        }
        if (this.hostType().needsEnclosing()) {
            --size;
        }
        if (this.hostType().needsSuperEnclosing()) {
            --size;
        }
        String classname = this.hostType().constantPoolName();
        String desc = this.descName();
        String name = "<init>";
        int index = gen.constantPool().addMethodref(classname, name, desc);
        gen.emit((byte)-73, size).add2(index);
    }

    private void generateBytecodes(CodeGeneration gen) {
        int label = gen.variableScopeLabel();
        gen.addLocalVariableEntryAtCurrentPC("this", this.hostType().typeDescriptor(), 0, label);
        int i = 0;
        while (i < this.getNumParameter()) {
            ParameterDeclaration p = this.getParameter(i);
            gen.addLocalVariableEntryAtCurrentPC(p.name(), p.type().typeDescriptor(), p.localNum(), label);
            ++i;
        }
        this.createBCode(gen);
        gen.emitReturn();
        gen.addVariableScopeLabel(label);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        try {
            boolean needsInit = true;
            if (this.hasConstructorInvocation()) {
                ExprStmt exprStmt;
                Expr expr;
                this.getConstructorInvocation().createBCode(gen);
                Stmt stmt = this.getConstructorInvocation();
                if (stmt instanceof ExprStmt && !(expr = (exprStmt = (ExprStmt)stmt).getExpr()).isSuperConstructorAccess()) {
                    needsInit = false;
                }
            }
            if (this.needsEnclosing()) {
                gen.emitLoadReference(0);
                gen.emitLoadReference(1);
                String classname = this.hostType().constantPoolName();
                String desc = this.enclosing().typeDescriptor();
                String name = "this$0";
                int index = gen.constantPool().addFieldref(classname, name, desc);
                gen.emit((byte)-75, -2).add2(index);
            }
            int localIndex = this.offsetFirstEnclosingVariable();
            for (Variable v : this.hostType().enclosingVariables()) {
                gen.emitLoadReference(0);
                v.type().emitLoadLocal(gen, localIndex);
                String classname = this.hostType().constantPoolName();
                String desc = v.type().typeDescriptor();
                String name = "val$" + v.name();
                int index = gen.constantPool().addFieldref(classname, name, desc);
                gen.emit((byte)-75, -1 - v.type().variableSize()).add2(index);
                localIndex += v.type().variableSize();
            }
            if (needsInit) {
                TypeDecl typeDecl = this.hostType();
                int i = 0;
                while (i < typeDecl.getNumBodyDecl()) {
                    BodyDecl b = typeDecl.getBodyDecl(i);
                    if (b instanceof FieldDeclaration && b.isBytecodeField() && b.generate()) {
                        FieldDeclaration f = (FieldDeclaration)b;
                        if (!f.isStatic() && f.hasInit()) {
                            gen.emit((byte)42);
                            f.getInit().createBCode(gen);
                            f.getInit().type().emitAssignConvTo(gen, f.type());
                            f.emitStoreField(gen, this.hostType());
                        }
                    } else if (b instanceof InstanceInitializer) {
                        b.createBCode(gen);
                    }
                    ++i;
                }
            }
            gen.maxLocals = Math.max(gen.maxLocals, this.getBlock().localNum());
            this.getBlock().createBCode(gen);
        }
        catch (Error e) {
            System.err.println(String.valueOf(this.hostType().typeName()) + ": " + this);
            throw e;
        }
    }

    @Override
    public void generateMethod(DataOutputStream out, ConstantPool cp) throws IOException {
        out.writeChar(this.flags());
        out.writeChar(cp.addUtf8("<init>"));
        out.writeChar(cp.addUtf8(this.descName()));
        out.writeChar(this.attributes().size());
        Iterator itera = this.attributes().iterator();
        while (itera.hasNext()) {
            ((Attribute)itera.next()).emit(out);
        }
    }

    @Override
    public void touchMethod(ConstantPool cp) {
        cp.addUtf8("<init>");
        cp.addUtf8(this.descName());
        this.attributes();
    }

    @Override
    public boolean clear() {
        this.getBlock().clear();
        this.setBlock(new Block(new List<Stmt>()));
        this.bytecodes_ConstantPool_values = null;
        return false;
    }

    public void addEnclosingVariables() {
        if (!this.addEnclosingVariables) {
            return;
        }
        this.addEnclosingVariables = false;
        this.hostType().addEnclosingVariables();
        for (Variable v : this.hostType().enclosingVariables()) {
            this.getParameterList().add(new ParameterDeclaration(v.type(), "val$" + v.name()));
        }
    }

    public ConstructorDecl createAccessor() {
        ConstructorDecl c = (ConstructorDecl)this.hostType().getAccessor(this, "constructor");
        if (c != null) {
            return c;
        }
        this.addEnclosingVariables();
        Modifiers modifiers = new Modifiers(new List<Modifier>());
        modifiers.addModifier(new Modifier("synthetic"));
        modifiers.addModifier(new Modifier("public"));
        List parameters = this.createAccessorParameters();
        List<Access> exceptionList = new List<Access>();
        int i = 0;
        while (i < this.getNumException()) {
            exceptionList.add(this.getException(i).type().createQualifiedAccess());
            ++i;
        }
        List<Expr> args = new List<Expr>();
        int i2 = 0;
        while (i2 < parameters.getNumChildNoTransform() - 1) {
            args.add(new VarAccess(((ParameterDeclaration)parameters.getChildNoTransform(i2)).name()));
            ++i2;
        }
        ConstructorAccess access = new ConstructorAccess("this", args);
        access.addEnclosingVariables = false;
        c = new ConstructorDecl(modifiers, this.name(), (List<ParameterDeclaration>)parameters, exceptionList, new Opt<Stmt>(new ExprStmt(access)), new Block(new List<ReturnStmt>().add(new ReturnStmt(new Opt<Expr>()))));
        c = this.hostType().addConstructor(c);
        c.addEnclosingVariables = false;
        this.hostType().addAccessor(this, "constructor", c);
        return c;
    }

    protected List createAccessorParameters() {
        List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
        int i = 0;
        while (i < this.getNumParameter()) {
            parameters.add(new ParameterDeclaration(this.getParameter(i).type(), this.getParameter(i).name()));
            ++i;
        }
        parameters.add(new ParameterDeclaration(this.createAnonymousJavaTypeDecl().createBoundAccess(), "p" + this.getNumParameter()));
        return parameters;
    }

    protected TypeDecl createAnonymousJavaTypeDecl() {
        ClassDecl classDecl = new ClassDecl(new Modifiers(new List<Modifier>().add(new Modifier("synthetic"))), "" + this.hostType().nextAnonymousIndex(), new Opt<Access>(), new List<Access>(), new List<BodyDecl>());
        classDecl = this.hostType().addMemberClass(classDecl);
        this.hostType().addNestedType(classDecl);
        return classDecl;
    }

    @Override
    public void transformation() {
        this.addEnclosingVariables();
        super.transformation();
    }

    @Override
    protected void transformEnumConstructors() {
        if (!this.hasConstructorInvocation()) {
            this.setConstructorInvocation(new ExprStmt(new SuperConstructorAccess("super", new List<Expr>())));
        }
        super.transformEnumConstructors();
        this.getParameterList().insertChild(new ParameterDeclaration(new TypeAccess("java.lang", "String"), "@p0"), 0);
        this.getParameterList().insertChild(new ParameterDeclaration(new TypeAccess("int"), "@p1"), 1);
    }

    @Override
    public BodyDecl p(Parameterization parTypeDecl) {
        ConstructorDeclSubstituted c = new ConstructorDeclSubstituted(this.getModifiers().fullCopy(), this.getID(), (List<ParameterDeclaration>)this.getParameterList().substitute(parTypeDecl), (List<Access>)this.getExceptionList().substitute(parTypeDecl), new Opt<Stmt>(), new Block(), this);
        return c;
    }

    public void specialiseClass(List<Expr> args, java.util.List<Integer> staticIndices, String newClassName) {
        TypeDecl origClass = this.hostType();
        ClassDecl c = new ClassDecl(origClass.getModifiers(), newClassName, new Opt<Access>(new TypeAccess(origClass.getID())), new List<Access>(), new List<BodyDecl>());
        this.getProgram().generatedClasses.put(newClassName, c);
        PartialObject partObj = new PartialObject();
        partObj.setTypeDecl(c);
        c.addConstructor(this.specialise(args, staticIndices, newClassName, partObj));
        Iterator i = origClass.methodsIterator();
        while (i.hasNext()) {
            Modifiers mods;
            MethodDecl m = (MethodDecl)i.next();
            if (!m.hasSource() | !m.hasBlock() || (mods = m.getModifiers()).isStatic() | mods.isFinal() | mods.isNative()) continue;
            Environment env = new Environment();
            env.inStack(partObj);
            MethodDecl newm = new MethodDecl(m.getModifiers(), m.getTypeAccess(), m.name(), m.getParameterList(), m.getExceptionList(), new Opt<Block>(m.getBlock().pe(env)));
            env.outStack();
            c.addMemberMethod(newm);
        }
        CompilationUnit cuOld = origClass.compilationUnit();
        CompilationUnit cuNew = new CompilationUnit(cuOld.getPackageDecl(), cuOld.getImportDeclList(), new List<ClassDecl>().add(c));
        cuNew.setFromSource(true);
        cuNew.setPathName(Util.changePathName(cuOld.pathName(), newClassName));
        this.getProgram().addCompilationUnit(cuNew);
    }

    public ConstructorDecl specialise(List<Expr> args, java.util.List<Integer> staticIndices, String newClassName, PartialObject partialObj) {
        Environment env = new Environment();
        env.inStack(partialObj);
        ConstructorDecl cons = new ConstructorDecl(this.getModifiers(), newClassName, new List<ParameterDeclaration>(), this.getExceptionList(), new Opt<Stmt>(), new Block());
        int i = 0;
        while (i < args.getNumChild()) {
            ParameterDeclaration p = this.getParameter(i);
            if (staticIndices.contains(i)) {
                Expr val = (Expr)args.getChild(i);
                env.add(p, val);
            } else {
                cons.addParameter(p.fullCopy());
            }
            ++i;
        }
        this.inlineSuperConstructors(cons.getBlock(), env);
        cons.setBlock(this.getBlock().pe(env, cons.getBlock()));
        ((ClassDecl)this.hostType()).addZeroArgConstructor();
        return cons;
    }

    public void inlineSuperConstructors(Block destBlock, Environment env) {
        if (!this.hasConstructorInvocation()) {
            return;
        }
        ExprStmt s = (ExprStmt)this.getConstructorInvocation();
        Expr e = s.getExpr();
        if (e instanceof ConstructorAccess) {
            ConstructorAccess sup = (ConstructorAccess)e;
            ConstructorDecl c = sup.decl();
            c.inlineSuperConstructors(destBlock, env);
            Block b = c.getBlock();
            int i = 0;
            while (i < b.getNumStmt()) {
                destBlock.addStmt(b.getStmt(i).pe(env));
                ++i;
            }
        } else {
            throw new Error("Unsupported Expression type " + e.getClass() + " for constructor invocation in Class " + this.getID());
        }
    }

    public ConstructorDecl() {
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new Opt(), 3);
    }

    public ConstructorDecl(Modifiers p0, String p1, List<ParameterDeclaration> p2, List<Access> p3, Opt<Stmt> p4, Block p5) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    public ConstructorDecl(Modifiers p0, Symbol p1, List<ParameterDeclaration> p2, List<Access> p3, Opt<Stmt> p4, Block p5) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setParameterList(List<ParameterDeclaration> list) {
        this.setChild(list, 1);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public ParameterDeclaration getParameter(int i) {
        return (ParameterDeclaration)this.getParameterList().getChild(i);
    }

    public void addParameter(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.parent == null || state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(ParameterDeclaration node, int i) {
        List<ParameterDeclaration> list = this.getParameterList();
        list.setChild(node, i);
    }

    public List<ParameterDeclaration> getParameters() {
        return this.getParameterList();
    }

    public List<ParameterDeclaration> getParametersNoTransform() {
        return this.getParameterListNoTransform();
    }

    public List<ParameterDeclaration> getParameterList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<ParameterDeclaration> getParameterListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setExceptionList(List<Access> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumException() {
        return this.getExceptionList().getNumChild();
    }

    @Override
    public Access getException(int i) {
        return (Access)this.getExceptionList().getChild(i);
    }

    public void addException(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getExceptionListNoTransform() : this.getExceptionList();
        list.addChild(node);
    }

    public void addExceptionNoTransform(Access node) {
        List<Access> list = this.getExceptionListNoTransform();
        list.addChild(node);
    }

    public void setException(Access node, int i) {
        List<Access> list = this.getExceptionList();
        list.setChild(node, i);
    }

    public List<Access> getExceptions() {
        return this.getExceptionList();
    }

    public List<Access> getExceptionsNoTransform() {
        return this.getExceptionListNoTransform();
    }

    public List<Access> getExceptionList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    public List<Access> getExceptionListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setConstructorInvocationOpt(Opt<Stmt> opt) {
        this.setChild(opt, 3);
    }

    public boolean hasConstructorInvocation() {
        return this.getConstructorInvocationOpt().getNumChild() != 0;
    }

    public Stmt getConstructorInvocation() {
        return (Stmt)this.getConstructorInvocationOpt().getChild(0);
    }

    public void setConstructorInvocation(Stmt node) {
        this.getConstructorInvocationOpt().setChild(node, 0);
    }

    public Opt<Stmt> getConstructorInvocationOpt() {
        return (Opt)this.getChild(3);
    }

    public Opt<Stmt> getConstructorInvocationOptNoTransform() {
        return (Opt)this.getChildNoTransform(3);
    }

    public void setBlock(Block node) {
        this.setChild(node, 4);
    }

    public Block getBlock() {
        return (Block)this.getChild(4);
    }

    public Block getBlockNoTransform() {
        return (Block)this.getChildNoTransform(4);
    }

    private boolean refined_ConstructorDecl_ConstructorDecl_moreSpecificThan_ConstructorDecl(ConstructorDecl m) {
        int i = 0;
        while (i < this.getNumParameter()) {
            if (!this.getParameter(i).type().instanceOf(m.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Collection refined_Attributes_ConstructorDecl_attributes() {
        ArrayList<Attribute> l = new ArrayList<Attribute>();
        l.add(new CodeAttribute(this.bytecodes(this.hostType().constantPool()), null));
        l.add(new ExceptionsAttribute(this.bytecodes(this.hostType().constantPool()), this));
        if (this.getModifiers().isSynthetic()) {
            l.add(new SyntheticAttribute(this.hostType().constantPool()));
        }
        return l;
    }

    public boolean accessibleFrom(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.accessibleFrom_TypeDecl_values == null) {
            this.accessibleFrom_TypeDecl_values = new HashMap(4);
        }
        if (this.accessibleFrom_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.accessibleFrom_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean accessibleFrom_TypeDecl_value = this.accessibleFrom_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.accessibleFrom_TypeDecl_values.put(_parameters, accessibleFrom_TypeDecl_value);
        }
        return accessibleFrom_TypeDecl_value;
    }

    private boolean accessibleFrom_compute(TypeDecl type) {
        if (!this.hostType().accessibleFrom(type)) {
            return false;
        }
        if (this.isPublic()) {
            return true;
        }
        if (this.isProtected()) {
            return true;
        }
        if (this.isPrivate()) {
            return this.hostType().topLevelType() == type.topLevelType();
        }
        return this.hostPackage().equals(type.hostPackage());
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getBlock().isDAafter(v) && this.getBlock().checkReturnDA(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getBlock().isDUafter(v) && this.getBlock().checkReturnDU(v);
    }

    public boolean throwsException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.throwsException_TypeDecl_values == null) {
            this.throwsException_TypeDecl_values = new HashMap(4);
        }
        if (this.throwsException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.throwsException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean throwsException_TypeDecl_value = this.throwsException_compute(exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.throwsException_TypeDecl_values.put(_parameters, throwsException_TypeDecl_value);
        }
        return throwsException_TypeDecl_value;
    }

    private boolean throwsException_compute(TypeDecl exceptionType) {
        int i = 0;
        while (i < this.getNumException()) {
            if (exceptionType.instanceOf(this.getException(i).type())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String name() {
        if (this.name_computed) {
            return this.name_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.name_value = this.name_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.name_computed = true;
        }
        return this.name_value;
    }

    private String name_compute() {
        return this.getID();
    }

    public String signature() {
        if (this.signature_computed) {
            return this.signature_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.signature_value = this.signature_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.signature_computed = true;
        }
        return this.signature_value;
    }

    private String signature_compute() {
        StringBuffer s = new StringBuffer();
        s.append(String.valueOf(this.name()) + "(");
        int i = 0;
        while (i < this.getNumParameter()) {
            s.append(this.getParameter(i));
            if (i != this.getNumParameter() - 1) {
                s.append(", ");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    public boolean sameSignature(ConstructorDecl c) {
        ConstructorDecl _parameters = c;
        if (this.sameSignature_ConstructorDecl_values == null) {
            this.sameSignature_ConstructorDecl_values = new HashMap(4);
        }
        if (this.sameSignature_ConstructorDecl_values.containsKey(_parameters)) {
            return (Boolean)this.sameSignature_ConstructorDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean sameSignature_ConstructorDecl_value = this.sameSignature_compute(c);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sameSignature_ConstructorDecl_values.put(_parameters, sameSignature_ConstructorDecl_value);
        }
        return sameSignature_ConstructorDecl_value;
    }

    private boolean sameSignature_compute(ConstructorDecl c) {
        if (!this.name().equals(c.name())) {
            return false;
        }
        if (c.getNumParameter() != this.getNumParameter()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            if (!c.getParameter(i).type().equals(this.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean moreSpecificThan(ConstructorDecl m) {
        ConstructorDecl _parameters = m;
        if (this.moreSpecificThan_ConstructorDecl_values == null) {
            this.moreSpecificThan_ConstructorDecl_values = new HashMap(4);
        }
        if (this.moreSpecificThan_ConstructorDecl_values.containsKey(_parameters)) {
            return (Boolean)this.moreSpecificThan_ConstructorDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean moreSpecificThan_ConstructorDecl_value = this.moreSpecificThan_compute(m);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.moreSpecificThan_ConstructorDecl_values.put(_parameters, moreSpecificThan_ConstructorDecl_value);
        }
        return moreSpecificThan_ConstructorDecl_value;
    }

    private boolean moreSpecificThan_compute(ConstructorDecl m) {
        if (!this.isVariableArity() && !m.isVariableArity()) {
            return this.refined_ConstructorDecl_ConstructorDecl_moreSpecificThan_ConstructorDecl(m);
        }
        int num = Math.max(this.getNumParameter(), m.getNumParameter());
        int i = 0;
        while (i < num) {
            TypeDecl t2;
            TypeDecl t1 = i < this.getNumParameter() - 1 ? this.getParameter(i).type() : this.getParameter(this.getNumParameter() - 1).type().componentType();
            TypeDecl typeDecl = t2 = i < m.getNumParameter() - 1 ? m.getParameter(i).type() : m.getParameter(m.getNumParameter() - 1).type().componentType();
            if (!t1.instanceOf(t2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SimpleSet parameterDeclaration(String name) {
        String _parameters = name;
        if (this.parameterDeclaration_String_values == null) {
            this.parameterDeclaration_String_values = new HashMap(4);
        }
        if (this.parameterDeclaration_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.parameterDeclaration_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet parameterDeclaration_String_value = this.parameterDeclaration_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.parameterDeclaration_String_values.put(_parameters, parameterDeclaration_String_value);
        }
        return parameterDeclaration_String_value;
    }

    private SimpleSet parameterDeclaration_compute(String name) {
        int i = 0;
        while (i < this.getNumParameter()) {
            if (this.getParameter(i).name().equals(name)) {
                return this.getParameter(i);
            }
            ++i;
        }
        return SimpleSet.emptySet;
    }

    public boolean isSynthetic() {
        ASTNode$State state = this.state();
        boolean isSynthetic_value = this.isSynthetic_compute();
        return isSynthetic_value;
    }

    private boolean isSynthetic_compute() {
        return this.getModifiers().isSynthetic();
    }

    public boolean isPublic() {
        ASTNode$State state = this.state();
        boolean isPublic_value = this.isPublic_compute();
        return isPublic_value;
    }

    private boolean isPublic_compute() {
        return this.getModifiers().isPublic();
    }

    public boolean isPrivate() {
        ASTNode$State state = this.state();
        boolean isPrivate_value = this.isPrivate_compute();
        return isPrivate_value;
    }

    private boolean isPrivate_compute() {
        return this.getModifiers().isPrivate();
    }

    public boolean isProtected() {
        ASTNode$State state = this.state();
        boolean isProtected_value = this.isProtected_compute();
        return isProtected_value;
    }

    private boolean isProtected_compute() {
        return this.getModifiers().isProtected();
    }

    public boolean circularThisInvocation(ConstructorDecl decl) {
        ConstructorDecl _parameters = decl;
        if (this.circularThisInvocation_ConstructorDecl_values == null) {
            this.circularThisInvocation_ConstructorDecl_values = new HashMap(4);
        }
        if (this.circularThisInvocation_ConstructorDecl_values.containsKey(_parameters)) {
            return (Boolean)this.circularThisInvocation_ConstructorDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean circularThisInvocation_ConstructorDecl_value = this.circularThisInvocation_compute(decl);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.circularThisInvocation_ConstructorDecl_values.put(_parameters, circularThisInvocation_ConstructorDecl_value);
        }
        return circularThisInvocation_ConstructorDecl_value;
    }

    private boolean circularThisInvocation_compute(ConstructorDecl decl) {
        Expr e;
        if (this.hasConstructorInvocation() && (e = ((ExprStmt)this.getConstructorInvocation()).getExpr()) instanceof ConstructorAccess) {
            ConstructorDecl constructorDecl = ((ConstructorAccess)e).decl();
            if (constructorDecl == decl) {
                return true;
            }
            return constructorDecl.circularThisInvocation(decl);
        }
        return false;
    }

    public TypeDecl type() {
        ASTNode$State state = this.state();
        TypeDecl type_value = this.type_compute();
        return type_value;
    }

    private TypeDecl type_compute() {
        return this.unknownType();
    }

    @Override
    public boolean isVoid() {
        ASTNode$State state = this.state();
        boolean isVoid_value = this.isVoid_compute();
        return isVoid_value;
    }

    private boolean isVoid_compute() {
        return true;
    }

    @Override
    public Collection attributes() {
        if (this.attributes_computed) {
            return this.attributes_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.attributes_value = this.attributes_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.attributes_computed = true;
        }
        return this.attributes_value;
    }

    private Collection attributes_compute() {
        Collection c = this.refined_Attributes_ConstructorDecl_attributes();
        this.getModifiers().addRuntimeVisibleAnnotationsAttribute(c);
        this.getModifiers().addRuntimeInvisibleAnnotationsAttribute(c);
        return c;
    }

    public String descName() {
        if (this.descName_computed) {
            return this.descName_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.descName_value = this.descName_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.descName_computed = true;
        }
        return this.descName_value;
    }

    private String descName_compute() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        if (this.needsEnclosing()) {
            b.append(this.enclosing().typeDescriptor());
        }
        if (this.needsSuperEnclosing()) {
            b.append(this.superEnclosing().typeDescriptor());
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            b.append(this.getParameter(i).type().typeDescriptor());
            ++i;
        }
        b.append(")V");
        return b.toString();
    }

    public CodeGeneration bytecodes(ConstantPool constantPool) {
        ConstantPool _parameters = constantPool;
        if (this.bytecodes_ConstantPool_values == null) {
            this.bytecodes_ConstantPool_values = new HashMap(4);
        }
        if (this.bytecodes_ConstantPool_values.containsKey(_parameters)) {
            return (CodeGeneration)this.bytecodes_ConstantPool_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        CodeGeneration bytecodes_ConstantPool_value = this.bytecodes_compute(constantPool);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.bytecodes_ConstantPool_values.put(_parameters, bytecodes_ConstantPool_value);
        }
        return bytecodes_ConstantPool_value;
    }

    private CodeGeneration bytecodes_compute(ConstantPool constantPool) {
        CodeGeneration gen = new CodeGeneration(constantPool);
        this.generateBytecodes(gen);
        if (!gen.numberFormatError()) {
            return gen;
        }
        gen = new CodeGeneration(constantPool, true);
        this.generateBytecodes(gen);
        if (!gen.numberFormatError()) {
            return gen;
        }
        throw new Error("Could not generate code for " + this.signature() + " in " + this.hostType().typeName());
    }

    public int flags() {
        if (this.flags_computed) {
            return this.flags_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.flags_value = this.flags_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.flags_computed = true;
        }
        return this.flags_value;
    }

    private int flags_compute() {
        int res = 0;
        if (this.isPublic()) {
            res |= 1;
        }
        if (this.isPrivate()) {
            res |= 2;
        }
        if (this.isProtected()) {
            res |= 4;
        }
        return res;
    }

    @Override
    public boolean isBytecodeMethod() {
        ASTNode$State state = this.state();
        boolean isBytecodeMethod_value = this.isBytecodeMethod_compute();
        return isBytecodeMethod_value;
    }

    private boolean isBytecodeMethod_compute() {
        return true;
    }

    @Override
    public boolean flush() {
        ASTNode$State state = this.state();
        boolean flush_value = this.flush_compute();
        return flush_value;
    }

    private boolean flush_compute() {
        return false;
    }

    public boolean needsEnclosing() {
        ASTNode$State state = this.state();
        boolean needsEnclosing_value = this.needsEnclosing_compute();
        return needsEnclosing_value;
    }

    private boolean needsEnclosing_compute() {
        return this.hostType().needsEnclosing();
    }

    public boolean needsSuperEnclosing() {
        ASTNode$State state = this.state();
        boolean needsSuperEnclosing_value = this.needsSuperEnclosing_compute();
        return needsSuperEnclosing_value;
    }

    private boolean needsSuperEnclosing_compute() {
        return this.hostType().needsSuperEnclosing();
    }

    public TypeDecl enclosing() {
        ASTNode$State state = this.state();
        TypeDecl enclosing_value = this.enclosing_compute();
        return enclosing_value;
    }

    private TypeDecl enclosing_compute() {
        return this.hostType().enclosing();
    }

    public TypeDecl superEnclosing() {
        ASTNode$State state = this.state();
        TypeDecl superEnclosing_value = this.superEnclosing_compute();
        return superEnclosing_value;
    }

    private TypeDecl superEnclosing_compute() {
        return this.hostType().superEnclosing();
    }

    public int localNumOfFirstParameter() {
        if (this.localNumOfFirstParameter_computed) {
            return this.localNumOfFirstParameter_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.localNumOfFirstParameter_value = this.localNumOfFirstParameter_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.localNumOfFirstParameter_computed = true;
        }
        return this.localNumOfFirstParameter_value;
    }

    private int localNumOfFirstParameter_compute() {
        int i = 1;
        if (this.hostType().needsEnclosing()) {
            ++i;
        }
        if (this.hostType().needsSuperEnclosing()) {
            ++i;
        }
        return i;
    }

    public int offsetFirstEnclosingVariable() {
        if (this.offsetFirstEnclosingVariable_computed) {
            return this.offsetFirstEnclosingVariable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.offsetFirstEnclosingVariable_value = this.offsetFirstEnclosingVariable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.offsetFirstEnclosingVariable_computed = true;
        }
        return this.offsetFirstEnclosingVariable_value;
    }

    private int offsetFirstEnclosingVariable_compute() {
        int localIndex = this.localNumOfFirstParameter();
        Collection vars = this.hostType().enclosingVariables();
        if (vars.isEmpty()) {
            return localIndex;
        }
        String name = "val$" + ((Variable)vars.iterator().next()).name();
        int i = 0;
        while (!this.getParameter(i).name().equals(name)) {
            localIndex += this.getParameter(i).type().variableSize();
            ++i;
        }
        return localIndex;
    }

    public int localIndexOfEnclosingVariable(Variable v) {
        ASTNode$State state = this.state();
        int localIndexOfEnclosingVariable_Variable_value = this.localIndexOfEnclosingVariable_compute(v);
        return localIndexOfEnclosingVariable_Variable_value;
    }

    private int localIndexOfEnclosingVariable_compute(Variable v) {
        int localIndex = this.offsetFirstEnclosingVariable();
        Iterator iter = this.hostType().enclosingVariables().iterator();
        Variable varDecl = (Variable)iter.next();
        while (varDecl != v && iter.hasNext()) {
            localIndex += varDecl.type().variableSize();
            varDecl = (Variable)iter.next();
        }
        return localIndex;
    }

    @Override
    public boolean hasAnnotationSuppressWarnings(String s) {
        ASTNode$State state = this.state();
        boolean hasAnnotationSuppressWarnings_String_value = this.hasAnnotationSuppressWarnings_compute(s);
        return hasAnnotationSuppressWarnings_String_value;
    }

    private boolean hasAnnotationSuppressWarnings_compute(String s) {
        return this.getModifiers().hasAnnotationSuppressWarnings(s);
    }

    @Override
    public boolean isDeprecated() {
        ASTNode$State state = this.state();
        boolean isDeprecated_value = this.isDeprecated_compute();
        return isDeprecated_value;
    }

    private boolean isDeprecated_compute() {
        return this.getModifiers().hasDeprecatedAnnotation();
    }

    public ConstructorDecl sourceConstructorDecl() {
        if (this.sourceConstructorDecl_computed) {
            return this.sourceConstructorDecl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sourceConstructorDecl_value = this.sourceConstructorDecl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sourceConstructorDecl_computed = true;
        }
        return this.sourceConstructorDecl_value;
    }

    private ConstructorDecl sourceConstructorDecl_compute() {
        return this;
    }

    public boolean applicableBySubtyping(List argList) {
        ASTNode$State state = this.state();
        boolean applicableBySubtyping_List_value = this.applicableBySubtyping_compute(argList);
        return applicableBySubtyping_List_value;
    }

    private boolean applicableBySubtyping_compute(List argList) {
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (!arg.instanceOf(this.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean applicableByMethodInvocationConversion(List argList) {
        ASTNode$State state = this.state();
        boolean applicableByMethodInvocationConversion_List_value = this.applicableByMethodInvocationConversion_compute(argList);
        return applicableByMethodInvocationConversion_List_value;
    }

    private boolean applicableByMethodInvocationConversion_compute(List argList) {
        if (this.getNumParameter() != argList.getNumChild()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            TypeDecl arg = ((Expr)argList.getChild(i)).type();
            if (!arg.methodInvocationConversionTo(this.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean applicableVariableArity(List argList) {
        ASTNode$State state = this.state();
        boolean applicableVariableArity_List_value = this.applicableVariableArity_compute(argList);
        return applicableVariableArity_List_value;
    }

    private boolean applicableVariableArity_compute(List argList) {
        TypeDecl arg;
        int i = 0;
        while (i < this.getNumParameter() - 1) {
            arg = ((Expr)argList.getChild(i)).type();
            if (!arg.methodInvocationConversionTo(this.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        i = this.getNumParameter() - 1;
        while (i < argList.getNumChild()) {
            arg = ((Expr)argList.getChild(i)).type();
            if (!arg.methodInvocationConversionTo(this.lastParameter().type().componentType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean potentiallyApplicable(List argList) {
        ASTNode$State state = this.state();
        boolean potentiallyApplicable_List_value = this.potentiallyApplicable_compute(argList);
        return potentiallyApplicable_List_value;
    }

    private boolean potentiallyApplicable_compute(List argList) {
        if (this.isVariableArity() && argList.getNumChild() < this.arity() - 1) {
            return false;
        }
        return this.isVariableArity() || this.arity() == argList.getNumChild();
    }

    public int arity() {
        ASTNode$State state = this.state();
        int arity_value = this.arity_compute();
        return arity_value;
    }

    private int arity_compute() {
        return this.getNumParameter();
    }

    public boolean isVariableArity() {
        ASTNode$State state = this.state();
        boolean isVariableArity_value = this.isVariableArity_compute();
        return isVariableArity_value;
    }

    private boolean isVariableArity_compute() {
        return this.getNumParameter() == 0 ? false : this.getParameter(this.getNumParameter() - 1).isVariableArity();
    }

    public ParameterDeclaration lastParameter() {
        ASTNode$State state = this.state();
        ParameterDeclaration lastParameter_value = this.lastParameter_compute();
        return lastParameter_value;
    }

    private ParameterDeclaration lastParameter_compute() {
        return this.getParameter(this.getNumParameter() - 1);
    }

    public ConstructorDecl erasedConstructor() {
        ASTNode$State state = this.state();
        ConstructorDecl erasedConstructor_value = this.erasedConstructor_compute();
        return erasedConstructor_value;
    }

    private ConstructorDecl erasedConstructor_compute() {
        return this;
    }

    @Override
    public boolean needsSignatureAttribute() {
        ASTNode$State state = this.state();
        boolean needsSignatureAttribute_value = this.needsSignatureAttribute_compute();
        return needsSignatureAttribute_value;
    }

    private boolean needsSignatureAttribute_compute() {
        int i = 0;
        while (i < this.getNumParameter()) {
            if (this.getParameter(i).type().needsSignatureAttribute()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hasSource() {
        ASTNode$State state = this.state();
        boolean hasSource_value = this.hasSource_compute();
        return hasSource_value;
    }

    private boolean hasSource_compute() {
        return this.hostType().compilationUnit().fromSource();
    }

    public Expr drive(MethodDecl m, List<Expr> consArgList, List<Expr> methodArgList) {
        ASTNode$State state = this.state();
        Expr drive_MethodDecl_List_Expr__List_Expr__value = this.drive_compute(m, consArgList, methodArgList);
        return drive_MethodDecl_List_Expr__List_Expr__value;
    }

    private Expr drive_compute(MethodDecl m, List<Expr> consArgList, List<Expr> methodArgList) {
        ParameterDeclaration pd;
        Environment env = new Environment();
        env.inStack(null);
        env.inFrame();
        int i = 0;
        while (i < this.getParameterList().getNumChild()) {
            pd = this.getParameter(i);
            env.add(pd, (Expr)consArgList.getChild(i));
            ++i;
        }
        this.getBlock().spe(env);
        i = 0;
        while (i < m.getParameterList().getNumChild()) {
            pd = this.getParameter(i);
            env.add(pd, (Expr)methodArgList.getChild(i));
            ++i;
        }
        Expr ret = m.getBlock().spe(env);
        env.outFrame();
        env.outStack();
        return ret;
    }

    public boolean handlesException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.handlesException_TypeDecl_values == null) {
            this.handlesException_TypeDecl_values = new HashMap(4);
        }
        if (this.handlesException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.handlesException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.handlesException_TypeDecl_values.put(_parameters, handlesException_TypeDecl_value);
        }
        return handlesException_TypeDecl_value;
    }

    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.hasConstructorInvocation() ? this.getConstructorInvocation().isDAafter(v) : this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.hasConstructorInvocation() ? this.getConstructorInvocation().isDUafter(v) : this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return this.throwsException(exceptionType) || this.handlesException(exceptionType);
        }
        if (caller == this.getBlockNoTransform()) {
            return this.throwsException(exceptionType) || this.handlesException(exceptionType);
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            ArrayList<MethodDecl> c = new ArrayList<MethodDecl>();
            for (MethodDecl m : this.lookupMethod(name)) {
                if (this.hostType().memberMethods(name).contains(m) && !m.isStatic()) continue;
                c.add(m);
            }
            return c;
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.parameterDeclaration(name);
        }
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            SimpleSet set = this.parameterDeclaration(name);
            if (!set.isEmpty()) {
                return set;
            }
            Iterator iter = this.lookupVariable(name).iterator();
            while (iter.hasNext()) {
                Variable v = (Variable)iter.next();
                if (this.hostType().memberFields(name).contains(v) && !v.isStatic()) continue;
                set = set.add(v);
            }
            return set;
        }
        if (caller == this.getBlockNoTransform()) {
            SimpleSet set = this.parameterDeclaration(name);
            if (!set.isEmpty()) {
                return set;
            }
            return this.lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    @Override
    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this;
        }
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        if (caller == this.getExceptionListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingInstance(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return this.unknownType();
        }
        return this.getParent().Define_TypeDecl_enclosingInstance(this, caller);
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_inExplicitConstructorInvocation(this, caller);
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return false;
        }
        if (caller == this.getBlockNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return !this.hasConstructorInvocation() ? true : this.getConstructorInvocation().canCompleteNormally();
        }
        if (caller == this.getConstructorInvocationOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isMethodParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return this.getParent().Define_boolean_isConstructorParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isExceptionHandlerParameter(this, caller);
    }

    @Override
    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this.getNumParameter() == 0 ? this.localNumOfFirstParameter() : this.getParameter(this.getNumParameter() - 1).localNum() + this.getParameter(this.getNumParameter() - 1).type().variableSize();
        }
        if (caller == this.getParameterListNoTransform()) {
            int index = caller.getIndexOfChild(child);
            return index == 0 ? this.localNumOfFirstParameter() : this.getParameter(index - 1).localNum() + this.getParameter(index - 1).type().variableSize();
        }
        return this.getParent().Define_int_localNum(this, caller);
    }

    @Override
    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getModifiersNoTransform()) {
            return name.equals("CONSTRUCTOR");
        }
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    @Override
    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return i == this.getNumParameter() - 1;
        }
        return this.getParent().Define_boolean_variableArityValid(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        if (!this.hasConstructorInvocation() && !this.hostType().isObject()) {
            ++this.state().duringLookupConstructor;
            ConstructorDecl result = this.rewriteRule0();
            --this.state().duringLookupConstructor;
            return result;
        }
        return super.rewriteTo();
    }

    private ConstructorDecl rewriteRule0() {
        this.setConstructorInvocation(new ExprStmt(new SuperConstructorAccess("super", new List<Expr>())));
        return this;
    }
}

