/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AbstractDot;
import AST.Access;
import AST.BodyDecl;
import AST.BooleanLiteral;
import AST.BooleanType;
import AST.CodeGeneration;
import AST.Constant;
import AST.ConstructorDecl;
import AST.Dot;
import AST.ExprStmt;
import AST.FieldDeclaration;
import AST.List;
import AST.Literal;
import AST.MethodAccess;
import AST.NameType;
import AST.ObjectLiteral;
import AST.ParExpr;
import AST.ParameterDeclaration;
import AST.SimpleSet;
import AST.Stmt;
import AST.ThisAccess;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.VarAccess;
import AST.Variable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jpe.Environment;
import jpe.Util;
import jpe.error.UnInlinableException;

public abstract class Expr
extends ASTNode<ASTNode>
implements Cloneable {
    protected boolean false_label_computed = false;
    protected int false_label_value;
    protected boolean true_label_computed = false;
    protected int true_label_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.false_label_computed = false;
        this.true_label_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Expr clone() throws CloneNotSupportedException {
        Expr node = (Expr)super.clone();
        node.false_label_computed = false;
        node.true_label_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public SimpleSet keepAccessibleTypes(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        TypeDecl hostType = this.hostType();
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            TypeDecl t = (TypeDecl)iter.next();
            if ((hostType == null || !t.accessibleFrom(hostType)) && (hostType != null || !t.accessibleFromPackage(this.hostPackage()))) continue;
            newSet = newSet.add(t);
        }
        return newSet;
    }

    public SimpleSet keepAccessibleFields(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            FieldDeclaration f;
            Variable v = (Variable)iter.next();
            if (!(v instanceof FieldDeclaration) || !this.mayAccess(f = (FieldDeclaration)v)) continue;
            newSet = newSet.add(f);
        }
        return newSet;
    }

    public boolean mayAccess(FieldDeclaration f) {
        if (f.isPublic()) {
            return true;
        }
        if (f.isProtected()) {
            if (f.hostPackage().equals(this.hostPackage())) {
                return true;
            }
            TypeDecl C = f.hostType();
            TypeDecl S = this.hostType().subclassWithinBody(C);
            TypeDecl Q = this.type();
            if (S == null) {
                return false;
            }
            if (f.isInstanceVariable() && !this.isSuperAccess()) {
                return Q.instanceOf(S);
            }
            return true;
        }
        if (f.isPrivate()) {
            return f.hostType().topLevelType() == this.hostType().topLevelType();
        }
        return f.hostPackage().equals(this.hostType().hostPackage());
    }

    public Dot qualifiesAccess(Access access) {
        Dot dot = new Dot(this, access);
        return dot;
    }

    public void emitStore(CodeGeneration gen) {
        this.error("emitStore called with " + this.getClass().getName());
    }

    void emitOperation(CodeGeneration gen) {
        this.error();
    }

    protected boolean needsPush() {
        ASTNode n = this.getParent();
        while (n instanceof ParExpr) {
            n = n.getParent();
        }
        return !(n instanceof ExprStmt);
    }

    public void createAssignSimpleLoadDest(CodeGeneration gen) {
    }

    public void createPushAssignmentResult(CodeGeneration gen) {
    }

    public void createAssignLoadDest(CodeGeneration gen) {
    }

    protected void emitBooleanCondition(CodeGeneration gen) {
        this.emitEvalBranch(gen);
        int end_label = this.hostType().constantPool().newLabel();
        gen.addLabel(this.false_label());
        BooleanLiteral.push(gen, false);
        gen.emitGoto(end_label);
        gen.changeStackDepth(-1);
        gen.addLabel(this.true_label());
        BooleanLiteral.push(gen, true);
        gen.addLabel(end_label);
    }

    public void refined_CreateBCode_Expr_emitEvalBranch(CodeGeneration gen) {
        if (this.isTrue()) {
            gen.emitGoto(this.true_label());
        } else if (this.isFalse()) {
            gen.emitGoto(this.false_label());
        } else {
            this.createBCode(gen);
            gen.emitCompare((byte)-102, this.true_label());
            gen.emitGoto(this.false_label());
        }
    }

    protected SimpleSet chooseConstructor(Collection constructors, List argList) {
        ConstructorDecl decl;
        SimpleSet potentiallyApplicable = SimpleSet.emptySet;
        for (ConstructorDecl decl2 : constructors) {
            if (!decl2.potentiallyApplicable(argList) || !decl2.accessibleFrom(this.hostType())) continue;
            potentiallyApplicable = potentiallyApplicable.add(decl2);
        }
        SimpleSet maxSpecific = SimpleSet.emptySet;
        Iterator iter = potentiallyApplicable.iterator();
        while (iter.hasNext()) {
            decl = (ConstructorDecl)iter.next();
            if (!decl.applicableBySubtyping(argList)) continue;
            maxSpecific = Expr.mostSpecific(maxSpecific, decl);
        }
        if (maxSpecific.isEmpty()) {
            iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                decl = (ConstructorDecl)iter.next();
                if (!decl.applicableByMethodInvocationConversion(argList)) continue;
                maxSpecific = Expr.mostSpecific(maxSpecific, decl);
            }
        }
        if (maxSpecific.isEmpty()) {
            iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                decl = (ConstructorDecl)iter.next();
                if (!decl.isVariableArity() || !decl.applicableVariableArity(argList)) continue;
                maxSpecific = Expr.mostSpecific(maxSpecific, decl);
            }
        }
        return maxSpecific;
    }

    protected static SimpleSet mostSpecific(SimpleSet maxSpecific, ConstructorDecl decl) {
        if (maxSpecific.isEmpty()) {
            maxSpecific = maxSpecific.add(decl);
        } else if (decl.moreSpecificThan((ConstructorDecl)maxSpecific.iterator().next())) {
            maxSpecific = SimpleSet.emptySet.add(decl);
        } else if (!((ConstructorDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) {
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    public Expr inline(Map<ParameterDeclaration, Expr> paramVarMap) throws UnInlinableException {
        throw new UnInlinableException();
    }

    public static boolean isStatic(Expr target) {
        if (target == null) {
            return true;
        }
        return target instanceof Literal || target instanceof TypeAccess;
    }

    public boolean canRemove(Map<String, Boolean> usedVars) {
        return false;
    }

    public void addUsedVars(Map<String, Boolean> usedVars) {
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void emitEvalBranch(CodeGeneration gen) {
        if (this.type().isReferenceType()) {
            this.createBCode(gen);
            this.type().emitUnboxingOperation(gen);
            gen.emitCompare((byte)-103, this.false_label());
            gen.emitGoto(this.true_label());
        } else {
            this.refined_CreateBCode_Expr_emitEvalBranch(gen);
        }
    }

    public abstract TypeDecl type();

    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    public boolean isPositive() {
        ASTNode$State state = this.state();
        boolean isPositive_value = this.isPositive_compute();
        return isPositive_value;
    }

    private boolean isPositive_compute() {
        return false;
    }

    public boolean representableIn(TypeDecl t) {
        ASTNode$State state = this.state();
        boolean representableIn_TypeDecl_value = this.representableIn_compute(t);
        return representableIn_TypeDecl_value;
    }

    private boolean representableIn_compute(TypeDecl t) {
        if (!(this.type().isByte() || this.type().isChar() || this.type().isShort() || this.type().isInt())) {
            return false;
        }
        if (t.isByte()) {
            return this.constant().intValue() >= -128 && this.constant().intValue() <= 127;
        }
        if (t.isChar()) {
            return this.constant().intValue() >= 0 && this.constant().intValue() <= 65535;
        }
        if (t.isShort()) {
            return this.constant().intValue() >= Short.MIN_VALUE && this.constant().intValue() <= Short.MAX_VALUE;
        }
        if (t.isInt()) {
            return this.constant().intValue() >= Integer.MIN_VALUE && this.constant().intValue() <= Integer.MAX_VALUE;
        }
        return false;
    }

    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return false;
    }

    public boolean isTrue() {
        ASTNode$State state = this.state();
        boolean isTrue_value = this.isTrue_compute();
        return isTrue_value;
    }

    private boolean isTrue_compute() {
        return this.isConstant() && this.type() instanceof BooleanType && this.constant().booleanValue();
    }

    public boolean isFalse() {
        ASTNode$State state = this.state();
        boolean isFalse_value = this.isFalse_compute();
        return isFalse_value;
    }

    private boolean isFalse_compute() {
        return this.isConstant() && this.type() instanceof BooleanType && !this.constant().booleanValue();
    }

    public Variable varDecl() {
        ASTNode$State state = this.state();
        Variable varDecl_value = this.varDecl_compute();
        return varDecl_value;
    }

    private Variable varDecl_compute() {
        return null;
    }

    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.isTrue() || this.isDAbefore(v);
    }

    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.isFalse() || this.isDAbefore(v);
    }

    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.isDAafterFalse(v) && this.isDAafterTrue(v) || this.isDAbefore(v);
    }

    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterFalse_Variable_value = this.isDUafterFalse_compute(v);
        return isDUafterFalse_Variable_value;
    }

    private boolean isDUafterFalse_compute(Variable v) {
        if (this.isTrue()) {
            return true;
        }
        return this.isDUbefore(v);
    }

    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterTrue_Variable_value = this.isDUafterTrue_compute(v);
        return isDUafterTrue_Variable_value;
    }

    private boolean isDUafterTrue_compute(Variable v) {
        if (this.isFalse()) {
            return true;
        }
        return this.isDUbefore(v);
    }

    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.isDUafterFalse(v) && this.isDUafterTrue(v) || this.isDUbefore(v);
    }

    public SimpleSet mostSpecificConstructor(Collection constructors) {
        ASTNode$State state = this.state();
        SimpleSet mostSpecificConstructor_Collection_value = this.mostSpecificConstructor_compute(constructors);
        return mostSpecificConstructor_Collection_value;
    }

    private SimpleSet mostSpecificConstructor_compute(Collection constructors) {
        SimpleSet maxSpecific = SimpleSet.emptySet;
        for (ConstructorDecl decl : constructors) {
            if (!this.applicableAndAccessible(decl)) continue;
            if (maxSpecific.isEmpty()) {
                maxSpecific = maxSpecific.add(decl);
                continue;
            }
            if (decl.moreSpecificThan((ConstructorDecl)maxSpecific.iterator().next())) {
                maxSpecific = SimpleSet.emptySet.add(decl);
                continue;
            }
            if (((ConstructorDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) continue;
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    public boolean applicableAndAccessible(ConstructorDecl decl) {
        ASTNode$State state = this.state();
        boolean applicableAndAccessible_ConstructorDecl_value = this.applicableAndAccessible_compute(decl);
        return applicableAndAccessible_ConstructorDecl_value;
    }

    private boolean applicableAndAccessible_compute(ConstructorDecl decl) {
        return false;
    }

    public boolean hasQualifiedPackage(String packageName) {
        ASTNode$State state = this.state();
        boolean hasQualifiedPackage_String_value = this.hasQualifiedPackage_compute(packageName);
        return hasQualifiedPackage_String_value;
    }

    private boolean hasQualifiedPackage_compute(String packageName) {
        return false;
    }

    public SimpleSet qualifiedLookupType(String name) {
        ASTNode$State state = this.state();
        SimpleSet qualifiedLookupType_String_value = this.qualifiedLookupType_compute(name);
        return qualifiedLookupType_String_value;
    }

    private SimpleSet qualifiedLookupType_compute(String name) {
        return this.keepAccessibleTypes(this.type().memberTypes(name));
    }

    public SimpleSet qualifiedLookupVariable(String name) {
        ASTNode$State state = this.state();
        SimpleSet qualifiedLookupVariable_String_value = this.qualifiedLookupVariable_compute(name);
        return qualifiedLookupVariable_String_value;
    }

    private SimpleSet qualifiedLookupVariable_compute(String name) {
        if (this.type().accessibleFrom(this.hostType())) {
            return this.keepAccessibleFields(this.type().memberFields(name));
        }
        return SimpleSet.emptySet;
    }

    public String packageName() {
        ASTNode$State state = this.state();
        String packageName_value = this.packageName_compute();
        return packageName_value;
    }

    private String packageName_compute() {
        return "";
    }

    public String typeName() {
        ASTNode$State state = this.state();
        String typeName_value = this.typeName_compute();
        return typeName_value;
    }

    private String typeName_compute() {
        return "";
    }

    public boolean isTypeAccess() {
        ASTNode$State state = this.state();
        boolean isTypeAccess_value = this.isTypeAccess_compute();
        return isTypeAccess_value;
    }

    private boolean isTypeAccess_compute() {
        return false;
    }

    public boolean isMethodAccess() {
        ASTNode$State state = this.state();
        boolean isMethodAccess_value = this.isMethodAccess_compute();
        return isMethodAccess_value;
    }

    private boolean isMethodAccess_compute() {
        return false;
    }

    public boolean isFieldAccess() {
        ASTNode$State state = this.state();
        boolean isFieldAccess_value = this.isFieldAccess_compute();
        return isFieldAccess_value;
    }

    private boolean isFieldAccess_compute() {
        return false;
    }

    public boolean isSuperAccess() {
        ASTNode$State state = this.state();
        boolean isSuperAccess_value = this.isSuperAccess_compute();
        return isSuperAccess_value;
    }

    private boolean isSuperAccess_compute() {
        return false;
    }

    public boolean isThisAccess() {
        ASTNode$State state = this.state();
        boolean isThisAccess_value = this.isThisAccess_compute();
        return isThisAccess_value;
    }

    private boolean isThisAccess_compute() {
        return false;
    }

    public boolean isPackageAccess() {
        ASTNode$State state = this.state();
        boolean isPackageAccess_value = this.isPackageAccess_compute();
        return isPackageAccess_value;
    }

    private boolean isPackageAccess_compute() {
        return false;
    }

    public boolean isArrayAccess() {
        ASTNode$State state = this.state();
        boolean isArrayAccess_value = this.isArrayAccess_compute();
        return isArrayAccess_value;
    }

    private boolean isArrayAccess_compute() {
        return false;
    }

    public boolean isClassAccess() {
        ASTNode$State state = this.state();
        boolean isClassAccess_value = this.isClassAccess_compute();
        return isClassAccess_value;
    }

    private boolean isClassAccess_compute() {
        return false;
    }

    public boolean isSuperConstructorAccess() {
        ASTNode$State state = this.state();
        boolean isSuperConstructorAccess_value = this.isSuperConstructorAccess_compute();
        return isSuperConstructorAccess_value;
    }

    private boolean isSuperConstructorAccess_compute() {
        return false;
    }

    public boolean isLeftChildOfDot() {
        ASTNode$State state = this.state();
        boolean isLeftChildOfDot_value = this.isLeftChildOfDot_compute();
        return isLeftChildOfDot_value;
    }

    private boolean isLeftChildOfDot_compute() {
        return this.hasParentDot() && this.parentDot().getLeft() == this;
    }

    public boolean isRightChildOfDot() {
        ASTNode$State state = this.state();
        boolean isRightChildOfDot_value = this.isRightChildOfDot_compute();
        return isRightChildOfDot_value;
    }

    private boolean isRightChildOfDot_compute() {
        return this.hasParentDot() && this.parentDot().getRight() == this;
    }

    public AbstractDot parentDot() {
        ASTNode$State state = this.state();
        AbstractDot parentDot_value = this.parentDot_compute();
        return parentDot_value;
    }

    private AbstractDot parentDot_compute() {
        return this.getParent() instanceof AbstractDot ? (AbstractDot)this.getParent() : null;
    }

    public boolean hasParentDot() {
        ASTNode$State state = this.state();
        boolean hasParentDot_value = this.hasParentDot_compute();
        return hasParentDot_value;
    }

    private boolean hasParentDot_compute() {
        return this.parentDot() != null;
    }

    public Access nextAccess() {
        ASTNode$State state = this.state();
        Access nextAccess_value = this.nextAccess_compute();
        return nextAccess_value;
    }

    private Access nextAccess_compute() {
        return this.parentDot().nextAccess();
    }

    public boolean hasNextAccess() {
        ASTNode$State state = this.state();
        boolean hasNextAccess_value = this.hasNextAccess_compute();
        return hasNextAccess_value;
    }

    private boolean hasNextAccess_compute() {
        return this.isLeftChildOfDot();
    }

    public Stmt enclosingStmt() {
        ASTNode$State state = this.state();
        Stmt enclosingStmt_value = this.enclosingStmt_compute();
        return enclosingStmt_value;
    }

    private Stmt enclosingStmt_compute() {
        ASTNode node = this;
        while (node != null && !(node instanceof Stmt)) {
            node = node.getParent();
        }
        return (Stmt)node;
    }

    public boolean isVariable() {
        ASTNode$State state = this.state();
        boolean isVariable_value = this.isVariable_compute();
        return isVariable_value;
    }

    private boolean isVariable_compute() {
        return false;
    }

    public boolean isUnknown() {
        ASTNode$State state = this.state();
        boolean isUnknown_value = this.isUnknown_compute();
        return isUnknown_value;
    }

    private boolean isUnknown_compute() {
        return this.type().isUnknown();
    }

    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean staticContextQualifier_value = this.staticContextQualifier_compute();
        return staticContextQualifier_value;
    }

    private boolean staticContextQualifier_compute() {
        return false;
    }

    public boolean needsPop() {
        ASTNode$State state = this.state();
        boolean needsPop_value = this.needsPop_compute();
        return needsPop_value;
    }

    private boolean needsPop_compute() {
        return true;
    }

    public boolean isVarAccessWithAccessor() {
        ASTNode$State state = this.state();
        boolean isVarAccessWithAccessor_value = this.isVarAccessWithAccessor_compute();
        return isVarAccessWithAccessor_value;
    }

    private boolean isVarAccessWithAccessor_compute() {
        return false;
    }

    public int false_label() {
        if (this.false_label_computed) {
            return this.false_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.false_label_value = this.false_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.false_label_computed = true;
        }
        return this.false_label_value;
    }

    private int false_label_compute() {
        return this.getParent().definesLabel() ? this.condition_false_label() : this.hostType().constantPool().newLabel();
    }

    public int true_label() {
        if (this.true_label_computed) {
            return this.true_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.true_label_value = this.true_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.true_label_computed = true;
        }
        return this.true_label_value;
    }

    private int true_label_compute() {
        return this.getParent().definesLabel() ? this.condition_true_label() : this.hostType().constantPool().newLabel();
    }

    public boolean canBeTrue() {
        ASTNode$State state = this.state();
        boolean canBeTrue_value = this.canBeTrue_compute();
        return canBeTrue_value;
    }

    private boolean canBeTrue_compute() {
        return !this.isFalse();
    }

    public boolean canBeFalse() {
        ASTNode$State state = this.state();
        boolean canBeFalse_value = this.canBeFalse_compute();
        return canBeFalse_value;
    }

    private boolean canBeFalse_compute() {
        return !this.isTrue();
    }

    public Literal invoke(Environment env, MethodAccess ma, List<Expr> actualParams) {
        ASTNode$State state = this.state();
        Literal invoke_jpe_Environment_MethodAccess_List_Expr__value = this.invoke_compute(env, ma, actualParams);
        return invoke_jpe_Environment_MethodAccess_List_Expr__value;
    }

    private Literal invoke_compute(Environment env, MethodAccess ma, List<Expr> actualParams) {
        throw new Error("There is no such invoke method this the expr: " + this);
    }

    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        throw new Error("bad literal");
    }

    public boolean isInlinableArg() {
        ASTNode$State state = this.state();
        boolean isInlinableArg_value = this.isInlinableArg_compute();
        return isInlinableArg_value;
    }

    private boolean isInlinableArg_compute() {
        if (this.isImmutable()) {
            return true;
        }
        if (this instanceof ThisAccess) {
            return true;
        }
        if (!(this instanceof VarAccess)) {
            return false;
        }
        VarAccess v = (VarAccess)this;
        return v.type().isPrimitiveType();
    }

    @Override
    public boolean isCompileTime(Environment env) {
        ASTNode$State state = this.state();
        boolean isCompileTime_jpe_Environment_value = this.isCompileTime_compute(env);
        return isCompileTime_jpe_Environment_value;
    }

    private boolean isCompileTime_compute(Environment env) {
        return false;
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        return this;
    }

    @Override
    public Expr peCatch(Environment env) {
        ASTNode$State state = this.state();
        Expr peCatch_jpe_Environment_value = this.peCatch_compute(env);
        return peCatch_jpe_Environment_value;
    }

    private Expr peCatch_compute(Environment env) {
        try {
            return this.pe(env);
        }
        catch (RuntimeException e) {
            Util.assertTrue(false, this.sourceFile(), this.lineNumber(), e.getMessage());
            throw e;
        }
    }

    public boolean isImmutable() {
        ASTNode$State state = this.state();
        boolean isImmutable_value = this.isImmutable_compute();
        return isImmutable_value;
    }

    private boolean isImmutable_compute() {
        if (!(this instanceof Literal)) {
            return false;
        }
        return !(this instanceof ObjectLiteral);
    }

    @Override
    public Expr spe(Environment env) {
        ASTNode$State state = this.state();
        Expr spe_jpe_Environment_value = this.spe_compute(env);
        return spe_jpe_Environment_value;
    }

    private Expr spe_compute(Environment env) {
        Expr ast = (Expr)this.fullCopy();
        int i = 0;
        while (i < this.getNumChild()) {
            ast.setChild(((ASTNode)this.getChild(i)).fullCopy().spe(env), i);
            ++i;
        }
        return ast;
    }

    public boolean isDest() {
        ASTNode$State state = this.state();
        boolean isDest_value = this.getParent().Define_boolean_isDest(this, null);
        return isDest_value;
    }

    public boolean isSource() {
        ASTNode$State state = this.state();
        boolean isSource_value = this.getParent().Define_boolean_isSource(this, null);
        return isSource_value;
    }

    public boolean isIncOrDec() {
        ASTNode$State state = this.state();
        boolean isIncOrDec_value = this.getParent().Define_boolean_isIncOrDec(this, null);
        return isIncOrDec_value;
    }

    public boolean isDAbefore(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAbefore_Variable_value = this.getParent().Define_boolean_isDAbefore(this, null, v);
        return isDAbefore_Variable_value;
    }

    public boolean isDUbefore(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUbefore_Variable_value = this.getParent().Define_boolean_isDUbefore(this, null, v);
        return isDUbefore_Variable_value;
    }

    public Collection lookupMethod(String name) {
        ASTNode$State state = this.state();
        Collection lookupMethod_String_value = this.getParent().Define_Collection_lookupMethod(this, null, name);
        return lookupMethod_String_value;
    }

    public TypeDecl typeBoolean() {
        ASTNode$State state = this.state();
        TypeDecl typeBoolean_value = this.getParent().Define_TypeDecl_typeBoolean(this, null);
        return typeBoolean_value;
    }

    public TypeDecl typeByte() {
        ASTNode$State state = this.state();
        TypeDecl typeByte_value = this.getParent().Define_TypeDecl_typeByte(this, null);
        return typeByte_value;
    }

    public TypeDecl typeShort() {
        ASTNode$State state = this.state();
        TypeDecl typeShort_value = this.getParent().Define_TypeDecl_typeShort(this, null);
        return typeShort_value;
    }

    public TypeDecl typeChar() {
        ASTNode$State state = this.state();
        TypeDecl typeChar_value = this.getParent().Define_TypeDecl_typeChar(this, null);
        return typeChar_value;
    }

    public TypeDecl typeInt() {
        ASTNode$State state = this.state();
        TypeDecl typeInt_value = this.getParent().Define_TypeDecl_typeInt(this, null);
        return typeInt_value;
    }

    public TypeDecl typeLong() {
        ASTNode$State state = this.state();
        TypeDecl typeLong_value = this.getParent().Define_TypeDecl_typeLong(this, null);
        return typeLong_value;
    }

    public TypeDecl typeFloat() {
        ASTNode$State state = this.state();
        TypeDecl typeFloat_value = this.getParent().Define_TypeDecl_typeFloat(this, null);
        return typeFloat_value;
    }

    public TypeDecl typeDouble() {
        ASTNode$State state = this.state();
        TypeDecl typeDouble_value = this.getParent().Define_TypeDecl_typeDouble(this, null);
        return typeDouble_value;
    }

    public TypeDecl typeString() {
        ASTNode$State state = this.state();
        TypeDecl typeString_value = this.getParent().Define_TypeDecl_typeString(this, null);
        return typeString_value;
    }

    public TypeDecl typeVoid() {
        ASTNode$State state = this.state();
        TypeDecl typeVoid_value = this.getParent().Define_TypeDecl_typeVoid(this, null);
        return typeVoid_value;
    }

    public TypeDecl typeNull() {
        ASTNode$State state = this.state();
        TypeDecl typeNull_value = this.getParent().Define_TypeDecl_typeNull(this, null);
        return typeNull_value;
    }

    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public boolean hasPackage(String packageName) {
        ASTNode$State state = this.state();
        boolean hasPackage_String_value = this.getParent().Define_boolean_hasPackage(this, null, packageName);
        return hasPackage_String_value;
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        ASTNode$State state = this.state();
        TypeDecl lookupType_String_String_value = this.getParent().Define_TypeDecl_lookupType(this, null, packageName, typeName);
        return lookupType_String_String_value;
    }

    public SimpleSet lookupType(String name) {
        ASTNode$State state = this.state();
        SimpleSet lookupType_String_value = this.getParent().Define_SimpleSet_lookupType(this, null, name);
        return lookupType_String_value;
    }

    public SimpleSet lookupVariable(String name) {
        ASTNode$State state = this.state();
        SimpleSet lookupVariable_String_value = this.getParent().Define_SimpleSet_lookupVariable(this, null, name);
        return lookupVariable_String_value;
    }

    public NameType nameType() {
        ASTNode$State state = this.state();
        NameType nameType_value = this.getParent().Define_NameType_nameType(this, null);
        return nameType_value;
    }

    public BodyDecl enclosingBodyDecl() {
        ASTNode$State state = this.state();
        BodyDecl enclosingBodyDecl_value = this.getParent().Define_BodyDecl_enclosingBodyDecl(this, null);
        return enclosingBodyDecl_value;
    }

    public String hostPackage() {
        ASTNode$State state = this.state();
        String hostPackage_value = this.getParent().Define_String_hostPackage(this, null);
        return hostPackage_value;
    }

    public TypeDecl hostType() {
        ASTNode$State state = this.state();
        TypeDecl hostType_value = this.getParent().Define_TypeDecl_hostType(this, null);
        return hostType_value;
    }

    public String methodHost() {
        ASTNode$State state = this.state();
        String methodHost_value = this.getParent().Define_String_methodHost(this, null);
        return methodHost_value;
    }

    public boolean inStaticContext() {
        ASTNode$State state = this.state();
        boolean inStaticContext_value = this.getParent().Define_boolean_inStaticContext(this, null);
        return inStaticContext_value;
    }

    public int condition_false_label() {
        ASTNode$State state = this.state();
        int condition_false_label_value = this.getParent().Define_int_condition_false_label(this, null);
        return condition_false_label_value;
    }

    public int condition_true_label() {
        ASTNode$State state = this.state();
        int condition_true_label_value = this.getParent().Define_int_condition_true_label(this, null);
        return condition_true_label_value;
    }

    public TypeDecl assignConvertedType() {
        ASTNode$State state = this.state();
        TypeDecl assignConvertedType_value = this.getParent().Define_TypeDecl_assignConvertedType(this, null);
        return assignConvertedType_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

