/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Literal;
import AST.TypeDecl;
import beaver.Symbol;

public class FloatingPointLiteral
extends Literal
implements Cloneable {
    protected boolean isZero_computed = false;
    protected boolean isZero_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isZero_computed = false;
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public FloatingPointLiteral clone() throws CloneNotSupportedException {
        FloatingPointLiteral node = (FloatingPointLiteral)super.clone();
        node.isZero_computed = false;
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public FloatingPointLiteral copy() {
        try {
            FloatingPointLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public FloatingPointLiteral fullCopy() {
        FloatingPointLiteral res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
        s.append("F");
    }

    @Override
    public void typeCheck() {
        if (!this.isZero() && this.constant().floatValue() == 0.0f) {
            this.error("It is an error for nonzero floating-point " + this.getLITERAL() + " to round to zero");
        }
        if (this.constant().floatValue() == Float.NEGATIVE_INFINITY || this.constant().floatValue() == Float.POSITIVE_INFINITY) {
            this.error("It is an error for floating-point " + this.getLITERAL() + " to round to an infinity");
        }
    }

    public static void push(CodeGeneration gen, float value) {
        if (value == 0.0f) {
            gen.emit((byte)11);
        } else if (value == 1.0f) {
            gen.emit((byte)12);
        } else if (value == 2.0f) {
            gen.emit((byte)13);
        } else {
            int index = gen.constantPool().addConstant(value);
            if (index < 256) {
                gen.emit((byte)18).add(index);
            } else {
                gen.emit((byte)19).add2(index);
            }
        }
    }

    @Override
    public void emitPushConstant(CodeGeneration gen) {
        FloatingPointLiteral.push(gen, this.constant().floatValue());
    }

    public FloatingPointLiteral() {
    }

    public FloatingPointLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public FloatingPointLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public boolean isZero() {
        if (this.isZero_computed) {
            return this.isZero_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isZero_value = this.isZero_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isZero_computed = true;
        }
        return this.isZero_value;
    }

    private boolean isZero_compute() {
        String s = this.getLITERAL();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == 'E' || c == 'e') break;
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        try {
            return Constant.create(Float.parseFloat(this.getLITERAL()));
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0.0f);
            c.error = true;
            return c;
        }
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeFloat();
    }

    @Override
    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        return new Float(this.constant().floatValue());
    }

    @Override
    public Class<?> literalValueClass() {
        ASTNode$State state = this.state();
        Class<?> literalValueClass_value = this.literalValueClass_compute();
        return literalValueClass_value;
    }

    private Class<?> literalValueClass_compute() {
        return Float.TYPE;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

