/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.BytecodeReader;
import AST.CompilationUnit;
import AST.JavaParser;
import AST.Options;
import AST.Program;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class Frontend {
    protected Program program = new Program();

    protected Frontend() {
        this.program.state().reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(String[] args, BytecodeReader reader, JavaParser parser) {
        this.program.initBytecodeReader(reader);
        this.program.initJavaParser(parser);
        this.initOptions();
        this.processArgs(args);
        Collection files = this.program.options().files();
        if (this.program.options().hasOption("-version")) {
            this.printVersion();
            return false;
        }
        if (this.program.options().hasOption("-help") || files.isEmpty()) {
            this.printUsage();
            return false;
        }
        try {
            for (String name : files) {
                if (!new File(name).exists()) {
                    System.out.println("WARNING: file \"" + name + "\" does not exist");
                }
                this.program.addSourceFile(name);
            }
            Iterator iter = this.program.compilationUnitIterator();
            while (iter.hasNext()) {
                CompilationUnit unit = (CompilationUnit)iter.next();
                if (!unit.fromSource()) continue;
                Collection errors = unit.parseErrors();
                LinkedList warnings = new LinkedList();
                if (errors.isEmpty() || this.program.options().hasOption("-recover")) {
                    unit.errorCheck(errors, warnings);
                }
                if (!errors.isEmpty()) {
                    this.processErrors(errors, unit);
                    return false;
                }
                this.processWarnings(warnings, unit);
                this.processNoErrors(unit);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    protected void initOptions() {
        Options options = this.program.options();
        options.initOptions();
        options.addKeyOption("-version");
        options.addKeyOption("-print");
        options.addKeyOption("-g");
        options.addKeyOption("-g:none");
        options.addKeyOption("-g:lines,vars,source");
        options.addKeyOption("-nowarn");
        options.addKeyOption("-verbose");
        options.addKeyOption("-deprecation");
        options.addKeyValueOption("-classpath");
        options.addKeyValueOption("-sourcepath");
        options.addKeyValueOption("-bootclasspath");
        options.addKeyValueOption("-extdirs");
        options.addKeyValueOption("-d");
        options.addKeyValueOption("-encoding");
        options.addKeyValueOption("-source");
        options.addKeyValueOption("-target");
        options.addKeyOption("-help");
        options.addKeyOption("-O");
        options.addKeyOption("-J-Xmx128M");
        options.addKeyOption("-recover");
    }

    protected void processArgs(String[] args) {
        this.program.options().addOptions(args);
    }

    protected void processErrors(Collection errors, CompilationUnit unit) {
        System.out.println("Errors:");
        Iterator iter2 = errors.iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    protected void processWarnings(Collection warnings, CompilationUnit unit) {
        Iterator iter2 = warnings.iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    protected void processNoErrors(CompilationUnit unit) {
    }

    protected void printUsage() {
        this.printVersion();
        System.out.println("\n" + this.name() + "\n\n" + "Usage: java -jar civet.jar <options> <source files>\n" + "  -verbose                  Output messages about what the compiler is doing\n" + "  -classpath <path>         Specify where to find user class files\n" + "  -sourcepath <path>        Specify where to find input source files\n" + "  -bootclasspath <path>     Override location of bootstrap class files\n" + "  -extdirs <dirs>           Override location of installed extensions\n" + "  -d <directory>            Specify where to place generated class files\n" + "  -help                     Print a synopsis of standard options\n" + "  -version                  Print version information\n");
    }

    protected void printVersion() {
        System.out.println(String.valueOf(this.name()) + " " + this.url() + " Version " + this.version());
    }

    protected String name() {
        return "Civet";
    }

    protected String url() {
        return "(http://www.cs.utexas.edu/~amshali/index.php/Main/Civet)";
    }

    protected String version() {
        return "1.0";
    }
}

